/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.util.Map;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;

public class EnvironmentUtil {
    private static final String ENVIRONMENT_VARIABLE_PREFIX = "env:";

    private EnvironmentUtil() {
    }

    public static Map<String, String> resolveAll(Map<String, String> properties) {
        return EnvironmentUtil.resolveAll(System.getenv(), properties);
    }

    @VisibleForTesting
    static Map<String, String> resolveAll(Map<String, String> env, Map<String, String> properties) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        properties.forEach((name, value) -> {
            if (value.startsWith(ENVIRONMENT_VARIABLE_PREFIX)) {
                String resolved = (String)env.get(value.substring(ENVIRONMENT_VARIABLE_PREFIX.length()));
                if (resolved != null) {
                    builder.put(name, (Object)resolved);
                }
            } else {
                builder.put(name, value);
            }
        });
        return builder.build();
    }
}

