/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.catalog.generic;

import jakarta.annotation.Priority;
import jakarta.decorator.Decorator;
import jakarta.decorator.Delegate;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.service.catalog.CatalogPrefixParser;
import org.apache.polaris.service.catalog.api.PolarisCatalogGenericTableApiService;
import org.apache.polaris.service.catalog.common.CatalogAdapter;
import org.apache.polaris.service.catalog.generic.GenericTableCatalogAdapter;
import org.apache.polaris.service.events.CatalogGenericTableServiceEvents;
import org.apache.polaris.service.events.listeners.PolarisEventListener;
import org.apache.polaris.service.types.CreateGenericTableRequest;
import org.apache.polaris.service.types.LoadGenericTableResponse;

@Decorator
@Priority(value=1000)
public class CatalogGenericTableEventServiceDelegator
implements PolarisCatalogGenericTableApiService,
CatalogAdapter {
    @Inject
    @Delegate
    GenericTableCatalogAdapter delegate;
    @Inject
    PolarisEventListener polarisEventListener;
    @Inject
    CatalogPrefixParser prefixParser;

    public Response createGenericTable(String prefix, String namespace, CreateGenericTableRequest createGenericTableRequest, RealmContext realmContext, SecurityContext securityContext) {
        String catalogName = this.prefixParser.prefixToCatalogName(realmContext, prefix);
        this.polarisEventListener.onBeforeCreateGenericTable(new CatalogGenericTableServiceEvents.BeforeCreateGenericTableEvent(catalogName, namespace, createGenericTableRequest));
        Response resp = this.delegate.createGenericTable(prefix, namespace, createGenericTableRequest, realmContext, securityContext);
        this.polarisEventListener.onAfterCreateGenericTable(new CatalogGenericTableServiceEvents.AfterCreateGenericTableEvent(catalogName, namespace, ((LoadGenericTableResponse)resp.getEntity()).getTable()));
        return resp;
    }

    public Response dropGenericTable(String prefix, String namespace, String genericTable, RealmContext realmContext, SecurityContext securityContext) {
        String catalogName = this.prefixParser.prefixToCatalogName(realmContext, prefix);
        this.polarisEventListener.onBeforeDropGenericTable(new CatalogGenericTableServiceEvents.BeforeDropGenericTableEvent(catalogName, namespace, genericTable));
        Response resp = this.delegate.dropGenericTable(prefix, namespace, genericTable, realmContext, securityContext);
        this.polarisEventListener.onAfterDropGenericTable(new CatalogGenericTableServiceEvents.AfterDropGenericTableEvent(catalogName, namespace, genericTable));
        return resp;
    }

    public Response listGenericTables(String prefix, String namespace, String pageToken, Integer pageSize, RealmContext realmContext, SecurityContext securityContext) {
        String catalogName = this.prefixParser.prefixToCatalogName(realmContext, prefix);
        this.polarisEventListener.onBeforeListGenericTables(new CatalogGenericTableServiceEvents.BeforeListGenericTablesEvent(catalogName, namespace));
        Response resp = this.delegate.listGenericTables(prefix, namespace, pageToken, pageSize, realmContext, securityContext);
        this.polarisEventListener.onAfterListGenericTables(new CatalogGenericTableServiceEvents.AfterListGenericTablesEvent(catalogName, namespace));
        return resp;
    }

    public Response loadGenericTable(String prefix, String namespace, String genericTable, RealmContext realmContext, SecurityContext securityContext) {
        String catalogName = this.prefixParser.prefixToCatalogName(realmContext, prefix);
        this.polarisEventListener.onBeforeLoadGenericTable(new CatalogGenericTableServiceEvents.BeforeLoadGenericTableEvent(catalogName, namespace, genericTable));
        Response resp = this.delegate.loadGenericTable(prefix, namespace, genericTable, realmContext, securityContext);
        this.polarisEventListener.onAfterLoadGenericTable(new CatalogGenericTableServiceEvents.AfterLoadGenericTableEvent(catalogName, namespace, ((LoadGenericTableResponse)resp.getEntity()).getTable()));
        return resp;
    }
}

