/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.client;

import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.IClientPoolFactory;
import org.apache.iotdb.commons.client.ThriftClient;
import org.apache.iotdb.commons.client.exception.BorrowNullClientManagerException;
import org.apache.iotdb.commons.client.exception.ClientManagerException;
import org.apache.iotdb.commons.client.factory.AsyncThriftClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientManager<K, V>
implements IClientManager<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientManager.class);
    private final GenericKeyedObjectPool<K, V> pool;

    ClientManager(IClientPoolFactory<K, V> factory) {
        this.pool = factory.createClientPool(this);
    }

    public GenericKeyedObjectPool<K, V> getPool() {
        return this.pool;
    }

    @Override
    public V borrowClient(K node) throws ClientManagerException {
        if (node == null) {
            throw new BorrowNullClientManagerException();
        }
        try {
            return (V)this.pool.borrowObject(node);
        }
        catch (Exception e) {
            throw new ClientManagerException(e);
        }
    }

    public void returnClient(K node, V client) {
        if (node != null) {
            try {
                this.pool.returnObject(node, client);
            }
            catch (Exception e) {
                LOGGER.warn("Return client {} for node {} to pool failed.", new Object[]{client, node, e});
            }
        } else if (client instanceof ThriftClient) {
            ((ThriftClient)client).invalidateAll();
            LOGGER.warn("Return client {} to pool failed because the node is null. This may cause resource leak, please check your code.", client);
        }
    }

    public void returnClient(K node, V client, Function<Exception, Boolean> ignoreError) {
        if (node != null) {
            try {
                this.pool.returnObject(node, client);
            }
            catch (Exception e) {
                if (!Boolean.TRUE.equals(ignoreError.apply(e))) {
                    LOGGER.warn("Return client {} for node {} to pool failed.", new Object[]{client, node, e});
                }
            }
        } else if (client instanceof ThriftClient) {
            ((ThriftClient)client).invalidateAll();
            LOGGER.warn("Return client {} to pool failed because the node is null. This may cause resource leak, please check your code.", client);
        }
    }

    @Override
    public void clear(K node) {
        Optional.ofNullable(node).ifPresent(x -> {
            try {
                this.pool.clear(node);
            }
            catch (Exception e) {
                LOGGER.warn("Clear all client in pool for node {} failed.", node, (Object)e);
            }
        });
    }

    @Override
    public void close() {
        this.pool.close();
        if (this.pool.getFactory() instanceof AsyncThriftClientFactory) {
            ((AsyncThriftClientFactory)this.pool.getFactory()).close();
        }
    }
}

