/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.node;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Optional;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.SingleChildProcessNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.OrderingScheme;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class LimitNode
extends SingleChildProcessNode {
    private final long count;
    private final Optional<OrderingScheme> tiesResolvingScheme;

    public LimitNode(PlanNodeId id, PlanNode child, long count, Optional<OrderingScheme> tiesResolvingScheme) {
        super(id, child);
        this.count = count;
        this.tiesResolvingScheme = tiesResolvingScheme;
    }

    public boolean requiresPreSortedInputs() {
        return false;
    }

    public boolean isWithTies() {
        return this.tiesResolvingScheme.isPresent();
    }

    public Optional<OrderingScheme> getTiesResolvingScheme() {
        return this.tiesResolvingScheme;
    }

    @Override
    public PlanNode clone() {
        return new LimitNode(this.id, null, this.count, this.tiesResolvingScheme);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitLimit(this, context);
    }

    @Override
    public List<String> getOutputColumnNames() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.TABLE_LIMIT_NODE.serialize(byteBuffer);
        ReadWriteIOUtils.write((long)this.count, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.TABLE_LIMIT_NODE.serialize(stream);
        ReadWriteIOUtils.write((long)this.count, (OutputStream)stream);
    }

    public static LimitNode deserialize(ByteBuffer byteBuffer) {
        long count = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new LimitNode(planNodeId, null, count, null);
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return this.child.getOutputSymbols();
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new LimitNode(this.id, (PlanNode)Iterables.getOnlyElement(newChildren), this.count, this.tiesResolvingScheme);
    }

    public long getCount() {
        return this.count;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LimitNode limitNode = (LimitNode)o;
        return Objects.equal((Object)this.count, (Object)limitNode.count);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.count});
    }

    public String toString() {
        return "LimitNode-" + this.getPlanNodeId();
    }
}

