/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.CachingHierarchyManager;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.ZombieHierarchyManager;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateListener;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.LocalItemStateManager;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.NodeStateListener;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.state.StaleItemStateException;
import org.apache.jackrabbit.core.state.StateChangeDispatcher;
import org.apache.jackrabbit.core.state.UpdatableItemStateManager;
import org.apache.jackrabbit.spi.Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionItemStateManager
implements UpdatableItemStateManager,
NodeStateListener {
    private static Logger log = LoggerFactory.getLogger(SessionItemStateManager.class);
    private final LocalItemStateManager stateMgr;
    private CachingHierarchyManager hierMgr;
    private final Map<ItemId, ItemState> atticStore = Collections.synchronizedMap(new HashMap());
    private final Map<ItemId, ItemState> transientStore = Collections.synchronizedMap(new HashMap());
    private AtticItemStateManager attic;
    private final transient StateChangeDispatcher dispatcher = new StateChangeDispatcher();

    public SessionItemStateManager(NodeId rootNodeId, LocalItemStateManager stateMgr) {
        this.stateMgr = stateMgr;
        this.hierMgr = new CachingHierarchyManager(rootNodeId, this);
        this.addListener(this.hierMgr);
    }

    public HierarchyManager getHierarchyMgr() {
        return this.hierMgr;
    }

    public HierarchyManager getAtticAwareHierarchyMgr() {
        return new ZombieHierarchyManager(this.hierMgr, this, this.getAttic());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SessionItemStateManager (" + super.toString() + ")\n");
        builder.append("[transient]\n");
        builder.append(this.transientStore);
        builder.append("[attic]\n");
        builder.append(this.atticStore);
        return builder.toString();
    }

    @Override
    public ItemState getItemState(ItemId id) throws NoSuchItemStateException, ItemStateException {
        if (this.atticStore.containsKey(id)) {
            return this.getTransientItemState(id);
        }
        if (this.transientStore.containsKey(id)) {
            return this.getTransientItemState(id);
        }
        return this.stateMgr.getItemState(id);
    }

    @Override
    public boolean hasItemState(ItemId id) {
        if (this.atticStore.containsKey(id)) {
            return this.transientStore.containsKey(id);
        }
        if (this.transientStore.containsKey(id)) {
            return true;
        }
        return this.stateMgr.hasItemState(id);
    }

    @Override
    public NodeReferences getNodeReferences(NodeId id) throws NoSuchItemStateException, ItemStateException {
        return this.stateMgr.getNodeReferences(id);
    }

    @Override
    public boolean hasNodeReferences(NodeId id) {
        return this.stateMgr.hasNodeReferences(id);
    }

    @Override
    public void edit() throws IllegalStateException {
        this.stateMgr.edit();
    }

    @Override
    public boolean inEditMode() {
        return this.stateMgr.inEditMode();
    }

    @Override
    public NodeState createNew(NodeId id, Name nodeTypeName, NodeId parentId) throws RepositoryException {
        return this.stateMgr.createNew(id, nodeTypeName, parentId);
    }

    @Override
    public PropertyState createNew(Name propName, NodeId parentId) throws IllegalStateException {
        return this.stateMgr.createNew(propName, parentId);
    }

    public PropertyState createNew(PropertyState transientState) throws ItemStateException {
        PropertyState persistentState = this.createNew(transientState.getName(), transientState.getParentId());
        transientState.connect(persistentState);
        return persistentState;
    }

    @Override
    public void store(ItemState state) throws IllegalStateException {
        this.stateMgr.store(state);
    }

    @Override
    public void destroy(ItemState state) throws IllegalStateException {
        assert (state != null);
        this.stateMgr.destroy(state);
    }

    @Override
    public void cancel() throws IllegalStateException {
        this.stateMgr.cancel();
    }

    @Override
    public void update() throws ReferentialIntegrityException, StaleItemStateException, ItemStateException, IllegalStateException {
        this.stateMgr.update();
    }

    @Override
    public void dispose() {
        this.removeListener(this.hierMgr);
        this.disposeAllTransientItemStates();
    }

    public ItemState getTransientItemState(ItemId id) throws NoSuchItemStateException, ItemStateException {
        ItemState state = this.transientStore.get(id);
        if (state != null) {
            return state;
        }
        throw new NoSuchItemStateException(id.toString());
    }

    public boolean hasTransientItemState(ItemId id) {
        return this.transientStore.containsKey(id);
    }

    public boolean hasTransientItemStateInAttic(ItemId id) {
        return this.atticStore.containsKey(id);
    }

    public boolean hasAnyTransientItemStates() {
        return !this.transientStore.isEmpty();
    }

    public Collection<ItemState> getDescendantTransientItemStates(ItemId id) throws InvalidItemStateException, RepositoryException {
        try {
            return this.getDescendantItemStates(id, this.transientStore, this.getAtticAwareHierarchyMgr());
        }
        catch (ItemNotFoundException e) {
            throw new InvalidItemStateException("Item seems to have been removed externally", e);
        }
    }

    public Iterable<ItemState> getDescendantTransientItemStatesInAttic(ItemId id) throws RepositoryException {
        return this.getDescendantItemStates(id, this.atticStore, new ZombieHierarchyManager(this.hierMgr, this, this.getAttic()));
    }

    private List<ItemState> getDescendantItemStates(ItemId id, Map<ItemId, ItemState> store, HierarchyManager hierarchyManager) throws RepositoryException {
        if (id.denotesNode() && !store.isEmpty()) {
            ItemState[] states;
            TreeMap<Integer, ArrayList<ItemState>> statesByReverseDepth = new TreeMap<Integer, ArrayList<ItemState>>();
            for (ItemState state : states = store.values().toArray(new ItemState[0])) {
                int depth = hierarchyManager.getShareRelativeDepth((NodeId)id, state.getId());
                if (depth <= 0) continue;
                ArrayList<ItemState> statesAtDepth = (ArrayList<ItemState>)statesByReverseDepth.get(-depth);
                if (statesAtDepth == null) {
                    statesAtDepth = new ArrayList<ItemState>();
                    statesByReverseDepth.put(-depth, statesAtDepth);
                }
                statesAtDepth.add(state);
            }
            ArrayList<ItemState> descendants = new ArrayList<ItemState>();
            for (Collection statesAtDepth : statesByReverseDepth.values()) {
                descendants.addAll(statesAtDepth);
            }
            return descendants;
        }
        return Collections.emptyList();
    }

    public NodeId getIdOfRootTransientNodeState() throws RepositoryException {
        if (this.transientStore.isEmpty()) {
            return null;
        }
        if (this.transientStore.containsKey(this.hierMgr.getRootNodeId())) {
            return this.hierMgr.getRootNodeId();
        }
        LinkedList<NodeId> candidateIds = new LinkedList<NodeId>();
        try {
            ItemState[] states;
            HierarchyManager hierMgr = this.getHierarchyMgr();
            for (ItemState state : states = this.transientStore.values().toArray(new ItemState[0])) {
                if (state.getStatus() != 2 && state.getStatus() != 6) continue;
                NodeId nodeId = state.isNode() ? (NodeId)state.getId() : state.getParentId();
                boolean skip = false;
                Iterator it = candidateIds.iterator();
                while (it.hasNext()) {
                    NodeId id = (NodeId)it.next();
                    if (nodeId.equals(id) || hierMgr.isAncestor(id, nodeId)) {
                        skip = true;
                        break;
                    }
                    if (!hierMgr.isAncestor(nodeId, id)) continue;
                    it.remove();
                }
                if (skip) continue;
                candidateIds.add(nodeId);
            }
            if (candidateIds.size() == 1) {
                return (NodeId)candidateIds.iterator().next();
            }
            NodeId candidateId = null;
            for (NodeId id : candidateIds) {
                if (candidateId == null) {
                    candidateId = id;
                    continue;
                }
                if (hierMgr.getDepth(id) >= hierMgr.getDepth(candidateId)) continue;
                candidateId = id;
            }
            NodeState state = (NodeState)this.getItemState(candidateId);
            NodeId parentId = state.getParentId();
            boolean continueWithParent = false;
            while (parentId != null) {
                for (NodeId id : candidateIds) {
                    if (hierMgr.getRelativeDepth(parentId, id) != -1) continue;
                    continueWithParent = true;
                    break;
                }
                if (!continueWithParent) break;
                state = (NodeState)this.getItemState(parentId);
                parentId = state.getParentId();
                continueWithParent = false;
            }
            return parentId;
        }
        catch (ItemStateException e) {
            throw new RepositoryException("failed to determine common root of transient changes", e);
        }
    }

    public boolean isItemStateInAttic(ItemId id) {
        return this.atticStore.containsKey(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeState createTransientNodeState(NodeId id, Name nodeTypeName, NodeId parentId, int initialStatus) throws RepositoryException {
        if (initialStatus == 4 && id != null && this.hasItemState(id)) {
            throw new InvalidItemStateException("Node " + String.valueOf(id) + " already exists");
        }
        Map<ItemId, ItemState> map = this.transientStore;
        synchronized (map) {
            if (id == null) {
                id = this.stateMgr.getNodeIdFactory().newNodeId();
            } else if (this.transientStore.containsKey(id)) {
                throw new RepositoryException("There is already a transient state for node " + String.valueOf(id));
            }
            NodeState state = new NodeState(id, nodeTypeName, parentId, initialStatus, true);
            this.transientStore.put(state.getId(), state);
            state.setContainer(this);
            return state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeState createTransientNodeState(NodeState overlayedState, int initialStatus) throws ItemStateException {
        NodeId id = overlayedState.getNodeId();
        Map<ItemId, ItemState> map = this.transientStore;
        synchronized (map) {
            if (this.transientStore.containsKey(id)) {
                String msg = "there's already a node state instance with id " + String.valueOf(id);
                log.debug(msg);
                throw new ItemStateException(msg);
            }
            NodeState state = new NodeState(overlayedState, initialStatus, true);
            this.transientStore.put(id, state);
            state.setContainer(this);
            return state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyState createTransientPropertyState(NodeId parentId, Name propName, int initialStatus) throws ItemStateException {
        PropertyId id = new PropertyId(parentId, propName);
        Map<ItemId, ItemState> map = this.transientStore;
        synchronized (map) {
            if (this.transientStore.containsKey(id)) {
                String msg = "there's already a property state instance with id " + String.valueOf(id);
                log.debug(msg);
                throw new ItemStateException(msg);
            }
            PropertyState state = new PropertyState(id, initialStatus, true);
            this.transientStore.put(id, state);
            state.setContainer(this);
            return state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyState createTransientPropertyState(PropertyState overlayedState, int initialStatus) throws ItemStateException {
        PropertyId id = overlayedState.getPropertyId();
        Map<ItemId, ItemState> map = this.transientStore;
        synchronized (map) {
            if (this.transientStore.containsKey(id)) {
                String msg = "there's already a property state instance with id " + String.valueOf(id);
                log.debug(msg);
                throw new ItemStateException(msg);
            }
            PropertyState state = new PropertyState(overlayedState, initialStatus, true);
            this.transientStore.put(id, state);
            state.setContainer(this);
            return state;
        }
    }

    public void disconnectTransientItemState(ItemState state) {
        state.disconnect();
    }

    public void disposeTransientItemState(ItemState state) {
        state.discard();
        this.transientStore.remove(state.getId());
        state.onDisposed();
    }

    public void moveTransientItemStateToAttic(ItemState state) {
        this.transientStore.remove(state.getId());
        this.atticStore.put(state.getId(), state);
    }

    public void disposeTransientItemStateInAttic(ItemState state) {
        state.discard();
        this.atticStore.remove(state.getId());
        state.onDisposed();
    }

    public void disposeAllTransientItemStates() {
        ItemState[] tmp;
        for (ItemState state : tmp = this.transientStore.values().toArray(new ItemState[0])) {
            this.disposeTransientItemState(state);
        }
        for (ItemState state : tmp = this.atticStore.values().toArray(new ItemState[0])) {
            this.disposeTransientItemStateInAttic(state);
        }
    }

    public void addListener(ItemStateListener listener) {
        this.dispatcher.addListener(listener);
    }

    public void removeListener(ItemStateListener listener) {
        this.dispatcher.removeListener(listener);
    }

    public ItemStateManager getAttic() {
        if (this.attic == null) {
            this.attic = new AtticItemStateManager();
        }
        return this.attic;
    }

    @Override
    public void stateCreated(ItemState created) {
        boolean notifyTransientSpace;
        ItemState transientState;
        ItemState visibleState = created;
        if (created.getContainer() != this && (transientState = this.transientStore.get(created.getId())) != null) {
            if (transientState.hasOverlayedState()) {
                transientState.pull();
                transientState.setStatus(1);
            } else {
                try {
                    ItemState local = this.stateMgr.getItemState(created.getId());
                    transientState.connect(local);
                    transientState.setModCount(local.getModCount());
                    transientState.setStatus(2);
                }
                catch (ItemStateException e) {
                    transientState.setStatus(0);
                }
            }
            visibleState = transientState;
        }
        if (notifyTransientSpace = !(visibleState instanceof NodeState)) {
            this.dispatcher.notifyStateCreated(visibleState);
        }
    }

    @Override
    public void stateModified(ItemState modified) {
        ItemState visibleState = modified;
        this.dispatcher.notifyStateModified(visibleState);
    }

    @Override
    public void stateDestroyed(ItemState destroyed) {
        ItemState visibleState = destroyed;
        if (destroyed.getContainer() != this) {
            ItemState transientState = this.transientStore.get(destroyed.getId());
            if (transientState != null) {
                transientState.setStatus(6);
                visibleState = transientState;
            } else {
                transientState = this.atticStore.remove(destroyed.getId());
                if (transientState != null) {
                    transientState.onDisposed();
                }
            }
        }
        this.dispatcher.notifyStateDestroyed(visibleState);
    }

    @Override
    public void stateDiscarded(ItemState discarded) {
        ItemState transientState;
        ItemState visibleState = discarded;
        if (discarded.getContainer() != this && (transientState = this.transientStore.get(discarded.getId())) != null) {
            transientState.setStatus(0);
            visibleState = transientState;
        }
        this.dispatcher.notifyStateDiscarded(visibleState);
    }

    @Override
    public void nodeAdded(NodeState state, Name name, int index, NodeId id) {
        if (state.getContainer() == this || !this.transientStore.containsKey(state.getId())) {
            this.dispatcher.notifyNodeAdded(state, name, index, id);
        }
    }

    @Override
    public void nodesReplaced(NodeState state) {
        if (state.getContainer() == this || !this.transientStore.containsKey(state.getId())) {
            this.dispatcher.notifyNodesReplaced(state);
        }
    }

    @Override
    public void nodeModified(NodeState state) {
        if (state.getContainer() == this || !this.transientStore.containsKey(state.getId())) {
            this.dispatcher.notifyNodeModified(state);
        }
    }

    @Override
    public void nodeRemoved(NodeState state, Name name, int index, NodeId id) {
        if (state.getContainer() == this || !this.transientStore.containsKey(state.getId())) {
            this.dispatcher.notifyNodeRemoved(state, name, index, id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeState makePersistent(NodeState transientState) throws RepositoryException {
        NodeState localState;
        NodeState nodeState = localState = this.stateMgr.getOrCreateLocalState(transientState);
        synchronized (nodeState) {
            localState.copy(transientState, true);
            this.store(localState);
        }
        this.disconnectTransientItemState(transientState);
        return localState;
    }

    private class AtticItemStateManager
    implements ItemStateManager {
        private AtticItemStateManager() {
        }

        @Override
        public ItemState getItemState(ItemId id) throws NoSuchItemStateException, ItemStateException {
            ItemState state = SessionItemStateManager.this.atticStore.get(id);
            if (state != null) {
                return state;
            }
            throw new NoSuchItemStateException(id.toString());
        }

        @Override
        public boolean hasItemState(ItemId id) {
            return SessionItemStateManager.this.atticStore.containsKey(id);
        }

        @Override
        public NodeReferences getNodeReferences(NodeId id) throws NoSuchItemStateException, ItemStateException {
            throw new ItemStateException("getNodeReferences() not implemented");
        }

        @Override
        public boolean hasNodeReferences(NodeId id) {
            return false;
        }
    }
}

