/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.util.db;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamWrapper {
    private final Logger log = LoggerFactory.getLogger(StreamWrapper.class);
    private MarkDetectingInputStream stream;
    private final long size;

    public StreamWrapper(InputStream in, long size) {
        this.stream = new MarkDetectingInputStream(in);
        this.size = size;
    }

    public InputStream getStream() {
        return new CloseShieldInputStream(this.stream);
    }

    public long getSize() {
        return this.size;
    }

    public void closeStream() {
        try {
            this.stream.close();
        }
        catch (IOException e) {
            this.log.error("Error while closing stream", e);
        }
    }

    public boolean resetStream() {
        try {
            if (!this.stream.isMarked()) {
                this.stream.reset();
                return true;
            }
            this.log.warn("Cannot reset stream to the beginning because it was marked.");
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static class MarkDetectingInputStream
    extends FilterInputStream {
        private boolean marked;

        protected MarkDetectingInputStream(InputStream in) {
            super(in);
        }

        @Override
        public synchronized void mark(int readlimit) {
            super.mark(readlimit);
            this.marked = true;
        }

        private boolean isMarked() {
            return this.marked;
        }
    }
}

