/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.chunking;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.LeafNodeObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.SignatureObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.BinaryItem;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.chunking.AbstractChunking;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.util.ByteUtil;

public class SimpleChunking
extends AbstractChunking {
    public SimpleChunking(byte[] fileContent) {
        super(fileContent);
    }

    @Override
    public List<LeafNodeObject> chunking() throws TikaException {
        int chunkLength;
        int maxChunkSize = 0x100000;
        ArrayList<LeafNodeObject> list = new ArrayList<LeafNodeObject>();
        LeafNodeObject.IntermediateNodeObjectBuilder builder = new LeafNodeObject.IntermediateNodeObjectBuilder();
        if (this.fileContent.length <= maxChunkSize) {
            list.add(builder.Build(this.fileContent, this.getSignature(this.fileContent)));
            return list;
        }
        for (int chunkStart = 0; chunkStart < this.fileContent.length; chunkStart += chunkLength) {
            chunkLength = chunkStart + maxChunkSize >= this.fileContent.length ? this.fileContent.length - chunkStart : maxChunkSize;
            byte[] temp = Arrays.copyOfRange(this.fileContent, chunkStart, chunkLength);
            list.add(builder.Build(temp, this.getSignature(temp)));
        }
        return list;
    }

    private SignatureObject getSignature(byte[] array) throws TikaException {
        if (this.fileContent.length <= 0xFA00000) {
            byte[] temp = DigestUtils.sha1(array);
            SignatureObject signature = new SignatureObject();
            signature.signatureData = new BinaryItem(ByteUtil.toListOfByte(temp));
            return signature;
        }
        throw new TikaException("When the file size is larger than 250MB, the signature method is not implemented.");
    }
}

