/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.ooxml;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import org.apache.poi.ooxml.extractor.POIXMLTextExtractor;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.xssf.binary.XSSFBCommentsTable;
import org.apache.poi.xssf.binary.XSSFBSharedStringsTable;
import org.apache.poi.xssf.binary.XSSFBSheetHandler;
import org.apache.poi.xssf.binary.XSSFBStylesTable;
import org.apache.poi.xssf.eventusermodel.XSSFBReader;
import org.apache.poi.xssf.eventusermodel.XSSFSheetXMLHandler;
import org.apache.poi.xssf.extractor.XSSFBEventBasedExcelExtractor;
import org.apache.poi.xssf.usermodel.XSSFShape;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.ooxml.XSSFExcelExtractorDecorator;
import org.apache.tika.sax.XHTMLContentHandler;
import org.apache.xmlbeans.XmlException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class XSSFBExcelExtractorDecorator
extends XSSFExcelExtractorDecorator {
    public XSSFBExcelExtractorDecorator(ParseContext context, POIXMLTextExtractor extractor, Locale locale) {
        super(context, extractor, locale);
    }

    @Override
    protected void configureExtractor(POIXMLTextExtractor extractor, Locale locale) {
        ((XSSFBEventBasedExcelExtractor)extractor).setLocale(locale);
    }

    @Override
    public void getXHTML(ContentHandler handler, Metadata metadata, ParseContext context) throws SAXException, XmlException, IOException, TikaException {
        this.metadata = metadata;
        this.parseContext = context;
        metadata.set("protected", "false");
        super.getXHTML(handler, metadata, context);
    }

    @Override
    protected void buildXHTML(XHTMLContentHandler xhtml) throws SAXException, XmlException, IOException {
        XSSFBSharedStringsTable strings;
        XSSFBReader.SheetIterator iter;
        XSSFBStylesTable styles;
        OPCPackage container = this.extractor.getPackage();
        try {
            XSSFBReader xssfReader = new XSSFBReader(container);
            String originalPath = xssfReader.getAbsPathMetadata();
            if (originalPath != null) {
                this.metadata.set(TikaCoreProperties.ORIGINAL_RESOURCE_NAME, originalPath);
            }
            styles = xssfReader.getXSSFBStylesTable();
            iter = (XSSFBReader.SheetIterator)xssfReader.getSheetsData();
            strings = new XSSFBSharedStringsTable(container);
        }
        catch (OpenXML4JException e) {
            throw new XmlException(e);
        }
        while (iter.hasNext()) {
            InputStream stream = iter.next();
            PackagePart sheetPart = iter.getSheetPart();
            this.addDrawingHyperLinks(sheetPart);
            this.sheetParts.add(sheetPart);
            XSSFExcelExtractorDecorator.SheetTextAsHTML sheetExtractor = new XSSFExcelExtractorDecorator.SheetTextAsHTML(this.config, xhtml);
            XSSFBCommentsTable comments = iter.getXSSFBSheetComments();
            xhtml.startElement("div");
            xhtml.element("h1", iter.getSheetName());
            xhtml.startElement("table");
            xhtml.startElement("tbody");
            this.processSheet((XSSFSheetXMLHandler.SheetContentsHandler)sheetExtractor, comments, styles, strings, stream);
            xhtml.endElement("tbody");
            xhtml.endElement("table");
            for (String header : sheetExtractor.headers) {
                this.extractHeaderFooter(header, xhtml);
            }
            for (String footer : sheetExtractor.footers) {
                this.extractHeaderFooter(footer, xhtml);
            }
            List<XSSFShape> shapes = iter.getShapes();
            this.processShapes(shapes, xhtml);
            this.extractHyperLinks(sheetPart, xhtml);
            xhtml.endElement("div");
        }
    }

    @Override
    protected void extractHeaderFooter(String hf, XHTMLContentHandler xhtml) throws SAXException {
        if (hf.length() > 0) {
            xhtml.element("p", hf);
        }
    }

    private void processSheet(XSSFSheetXMLHandler.SheetContentsHandler sheetContentsExtractor, XSSFBCommentsTable comments, XSSFBStylesTable styles, XSSFBSharedStringsTable strings, InputStream sheetInputStream) throws IOException, SAXException {
        XSSFBSheetHandler xssfbSheetHandler = new XSSFBSheetHandler(sheetInputStream, styles, comments, strings, sheetContentsExtractor, this.formatter, false);
        xssfbSheetHandler.parse();
    }
}

