/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.main.runner;

import arq.cmdline.ModAssembler;
import arq.cmdline.ModDatasetAssembler;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.jena.atlas.io.IOX;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.atlas.web.AuthScheme;
import org.apache.jena.cmd.ArgDecl;
import org.apache.jena.cmd.CmdException;
import org.apache.jena.cmd.CmdGeneral;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.main.FusekiServer;
import org.apache.jena.fuseki.main.runner.DSGSetup;
import org.apache.jena.fuseki.main.runner.ServerArgs;
import org.apache.jena.fuseki.main.runner.SetupType;
import org.apache.jena.fuseki.main.sys.FusekiModules;
import org.apache.jena.fuseki.main.sys.FusekiServerArgsHandler;
import org.apache.jena.fuseki.server.DataAccessPoint;
import org.apache.jena.fuseki.servlets.SPARQL_QueryGeneral;
import org.apache.jena.fuseki.validation.DataValidator;
import org.apache.jena.fuseki.validation.IRIValidator;
import org.apache.jena.fuseki.validation.LangTagValidator;
import org.apache.jena.fuseki.validation.QueryValidator;
import org.apache.jena.fuseki.validation.UpdateValidator;
import org.apache.jena.query.ARQ;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.sparql.core.assembler.AssemblerUtils;
import org.slf4j.Logger;

public class FusekiArgs
extends CmdGeneral {
    public static final int defaultArgsHttpPort = 3030;
    @Deprecated(forRemoval=true)
    public static final int defaultPort = 3030;
    public static final int defaultArgsHttpsPort = 3043;
    private static final ArgDecl argMem = new ArgDecl(false, "mem");
    private static final ArgDecl argUpdate = new ArgDecl(false, "update", "allowUpdate");
    private static final ArgDecl argFile = new ArgDecl(true, "file");
    private static final ArgDecl argTDB1mode = new ArgDecl(false, "tdb1");
    private static final ArgDecl argTDB2mode = new ArgDecl(false, "tdb2");
    private static final ArgDecl argMemTDB = new ArgDecl(false, "memtdb", "memTDB", "tdbmem");
    private static final ArgDecl argTDB = new ArgDecl(true, "loc", "location", "tdb");
    private static final ArgDecl argRDFS = new ArgDecl(true, "rdfs");
    private static final ArgDecl argEmpty = new ArgDecl(false, "empty", "no-dataset");
    private static final ArgDecl argGeneralQuerySvc = new ArgDecl(true, "general");
    private static final ArgDecl argHttpPort = new ArgDecl(true, "port");
    private static final ArgDecl argLocalhost = new ArgDecl(false, "localhost", "local");
    private static final ArgDecl argTimeout = new ArgDecl(true, "timeout");
    private static final ArgDecl argConfig = new ArgDecl(true, "config", "conf");
    private static final ArgDecl argJettyConfig = new ArgDecl(true, "jetty-config", "jetty");
    private static final ArgDecl argGZip = new ArgDecl(true, "gzip");
    private static final ArgDecl argContextPath = new ArgDecl(true, "pathBase", "contextPath", "pathbase", "contextpath");
    private static final ArgDecl argBase = new ArgDecl(true, "base", "files");
    private static final ArgDecl argCORS = new ArgDecl(true, "withCORS", "cors", "CORS", "cors-config");
    private static final ArgDecl argNoCORS = new ArgDecl(false, "noCORS", "no-cors");
    private static final ArgDecl argWithPing = new ArgDecl(false, "withPing", "ping");
    private static final ArgDecl argWithStats = new ArgDecl(false, "withStats", "stats");
    private static final ArgDecl argWithMetrics = new ArgDecl(false, "withMetrics", "metrics");
    private static final ArgDecl argWithCompact = new ArgDecl(false, "withCompact", "compact");
    @Deprecated(forRemoval=true)
    private static final ArgDecl argEnableModules = new ArgDecl(true, "modules", "fuseki-modules");
    private static final ArgDecl argAuth = new ArgDecl(true, "auth");
    private static final ArgDecl argHttps = new ArgDecl(true, "https");
    private static final ArgDecl argHttpsPort = new ArgDecl(true, "httpsPort", "httpsport");
    private static final ArgDecl argPasswdFile = new ArgDecl(true, "passwd");
    private static final ArgDecl argRealm = new ArgDecl(true, "realm");
    private static final ArgDecl argSparqler = new ArgDecl(true, "sparqler");
    private static final ArgDecl argValidators = new ArgDecl(false, "validators");
    private boolean argsProcessed = false;
    private ModDatasetAssembler modDataset = new ModDatasetAssembler();
    private boolean useTDB2 = true;
    final ServerArgs serverArgs = new ServerArgs();
    private final List<? extends FusekiServerArgsHandler> serverArgsHandlersList;
    static String argUsage = "[--config=FILE|--mem|--loc=DIR|--file=FILE] [--port PORT] /DatasetPathName";

    public static FusekiServer.Builder applyArgs(FusekiServer.Builder builder, String ... args) {
        return FusekiArgs.applyArgs(builder, FusekiModules.empty(), args);
    }

    public static FusekiServer.Builder applyArgs(FusekiServer.Builder builder, FusekiModules modules, String ... args) {
        FusekiArgs fusekiArgs = new FusekiArgs(modules, args);
        fusekiArgs.process();
        fusekiArgs.applySetup(builder);
        return builder;
    }

    public static FusekiArgs args(FusekiModules fusekiModules, String ... args) {
        return new FusekiArgs(fusekiModules, args);
    }

    FusekiArgs(FusekiModules fusekiModules, String ... args) {
        super(args);
        Objects.requireNonNull(fusekiModules);
        this.serverArgs.fusekiModules = fusekiModules;
        this.serverArgsHandlersList = fusekiModules == null ? FusekiModules.empty().asList() : fusekiModules.asList();
        this.argumentsSetup();
    }

    private List<? extends FusekiServerArgsHandler> getServerArgsHandlers() {
        return this.serverArgsHandlersList;
    }

    private static void runArgsHandlers(List<? extends FusekiServerArgsHandler> argsHandlers, Consumer<FusekiServerArgsHandler> action) {
        for (FusekiServerArgsHandler fusekiServerArgsHandler : argsHandlers) {
            action.accept(fusekiServerArgsHandler);
        }
    }

    @Override
    protected String getSummary() {
        return this.getCommandName() + " " + argUsage;
    }

    @Override
    protected String getCommandName() {
        return "fuseki";
    }

    private void argumentsSetup() {
        this.modVersion.addClass("Fuseki", Fuseki.class);
        this.getUsage().startCategory("Fuseki");
        this.add(argConfig, "--config=FILE", "Use a configuration file to determine the services");
        this.add(argMem, "--mem", "Create an in-memory, non-persistent dataset for the server");
        this.add(argFile, "--file=FILE", "Create an in-memory, non-persistent dataset for the server, initialised with the contents of the file");
        this.add(argTDB2mode, "--tdb2", "Use TDB2 for command line persistent datasets");
        this.add(argTDB1mode, "--tdb1", "Use TDB1 for command line persistent datasets (default is TDB2)");
        this.add(argTDB, "--loc=DIR", "Use an existing TDB database (or create if does not exist)");
        this.add(argMemTDB, "--memTDB", "Create an in-memory, non-persistent dataset using TDB (testing only)");
        this.add(argRDFS, "--rdfs=FILE", "Apply RDFS on top of the dataset");
        this.add(argUpdate, "--update", "Allow updates (via SPARQL Update and SPARQL HTTP Update)");
        this.addModule(this.modDataset);
        this.add(argEmpty);
        this.add(argHttpPort, "--port", "Listen on this port number");
        this.add(argLocalhost, "--localhost", "Listen only on the localhost interface");
        this.add(argGZip, "--gzip=on|off", "Enable GZip compression (HTTP Accept-Encoding) if request header set");
        this.add(argBase, "--base=DIR", "Directory for static content");
        this.add(argContextPath, "--contextPath=PATH", "Context path for the server");
        this.add(argHttps, "--https=CONF", "https certificate access details. JSON file { \"cert\":FILE , \"passwd\"; SECRET } ");
        this.add(argHttpsPort, "--httpsPort=NUM", "https port (default port is 3043)");
        this.add(argPasswdFile, "--passwd=FILE", "Password file");
        this.add(argTimeout, "--timeout=", "Global timeout applied to queries (value in ms) -- format is X[,Y] ");
        this.add(argSparqler, "--sparqler=DIR", "Run with SPARQLer services Directory for static content");
        this.add(argValidators, "--validators", "Install validators");
        this.add(argGeneralQuerySvc, "--general=PATH", "Add a general SPARQL endpoint (without a dataset) at /PATH");
        this.add(argAuth, "--auth=[basic|digest]", "Run the server using basic or digest authentication");
        this.add(argJettyConfig, "--jetty=FILE", "jetty.xml server configuration");
        this.add(argCORS, "--cors=FILE", "Configure CORS settings from file");
        this.add(argNoCORS, "--no-cors", "Disable CORS");
        this.add(argWithPing, "--ping", "Enable /$/ping");
        this.add(argWithStats, "--stats", "Enable /$/stats");
        this.add(argWithMetrics, "--metrics", "Enable /$/metrics");
        this.add(argWithCompact, "--compact", "Enable /$/compact/*");
        this.add(argEnableModules);
        FusekiArgs.runArgsHandlers(this.getServerArgsHandlers(), argsHandler -> argsHandler.serverArgsModify(this, this.serverArgs));
    }

    @Override
    protected void processModulesAndArgs() {
        if (this.argsProcessed) {
            return;
        }
        this.argsProcessed = true;
        Logger log2 = Fuseki.serverLog;
        this.serverArgs.verboseLogging = super.isVerbose();
        this.serverArgs.quietLogging = super.isQuiet();
        if (this.serverArgs.quietLogging && this.serverArgs.verboseLogging) {
            throw new CmdException("Can't be both 'quiet' and 'verbose'");
        }
        if (!this.serverArgs.bypassStdArgs) {
            this.processStdArguments(log2);
        }
        FusekiArgs.runArgsHandlers(this.getServerArgsHandlers(), argsHandler -> argsHandler.serverArgsPrepare(this, this.serverArgs));
    }

    private void processStdArguments(Logger log2) {
        boolean allowUpdate;
        boolean startEmpty;
        int numDefinitions = 0;
        SetupType setup = SetupType.UNSET;
        if (this.contains(argMem)) {
            setup = SetupType.MEM;
            ++numDefinitions;
        }
        if (this.contains(argFile)) {
            setup = SetupType.FILE;
            ++numDefinitions;
        }
        if (this.contains(ModAssembler.assemblerDescDecl)) {
            setup = SetupType.ASSEM;
            ++numDefinitions;
        }
        if (this.contains(argTDB)) {
            setup = SetupType.TDB;
            ++numDefinitions;
        }
        if (this.contains(argMemTDB)) {
            setup = SetupType.MEMTDB;
            ++numDefinitions;
        }
        if (this.contains(argConfig)) {
            setup = SetupType.CONF;
            ++numDefinitions;
        }
        if (this.contains(argEmpty)) {
            setup = SetupType.NONE;
        }
        if (this.contains(argSparqler)) {
            setup = SetupType.SPARQLer;
        }
        if (setup == SetupType.UNSET && this.serverArgs.allowEmpty) {
            setup = SetupType.NONE;
        }
        boolean bl = startEmpty = setup == SetupType.NONE || setup == SetupType.SPARQLer;
        if (numDefinitions > 1) {
            throw new CmdException("Multiple ways providing a dataset. Only one of --mem, --file, --loc or --conf");
        }
        if (startEmpty && numDefinitions > 0) {
            throw new CmdException("Dataset provided but 'no dataset' flag given");
        }
        if (startEmpty && !this.getPositional().isEmpty()) {
            throw new CmdException("Dataset name provided but 'no dataset' flag given");
        }
        if (!startEmpty && numDefinitions == 0) {
            throw new CmdException("No dataset or configuration specified on the command line");
        }
        if (this.contains(argConfig)) {
            if (!this.getPositional().isEmpty()) {
                throw new CmdException("Can't have both a configuration file and a service name");
            }
            if (this.contains(argRDFS)) {
                throw new CmdException("Need to define RDFS setup in the configuration file");
            }
        } else {
            if (this.getPositional().size() > 1) {
                throw new CmdException("Multiple dataset path names given");
            }
            if (!startEmpty && this.getPositional().size() == 0) {
                if (setup == SetupType.UNSET) {
                    throw new CmdException("Missing dataset description and service name");
                }
                throw new CmdException("Missing service name");
            }
            if (this.getPositional().size() == 1) {
                this.serverArgs.datasetPath = DataAccessPoint.canonical(this.getPositionalArg(0));
            }
        }
        if (this.contains(argUpdate) && this.contains(argConfig)) {
            throw new CmdException("--update and a configuration file does not make sense (control using the configuration file only)");
        }
        this.serverArgs.allowUpdate = allowUpdate = this.contains(argUpdate);
        this.serverArgs.setup = setup;
        this.serverArgs.datasetDescription = "<unset>";
        if (this.contains(argTDB1mode)) {
            this.useTDB2 = false;
        }
        if (this.contains(argTDB2mode)) {
            this.useTDB2 = true;
        }
        switch (setup) {
            case CONF: {
                this.serverArgs.serverConfigFile = this.getValue(argConfig);
                break;
            }
            case MEM: {
                this.serverArgs.dsgMaker = args -> DSGSetup.setupMem(log2, args);
                break;
            }
            case FILE: {
                List<String> filenames = this.getValues(argFile);
                this.serverArgs.dsgMaker = args -> DSGSetup.setupFile(log2, filenames, args);
                break;
            }
            case TDB: {
                String directory = this.getValue(argTDB);
                this.serverArgs.dsgMaker = args -> DSGSetup.setupTDB(log2, directory, this.useTDB2, args);
                break;
            }
            case NONE: {
                this.serverArgs.startEmpty = true;
                this.serverArgs.datasetDescription = "No dataset";
                break;
            }
            case ASSEM: {
                this.serverArgs.dsgMaker = args -> DSGSetup.setupAssembler(log2, this.modDataset, args);
                break;
            }
            case MEMTDB: {
                DSGSetup.setupMemTDB(log2, this.useTDB2, this.serverArgs);
                break;
            }
            case UNSET: {
                throw new CmdException("Internal error");
            }
            case SPARQLer: {
                String filebase = this.getValue(argSparqler);
                if (!FileOps.exists(filebase)) {
                    throw new CmdException("File area not found: " + filebase);
                }
                this.serverArgs.contentDirectory = filebase;
                this.serverArgs.addGeneralQueryProc = "/sparql";
                this.serverArgs.startEmpty = true;
                this.serverArgs.validators = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)setup));
            }
        }
        if (this.contains(argRDFS)) {
            String rdfsVocab = this.getValue(argRDFS);
            if (!FileOps.exists(rdfsVocab)) {
                throw new CmdException("No such file for RDFS: " + rdfsVocab);
            }
            this.serverArgs.rdfsSchemaGraph = RDFDataMgr.loadGraph(rdfsVocab);
        }
        if (this.contains(argTimeout)) {
            String str2 = this.getValue(argTimeout);
            ARQ.getContext().set(ARQ.queryTimeout, str2);
        }
        if (this.contains(argGeneralQuerySvc)) {
            Object z = this.getValue(argGeneralQuerySvc);
            if (!((String)z).startsWith("/")) {
                z = "/" + (String)z;
            }
            this.serverArgs.addGeneralQueryProc = z;
        }
        if (this.contains(argValidators)) {
            this.serverArgs.validators = true;
        }
        boolean hasJettyConfigFile = this.contains(argJettyConfig);
        if (this.contains(argLocalhost)) {
            if (hasJettyConfigFile) {
                throw new CmdException("Cannot specify 'localhost' and also provide a Jetty configuration file");
            }
            this.serverArgs.loopback = true;
        }
        if (this.contains(argContextPath)) {
            String contextPath = this.getValue(argContextPath);
            if ((contextPath = FusekiArgs.sanitizeContextPath(contextPath)) != null) {
                this.serverArgs.servletContextPath = contextPath;
            }
        }
        if (this.contains(argBase)) {
            String filebase = this.getValue(argBase);
            if (!FileOps.exists(filebase)) {
                throw new CmdException("File area not found: " + filebase);
            }
            this.serverArgs.contentDirectory = filebase;
        }
        if (this.contains(argPasswdFile)) {
            if (hasJettyConfigFile) {
                throw new CmdException("Can't specify a password file and also provide a Jetty configuration file");
            }
            this.serverArgs.passwdFile = this.getValue(argPasswdFile);
        }
        if (this.contains(argRealm)) {
            this.serverArgs.realm = this.getValue(argRealm);
        }
        if (this.contains(argHttpsPort) && !this.contains(argHttps)) {
            throw new CmdException("https port given but no certificate details via --" + argHttps.getKeyName());
        }
        if (this.contains(argHttps)) {
            String httpsSetup;
            if (hasJettyConfigFile) {
                throw new CmdException("Can't specify \"https\" and also provide a Jetty configuration file");
            }
            this.serverArgs.httpPort = ServerArgs.UNSET_PORT;
            this.serverArgs.httpsPort = 3043;
            if (this.contains(argHttpsPort)) {
                this.serverArgs.httpsPort = this.portNumber(argHttpsPort);
            }
            this.serverArgs.httpsKeysDetails = httpsSetup = this.getValue(argHttps);
        }
        if (this.contains(argHttpPort)) {
            if (hasJettyConfigFile) {
                throw new CmdException("Cannot specify the port and also provide a Jetty configuration file");
            }
            this.serverArgs.httpPort = this.portNumber(argHttpPort);
        }
        if (this.serverArgs.httpPort < 0 && this.serverArgs.httpsPort < 0) {
            this.serverArgs.httpPort = 3030;
        }
        if (this.contains(argAuth)) {
            if (hasJettyConfigFile) {
                throw new CmdException("Can't specify authentication and also provide a Jetty configuration file");
            }
            String schemeStr = this.getValue(argAuth);
            this.serverArgs.authScheme = AuthScheme.scheme(schemeStr);
        }
        if (this.contains(argJettyConfig)) {
            String jettyConfigFile = this.getValue(argJettyConfig);
            if (!FileOps.exists(jettyConfigFile)) {
                throw new CmdException("Jetty config file not found: " + jettyConfigFile);
            }
            this.serverArgs.jettyConfigFile = jettyConfigFile;
        }
        if (this.contains(argCORS)) {
            String corsConfigFile = this.getValue(argCORS);
            if (!FileOps.exists(corsConfigFile)) {
                throw new CmdException("CORS config file not found: " + corsConfigFile);
            }
            this.serverArgs.corsConfigFile = corsConfigFile;
        } else if (this.contains(argNoCORS)) {
            boolean bl2 = this.serverArgs.withCORS = !this.contains(argNoCORS);
        }
        if (this.contains(argWithPing)) {
            this.serverArgs.withPing = true;
        }
        if (this.contains(argWithStats)) {
            this.serverArgs.withStats = true;
        }
        if (this.contains(argWithMetrics)) {
            this.serverArgs.withMetrics = true;
        }
        if (this.contains(argWithCompact)) {
            this.serverArgs.withCompact = true;
        }
    }

    FusekiServer.Builder setup() {
        FusekiServer.Builder builder = FusekiServer.create();
        FusekiArgs.applyServerArgs(builder, this.getServerArgsHandlers(), this.serverArgs);
        return builder;
    }

    void applySetup(FusekiServer.Builder builder) {
        FusekiArgs.applyServerArgs(builder, this.getServerArgsHandlers(), this.serverArgs);
    }

    private static void applyServerArgs(FusekiServer.Builder builder, List<? extends FusekiServerArgsHandler> argsHandlers, ServerArgs serverArgs) {
        boolean commandLineSetup;
        boolean bl = commandLineSetup = serverArgs.dataset != null || serverArgs.dsgMaker != null;
        if (serverArgs.jettyConfigFile != null) {
            builder.jettyServerConfig(serverArgs.jettyConfigFile);
        }
        builder.port(serverArgs.httpPort);
        builder.loopback(serverArgs.loopback);
        builder.verbose(serverArgs.verboseLogging);
        if (serverArgs.addGeneralQueryProc != null) {
            builder.addServlet(serverArgs.addGeneralQueryProc, new SPARQL_QueryGeneral());
        }
        if (serverArgs.validators) {
            builder.addServlet("/$/validate/query", new QueryValidator());
            builder.addServlet("/$/validate/update", new UpdateValidator());
            builder.addServlet("/$/validate/iri", new IRIValidator());
            builder.addServlet("/$/validate/langtag", new LangTagValidator());
            builder.addServlet("/$/validate/data", new DataValidator());
        }
        if (!serverArgs.startEmpty) {
            if (serverArgs.serverConfigModel != null) {
                builder.parseConfig(serverArgs.serverConfigModel);
                serverArgs.datasetDescription = "Configuration: provided";
            } else if (serverArgs.serverConfigFile != null) {
                String file = serverArgs.serverConfigFile;
                if (file.startsWith("file:")) {
                    file = file.substring("file:".length());
                }
                Path path = Path.of(file, new String[0]);
                IOX.checkReadableFile(file, msg -> new CmdException((String)msg));
                serverArgs.datasetDescription = "Configuration: " + String.valueOf(path.toAbsolutePath());
                serverArgs.serverConfigModel = RDFParser.source(path).toModel();
                AssemblerUtils.prepareForAssembler(serverArgs.serverConfigModel);
                builder.parseConfig(serverArgs.serverConfigModel);
            } else {
                if (serverArgs.datasetPath == null) {
                    throw new CmdException("No URL path name for the dataset");
                }
                if (serverArgs.dataset == null) {
                    serverArgs.dsgMaker.accept(serverArgs);
                }
                if (serverArgs.dataset == null) {
                    throw new CmdException("Failed to set the dataset service");
                }
                if (serverArgs.rdfsSchemaGraph != null) {
                    DSGSetup.setupRDFS(Fuseki.serverLog, serverArgs.rdfsSchemaGraph, serverArgs);
                }
                builder.add(serverArgs.datasetPath, serverArgs.dataset, serverArgs.allowUpdate);
            }
        }
        if (serverArgs.fusekiModules != null) {
            builder.fusekiModules(serverArgs.fusekiModules);
        }
        if (serverArgs.servletContextPath != null) {
            builder.contextPath(serverArgs.servletContextPath);
        }
        if (serverArgs.contentDirectory != null) {
            builder.staticFileBase(serverArgs.contentDirectory);
        }
        if (serverArgs.passwdFile != null) {
            builder.passwordFile(serverArgs.passwdFile);
        }
        if (serverArgs.realm != null) {
            builder.realm(serverArgs.realm);
        }
        if (serverArgs.httpsKeysDetails != null) {
            builder.https(serverArgs.httpsPort, serverArgs.httpsKeysDetails);
        }
        if (serverArgs.authScheme != null) {
            builder.auth(serverArgs.authScheme);
        }
        if (serverArgs.withCORS) {
            builder.enableCors(true, serverArgs.corsConfigFile);
        }
        if (serverArgs.withPing) {
            builder.enablePing(true);
        }
        if (serverArgs.withStats) {
            builder.enableStats(true);
        }
        if (serverArgs.withMetrics) {
            builder.enableMetrics(true);
        }
        if (serverArgs.withCompact) {
            builder.enableCompact(true);
        }
        FusekiArgs.runArgsHandlers(argsHandlers, argsHandler -> argsHandler.serverArgsBuilder(builder, serverArgs.serverConfigModel));
    }

    private int portNumber(ArgDecl arg) {
        String portStr = this.getValue(arg);
        if (portStr.isEmpty()) {
            return ServerArgs.UNSET_PORT;
        }
        try {
            int port = Integer.parseInt(portStr);
            return port;
        }
        catch (NumberFormatException ex) {
            throw new CmdException(argHttpPort.getKeyName() + " : bad port number: '" + portStr + "'");
        }
    }

    private static String sanitizeContextPath(String contextPath) {
        if (((String)contextPath).isEmpty()) {
            return null;
        }
        if (((String)contextPath).equals("/")) {
            return null;
        }
        if (((String)contextPath).endsWith("/")) {
            throw new CmdException("Path base must not end with \"/\": '" + (String)contextPath + "'");
        }
        if (!((String)contextPath).startsWith("/")) {
            contextPath = "/" + (String)contextPath;
        }
        return contextPath;
    }
}

