/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.IOBooleanSupplier;
import org.apache.lucene.util.IOSupplier;

public final class TermStates {
    private static final TermState EMPTY_TERMSTATE = new TermState(){

        @Override
        public void copyFrom(TermState other) {
        }
    };
    private final Object topReaderContextIdentity;
    private final TermState[] states;
    private final Term term;
    private int docFreq;
    private long totalTermFreq;

    private TermStates(Term term, IndexReaderContext context2) {
        assert (context2 != null && context2.isTopLevel);
        this.topReaderContextIdentity = context2.identity;
        this.docFreq = 0;
        this.totalTermFreq = 0L;
        this.states = new TermState[context2.leaves().size()];
        this.term = term;
    }

    public TermStates(IndexReaderContext context2) {
        this(null, context2);
    }

    public boolean wasBuiltFor(IndexReaderContext context2) {
        return this.topReaderContextIdentity == context2.identity;
    }

    public TermStates(IndexReaderContext context2, TermState state, int ord, int docFreq, long totalTermFreq) {
        this(null, context2);
        this.register(state, ord, docFreq, totalTermFreq);
    }

    public static TermStates build(IndexSearcher indexSearcher, Term term, boolean needsStats) throws IOException {
        IndexReaderContext context2 = indexSearcher.getTopReaderContext();
        assert (context2 != null);
        TermStates perReaderTermState = new TermStates(needsStats ? null : term, context2);
        if (needsStats) {
            PendingTermLookup[] pendingTermLookups = new PendingTermLookup[]{};
            for (LeafReaderContext ctx : context2.leaves()) {
                Terms terms = Terms.getTerms(ctx.reader(), term.field());
                TermsEnum termsEnum = terms.iterator();
                IOBooleanSupplier termExistsSupplier = termsEnum.prepareSeekExact(term.bytes());
                if (termExistsSupplier == null) continue;
                pendingTermLookups = ArrayUtil.grow(pendingTermLookups, ctx.ord + 1);
                pendingTermLookups[ctx.ord] = new PendingTermLookup(termsEnum, termExistsSupplier);
            }
            for (int ord = 0; ord < pendingTermLookups.length; ++ord) {
                PendingTermLookup pendingTermLookup = pendingTermLookups[ord];
                if (pendingTermLookup == null || !pendingTermLookup.supplier.get()) continue;
                TermsEnum termsEnum = pendingTermLookup.termsEnum();
                perReaderTermState.register(termsEnum.termState(), ord, termsEnum.docFreq(), termsEnum.totalTermFreq());
            }
        }
        return perReaderTermState;
    }

    public void clear() {
        this.docFreq = 0;
        this.totalTermFreq = 0L;
        Arrays.fill(this.states, null);
    }

    public void register(TermState state, int ord, int docFreq, long totalTermFreq) {
        this.register(state, ord);
        this.accumulateStatistics(docFreq, totalTermFreq);
    }

    public void register(TermState state, int ord) {
        assert (state != null) : "state must not be null";
        assert (ord >= 0 && ord < this.states.length);
        assert (this.states[ord] == null) : "state for ord: " + ord + " already registered";
        this.states[ord] = state;
    }

    public void accumulateStatistics(int docFreq, long totalTermFreq) {
        assert (docFreq >= 0);
        assert (totalTermFreq >= 0L);
        assert ((long)docFreq <= totalTermFreq);
        this.docFreq += docFreq;
        this.totalTermFreq += totalTermFreq;
    }

    public IOSupplier<TermState> get(LeafReaderContext ctx) throws IOException {
        assert (ctx.ord >= 0 && ctx.ord < this.states.length);
        if (this.term == null) {
            if (this.states[ctx.ord] == null) {
                return null;
            }
            return () -> this.states[ctx.ord];
        }
        if (this.states[ctx.ord] == null) {
            Terms terms = ctx.reader().terms(this.term.field());
            if (terms == null) {
                this.states[ctx.ord] = EMPTY_TERMSTATE;
                return null;
            }
            TermsEnum termsEnum = terms.iterator();
            IOBooleanSupplier termExistsSupplier = termsEnum.prepareSeekExact(this.term.bytes());
            if (termExistsSupplier == null) {
                this.states[ctx.ord] = EMPTY_TERMSTATE;
                return null;
            }
            return () -> {
                TermState state;
                if (this.states[ctx.ord] == null) {
                    state = null;
                    this.states[ctx.ord] = termExistsSupplier.get() ? (state = termsEnum.termState()) : EMPTY_TERMSTATE;
                }
                if ((state = this.states[ctx.ord]) == EMPTY_TERMSTATE) {
                    return null;
                }
                return state;
            };
        }
        TermState state = this.states[ctx.ord];
        if (state == EMPTY_TERMSTATE) {
            return null;
        }
        return () -> state;
    }

    public int docFreq() {
        if (this.term != null) {
            throw new IllegalStateException("Cannot call docFreq() when needsStats=false");
        }
        return this.docFreq;
    }

    public long totalTermFreq() {
        if (this.term != null) {
            throw new IllegalStateException("Cannot call totalTermFreq() when needsStats=false");
        }
        return this.totalTermFreq;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TermStates\n");
        for (TermState termState : this.states) {
            sb.append("  state=");
            sb.append(termState);
            sb.append('\n');
        }
        return sb.toString();
    }

    private record PendingTermLookup(TermsEnum termsEnum, IOBooleanSupplier supplier) {
    }
}

