/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets.prefixes;

import java.util.Iterator;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.fuseki.servlets.BaseActionREST;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.fuseki.servlets.prefixes.PrefixUtils;
import org.apache.jena.fuseki.servlets.prefixes.PrefixesAccess;
import org.apache.jena.fuseki.servlets.prefixes.PrefixesMap;
import org.apache.jena.sparql.core.DatasetGraph;

public abstract class ActionPrefixesBase
extends BaseActionREST {
    protected static PrefixesAccess prefixesFromAction(HttpAction action) {
        DatasetGraph dsg = action.getDataset();
        PrefixesMap pMap = new PrefixesMap(dsg.prefixes(), dsg);
        return pMap;
    }

    protected abstract PrefixesAccess prefixes(HttpAction var1);

    @Override
    public final void validate(HttpAction action) {
        Iterator<String> paramNames = action.getRequestParameterNames().asIterator();
        while (paramNames.hasNext()) {
            String check = paramNames.next();
            if (PrefixUtils.isPrefixesParam(check)) continue;
            FmtLog.warn(action.log, "[%d] Parameter not recognized: %s", action.id, check);
            ServletOps.errorBadRequest("Parameter not recognized: " + check);
            return;
        }
        String prefix = action.getRequestParameter("prefix");
        String uri = action.getRequestParameter("uri");
        if (prefix != null) {
            if (prefix.isEmpty()) {
                FmtLog.warn(action.log, "[%d] Empty prefix - not supported", action.id);
                ServletOps.errorBadRequest("Bad prefix parameter value");
                return;
            }
            if (!PrefixUtils.prefixIsValid(prefix)) {
                FmtLog.warn(action.log, "[%d] Bad value for prefix: '%s'", action.id, prefix);
                ServletOps.errorBadRequest("Bad prefix parameter value");
                return;
            }
        }
        if (uri != null && !PrefixUtils.uriIsValid(uri)) {
            FmtLog.warn(action.log, "[%d] Bad value for uri: '%s'", action.id, uri);
            ServletOps.errorBadRequest("Bad uri parameter value");
            return;
        }
        switch (action.getRequestMethod()) {
            case "GET": {
                this.validatePrefixesGET(action);
                break;
            }
            case "POST": {
                this.validatePrefixesPOST(action);
                break;
            }
            case "DELETE": {
                this.validatePrefixesDELETE(action);
            }
        }
    }

    protected void validatePrefixesGET(HttpAction action) {
        ServletOps.errorMethodNotAllowed(action.getRequestMethod());
    }

    protected void validatePrefixesPOST(HttpAction action) {
        ServletOps.errorMethodNotAllowed(action.getRequestMethod());
    }

    protected void validatePrefixesDELETE(HttpAction action) {
        ServletOps.errorMethodNotAllowed(action.getRequestMethod());
    }
}

