/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml.bind.gml;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Date;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.sis.pending.geoapi.temporal.Instant;
import org.apache.sis.util.internal.Strings;
import org.apache.sis.xml.bind.Context;
import org.apache.sis.xml.bind.gml.GMLAdapter;
import org.apache.sis.xml.util.XmlUtilities;

@XmlType(name="TimeInstantType")
@XmlRootElement(name="TimeInstant")
public final class TimeInstant
extends GMLAdapter {
    @XmlElement
    public XMLGregorianCalendar timePosition;

    public TimeInstant() {
    }

    public TimeInstant(Instant instant) {
        this.timePosition = TimeInstant.toXML(instant);
    }

    static XMLGregorianCalendar toXML(Instant instant) {
        Date date2;
        if (instant != null && (date2 = instant.getDate()) != null) {
            Context context2 = Context.current();
            try {
                XMLGregorianCalendar gc = XmlUtilities.toXML(context2, date2);
                if (gc != null) {
                    XmlUtilities.trimTime(gc, false);
                    return gc;
                }
            }
            catch (DatatypeConfigurationException e2) {
                Context.warningOccured(context2, TimeInstant.class, "toXML", e2, true);
            }
        }
        return null;
    }

    public String toString() {
        return Strings.bracket(this.getClass(), (Object)this.timePosition);
    }
}

