/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.util.Optional;
import java.util.function.Supplier;
import org.apache.juneau.annotation.Schema;
import org.apache.juneau.assertions.FluentBooleanAssertion;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.header.BasicHeader;

@Header
@Schema(type="boolean")
public class BasicBooleanHeader
extends BasicHeader {
    private static final long serialVersionUID = 1L;
    private final Boolean value;
    private final Supplier<Boolean> supplier;

    public static BasicBooleanHeader of(String name, Boolean value) {
        return value == null ? null : new BasicBooleanHeader(name, value);
    }

    public static BasicBooleanHeader of(String name, String value) {
        return value == null ? null : new BasicBooleanHeader(name, value);
    }

    public static BasicBooleanHeader of(String name, Supplier<Boolean> value) {
        return value == null ? null : new BasicBooleanHeader(name, value);
    }

    public BasicBooleanHeader(String name, Boolean value) {
        super(name, value);
        this.value = value;
        this.supplier = null;
    }

    public BasicBooleanHeader(String name, String value) {
        super(name, value);
        this.value = Utils.e(value) ? null : Boolean.valueOf(Utils.bool(value));
        this.supplier = null;
    }

    public BasicBooleanHeader(String name, Supplier<Boolean> value) {
        super(name, null);
        this.value = null;
        this.supplier = value;
    }

    public Optional<Boolean> asBoolean() {
        return Utils.opt(this.value());
    }

    public FluentBooleanAssertion<BasicBooleanHeader> assertBoolean() {
        return new FluentBooleanAssertion<BasicBooleanHeader>(this.value(), this);
    }

    @Override
    public String getValue() {
        return Utils.s(this.value());
    }

    public boolean isTrue() {
        Boolean x = this.value();
        return x == null ? this.value : x;
    }

    public Boolean orElse(Boolean other) {
        Boolean x = this.value();
        return Utils.nn(x) ? x : other;
    }

    public Boolean toBoolean() {
        return this.value();
    }

    private Boolean value() {
        if (Utils.nn(this.supplier)) {
            return this.supplier.get();
        }
        return this.value;
    }
}

