/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.clients.producer.Partitioner;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;

public class RoundRobinPartitioner
implements Partitioner {
    private final ConcurrentMap<String, AtomicInteger> topicCounterMap = new ConcurrentHashMap<String, AtomicInteger>();
    private final ThreadLocal<TopicPartition> previousPartition = new ThreadLocal();

    @Override
    public void configure(Map<String, ?> configs) {
    }

    @Override
    public int partition(String topic, Object key, byte[] keyBytes, Object value, byte[] valueBytes, Cluster cluster) {
        TopicPartition prevPartition = this.previousPartition.get();
        if (prevPartition != null) {
            this.previousPartition.remove();
            if (topic.equals(prevPartition.topic())) {
                return prevPartition.partition();
            }
        }
        int nextValue = this.nextValue(topic);
        List<PartitionInfo> availablePartitions = cluster.availablePartitionsForTopic(topic);
        if (!availablePartitions.isEmpty()) {
            int part = Utils.toPositive(nextValue) % availablePartitions.size();
            return availablePartitions.get(part).partition();
        }
        int numPartitions = cluster.partitionsForTopic(topic).size();
        return Utils.toPositive(nextValue) % numPartitions;
    }

    private int nextValue(String topic) {
        AtomicInteger counter = this.topicCounterMap.computeIfAbsent(topic, k -> new AtomicInteger(0));
        return counter.getAndIncrement();
    }

    @Override
    public void onNewBatch(String topic, Cluster cluster, int prevPartition) {
        this.previousPartition.set(new TopicPartition(topic, prevPartition));
    }

    @Override
    public void close() {
    }
}

