/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.common.runtime;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.CoordinatorLoadInProgressException;
import org.apache.kafka.common.errors.NotCoordinatorException;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.coordinator.common.runtime.CoordinatorExecutor;
import org.apache.kafka.coordinator.common.runtime.CoordinatorRuntime;
import org.apache.kafka.coordinator.common.runtime.CoordinatorShard;
import org.slf4j.Logger;

public class CoordinatorExecutorImpl<S extends CoordinatorShard<U>, U>
implements CoordinatorExecutor<U> {
    private final Logger log;
    private final TopicPartition shard;
    private final CoordinatorRuntime<S, U> runtime;
    private final ExecutorService executor;
    private final Duration writeTimeout;
    private final Map<String, CoordinatorExecutor.TaskRunnable<?>> tasks = new ConcurrentHashMap();

    public CoordinatorExecutorImpl(LogContext logContext, TopicPartition shard, CoordinatorRuntime<S, U> runtime, ExecutorService executor, Duration writeTimeout) {
        this.log = logContext.logger(CoordinatorExecutorImpl.class);
        this.shard = shard;
        this.runtime = runtime;
        this.executor = executor;
        this.writeTimeout = writeTimeout;
    }

    private <R> TaskResult<R> executeTask(CoordinatorExecutor.TaskRunnable<R> task) {
        try {
            return new TaskResult<R>(task.run(), null);
        }
        catch (Throwable ex) {
            return new TaskResult<Object>(null, ex);
        }
    }

    @Override
    public <R> boolean schedule(String key, CoordinatorExecutor.TaskRunnable<R> task, CoordinatorExecutor.TaskOperation<U, R> operation) {
        if (this.tasks.putIfAbsent(key, task) != null) {
            return false;
        }
        this.executor.submit(() -> {
            if (this.tasks.get(key) != task) {
                return;
            }
            TaskResult result = this.executeTask(task);
            this.runtime.scheduleWriteOperation(key, this.shard, this.writeTimeout, coordinator -> {
                if (!this.tasks.remove(key, task)) {
                    throw new RejectedExecutionException(String.format("Task %s was overridden or cancelled", key));
                }
                return operation.onComplete(result.result, result.exception);
            }).exceptionally(exception -> {
                this.tasks.remove(key, task);
                if (exception instanceof RejectedExecutionException) {
                    this.log.debug("The write event for the task {} was not executed because it was cancelled or overridden.", (Object)key);
                } else if (exception instanceof NotCoordinatorException || exception instanceof CoordinatorLoadInProgressException) {
                    this.log.debug("The write event for the task {} failed due to {}. Ignoring it because the coordinator is not active.", (Object)key, (Object)exception.getMessage());
                } else {
                    this.log.error("The write event for the task {} failed due to {}. Ignoring it. ", new Object[]{key, exception.getMessage(), exception});
                }
                return null;
            });
        });
        return true;
    }

    @Override
    public boolean isScheduled(String key) {
        return this.tasks.containsKey(key);
    }

    @Override
    public void cancel(String key) {
        this.tasks.remove(key);
    }

    public void cancelAll() {
        this.tasks.clear();
    }

    private record TaskResult<R>(R result, Throwable exception) {
    }
}

