/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.url.mvn.internal.config;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.ops4j.pax.url.mvn.internal.config.MavenConfiguration;
import org.ops4j.pax.url.mvn.internal.config.MavenRepositoryURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.eu.maveniverse.maven.mima.context.ContextOverrides;
import shaded.eu.maveniverse.maven.mima.runtime.standalonestatic.ProfileSelectorSupplier;
import shaded.eu.maveniverse.maven.mima.runtime.standalonestatic.SettingsBuilderSupplier;
import shaded.org.apache.maven.model.Activation;
import shaded.org.apache.maven.model.ActivationFile;
import shaded.org.apache.maven.model.Profile;
import shaded.org.apache.maven.model.building.ModelProblemCollector;
import shaded.org.apache.maven.model.building.ModelProblemCollectorRequest;
import shaded.org.apache.maven.model.profile.DefaultProfileActivationContext;
import shaded.org.apache.maven.model.profile.ProfileSelector;
import shaded.org.apache.maven.settings.ActivationOS;
import shaded.org.apache.maven.settings.ActivationProperty;
import shaded.org.apache.maven.settings.Mirror;
import shaded.org.apache.maven.settings.Repository;
import shaded.org.apache.maven.settings.RepositoryPolicy;
import shaded.org.apache.maven.settings.Settings;
import shaded.org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import shaded.org.apache.maven.settings.building.SettingsBuilder;
import shaded.org.apache.maven.settings.building.SettingsBuildingException;
import shaded.org.apache.maven.settings.building.SettingsBuildingResult;
import shaded.org.apache.maven.settings.crypto.DefaultSettingsDecrypter;
import shaded.org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import shaded.org.apache.maven.settings.crypto.SettingsDecrypter;
import shaded.org.apache.maven.settings.crypto.SettingsDecryptionResult;
import shaded.org.ops4j.lang.NullArgumentException;
import shaded.org.ops4j.util.property.PropertyResolver;
import shaded.org.sonatype.plexus.components.cipher.DefaultPlexusCipher;
import shaded.org.sonatype.plexus.components.sec.dispatcher.DefaultSecDispatcher;

public class MavenConfigurationImpl
implements MavenConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenConfigurationImpl.class);
    private final String m_pid;
    private static final String REPOSITORIES_APPEND_SIGN = "+";
    private static final String REPOSITORIES_SEPARATOR = ",";
    private static final String REPOSITORIES_SEPARATOR_SPLIT = "\\s*,\\s*";
    private static final Integer DEFAULT_TIMEOUT = 5000;
    private final PropertyResolver m_propertyResolver;
    private Settings settings;
    private final SettingsDecrypter decrypter;
    private final Map<String, Object> m_properties = new ConcurrentHashMap<String, Object>();
    private static final Object NULL_VALUE = new Object();

    public MavenConfigurationImpl(PropertyResolver propertyResolver, String pid) {
        NullArgumentException.validateNotNull(propertyResolver, "Property resolver");
        this.m_pid = pid == null || pid.trim().isEmpty() ? "" : pid.trim() + ".";
        this.m_propertyResolver = propertyResolver;
        File settingsFile = this.getSettingsFile();
        try {
            this.settings = this.buildSettings(settingsFile, this.useFallbackRepositories());
        }
        catch (SettingsBuildingException e) {
            throw new IllegalArgumentException("Can't parse settings.xml file: " + e.getMessage(), e);
        }
        this.determineLocalRepository();
        File securitySettingsFile = this.getSecuritySettingsFile();
        if (securitySettingsFile != null) {
            DefaultPlexusCipher plexusCipher = new DefaultPlexusCipher();
            DefaultSecDispatcher secDispatcher = new DefaultSecDispatcher(plexusCipher, Collections.emptyMap(), securitySettingsFile.getAbsolutePath());
            this.decrypter = new DefaultSettingsDecrypter(secDispatcher);
            this.decryptCurrentSettings();
        } else {
            this.decrypter = null;
        }
    }

    @Override
    public String getPid() {
        return this.m_pid;
    }

    @Override
    public PropertyResolver getPropertyResolver() {
        return this.m_propertyResolver;
    }

    public boolean isValid() {
        return this.getProperty("requireConfigAdminConfig", false, Boolean.class) == false;
    }

    @Override
    public boolean isOffline() {
        return this.getProperty("offline", false, Boolean.class);
    }

    @Override
    public File getSettingsFile() {
        String key = this.m_pid + "settings";
        if (!this.contains(key)) {
            ArrayList<String> fallbacks = new ArrayList<String>(4);
            fallbacks.add(this.m_propertyResolver.get(key));
            fallbacks.add(System.getProperty("user.home") + "/.m2/settings.xml");
            fallbacks.add(System.getProperty("maven.home") + "/conf/settings.xml");
            fallbacks.add(System.getenv("M2_HOME") + "/conf/settings.xml");
            File settingsFile = this.findFirstAccessibleFile("settings", fallbacks, false);
            return this.set(key, settingsFile);
        }
        return (File)this.get(key);
    }

    @Override
    public File getSecuritySettingsFile() {
        String key = this.m_pid + "security";
        if (!this.contains(key)) {
            ArrayList<String> fallbacks = new ArrayList<String>(2);
            fallbacks.add(this.m_propertyResolver.get(key));
            fallbacks.add(System.getProperty("user.home") + "/.m2/settings-security.xml");
            File settingsSecurityFile = this.findFirstAccessibleFile("security", fallbacks, false);
            return this.set(key, settingsSecurityFile);
        }
        return (File)this.get(key);
    }

    private File findFirstAccessibleFile(String option, List<String> fallbacks, boolean directory) {
        for (String location : fallbacks) {
            File f = this.safeGetFile(option, location, directory);
            if (f == null) continue;
            return f;
        }
        return null;
    }

    private File safeGetFile(String option, String path, boolean directory) {
        if (path != null && !path.trim().isEmpty()) {
            path = path.trim().replace('\\', '/');
            path = path.trim().replaceAll("%5C", "/");
            if ((path = path.trim().replaceAll("%5c", "/")).startsWith("file:")) {
                URI uri = URI.create(path);
                path = uri.isOpaque() ? uri.getSchemeSpecificPart() : uri.getPath();
            }
            File file = new File(path);
            if (directory ? !file.exists() || file.canRead() && file.isDirectory() : file.exists() && file.canRead() && file.isFile()) {
                return file;
            }
        }
        return null;
    }

    @Override
    public String getGlobalUpdatePolicy() {
        return this.getProperty("globalUpdatePolicy", null, String.class);
    }

    @Override
    public String getGlobalChecksumPolicy() {
        return this.getProperty("globalChecksumPolicy", null, String.class);
    }

    @Override
    public File getLocalRepository() {
        return (File)this.get(this.m_pid + "localRepository");
    }

    @Override
    public MavenRepositoryURL getLocalMavenRepositoryURL() {
        return (MavenRepositoryURL)this.get(this.m_pid + "localRepositoryUrl");
    }

    @Override
    public boolean useFallbackRepositories() {
        return this.getProperty("useFallbackRepositories", true, Boolean.class);
    }

    @Override
    public Integer getTimeout() {
        return this.getProperty("timeout", DEFAULT_TIMEOUT, Integer.class);
    }

    @Override
    public boolean getCertificateCheck() {
        return this.getProperty("certificateCheck", true, Boolean.class);
    }

    @Override
    public List<MavenRepositoryURL> getDefaultRepositories() throws MalformedURLException {
        String key = this.m_pid + "defaultRepositories";
        if (!this.contains(key)) {
            String defaultRepositoriesProp = this.m_propertyResolver.get(key);
            ArrayList<MavenRepositoryURL> defaultRepositoriesProperty = new ArrayList<MavenRepositoryURL>();
            if (defaultRepositoriesProp != null) {
                String[] repositories;
                for (String repositoryURL : repositories = defaultRepositoriesProp.split(REPOSITORIES_SEPARATOR_SPLIT)) {
                    defaultRepositoriesProperty.add(new MavenRepositoryURL(repositoryURL.trim()));
                }
            }
            LOGGER.trace("Using default repositories [" + defaultRepositoriesProperty + "]");
            return this.set(key, defaultRepositoriesProperty);
        }
        return (List)this.get(key);
    }

    @Override
    public List<MavenRepositoryURL> getRepositories() throws MalformedURLException {
        String key = this.m_pid + "repositories";
        if (!this.contains(key)) {
            String remoteRepositoriesProp = this.m_propertyResolver.get(key);
            ArrayList<MavenRepositoryURL> repositoriesFromSettings = new ArrayList<MavenRepositoryURL>();
            ArrayList<MavenRepositoryURL> remoteRepositories = new ArrayList<MavenRepositoryURL>();
            if (remoteRepositoriesProp == null || remoteRepositoriesProp.trim().startsWith(REPOSITORIES_APPEND_SIGN)) {
                Map<String, shaded.org.apache.maven.settings.Profile> profiles = this.settings.getProfilesAsMap();
                for (String id : this.getActiveProfileIDs()) {
                    shaded.org.apache.maven.settings.Profile profile = profiles.get(id);
                    if (profile == null) continue;
                    for (Repository repo : profile.getRepositories()) {
                        StringBuilder builder = new StringBuilder();
                        builder.append(repo.getUrl());
                        builder.append("@");
                        builder.append("id");
                        builder.append("=");
                        builder.append(repo.getId());
                        if (repo.getReleases() != null) {
                            if (!repo.getReleases().isEnabled()) {
                                builder.append("@");
                                builder.append("noreleases");
                            }
                            this.addPolicy(builder, repo.getReleases().getUpdatePolicy(), "releasesUpdate");
                            this.addPolicy(builder, repo.getReleases().getChecksumPolicy(), "releasesChecksum");
                        }
                        if (repo.getSnapshots() != null) {
                            if (repo.getSnapshots().isEnabled()) {
                                builder.append("@");
                                builder.append("snapshots");
                            }
                            this.addPolicy(builder, repo.getSnapshots().getUpdatePolicy(), "snapshotsUpdate");
                            this.addPolicy(builder, repo.getSnapshots().getChecksumPolicy(), "snapshotsChecksum");
                        }
                        repositoriesFromSettings.add(new MavenRepositoryURL(builder.toString()));
                    }
                }
            }
            if (remoteRepositoriesProp != null) {
                if (remoteRepositoriesProp.trim().startsWith(REPOSITORIES_APPEND_SIGN)) {
                    remoteRepositoriesProp = remoteRepositoriesProp.trim().substring(1);
                }
                if (!remoteRepositoriesProp.trim().isEmpty()) {
                    String[] repositories;
                    for (String repositoryURL : repositories = remoteRepositoriesProp.split(REPOSITORIES_SEPARATOR_SPLIT)) {
                        remoteRepositories.add(new MavenRepositoryURL(repositoryURL.trim()));
                    }
                }
            }
            remoteRepositories.addAll(repositoriesFromSettings);
            LOGGER.trace("Using remote repositories [" + remoteRepositories + "]");
            return this.set(key, remoteRepositories);
        }
        return (List)this.get(key);
    }

    private void addPolicy(StringBuilder builder, String policy, String option) {
        if (policy != null && !policy.isEmpty()) {
            builder.append("@");
            builder.append(option);
            builder.append("=");
            builder.append(policy);
        }
    }

    private Collection<String> getActiveProfileIDs() {
        ProfileSelector selector = new ProfileSelectorSupplier().get();
        List<shaded.org.apache.maven.settings.Profile> settingsProfiles = this.settings.getProfiles();
        ArrayList<Profile> profiles = new ArrayList<Profile>(settingsProfiles.size());
        for (shaded.org.apache.maven.settings.Profile p : settingsProfiles) {
            Profile mp = new Profile();
            mp.setSource("settings.xml");
            mp.setId(p.getId());
            shaded.org.apache.maven.settings.Activation a = p.getActivation();
            if (a != null) {
                ActivationOS ao;
                ActivationProperty ap;
                String aj;
                Activation ma = new Activation();
                mp.setActivation(ma);
                ma.setActiveByDefault(a.isActiveByDefault());
                shaded.org.apache.maven.settings.ActivationFile af = a.getFile();
                if (af != null) {
                    ActivationFile maf = new ActivationFile();
                    maf.setExists(af.getExists());
                    maf.setMissing(af.getMissing());
                    ma.setFile(maf);
                }
                if ((aj = a.getJdk()) != null) {
                    ma.setJdk(aj);
                }
                if ((ap = a.getProperty()) != null) {
                    shaded.org.apache.maven.model.ActivationProperty map = new shaded.org.apache.maven.model.ActivationProperty();
                    map.setName(ap.getName());
                    map.setValue(ap.getValue());
                    ma.setProperty(map);
                }
                if ((ao = a.getOs()) != null) {
                    shaded.org.apache.maven.model.ActivationOS mao = new shaded.org.apache.maven.model.ActivationOS();
                    mao.setName(ao.getName());
                    mao.setVersion(ao.getVersion());
                    mao.setArch(ao.getArch());
                    mao.setFamily(ao.getFamily());
                    ma.setOs(mao);
                }
            }
            profiles.add(mp);
        }
        DefaultProfileActivationContext context = new DefaultProfileActivationContext();
        context.setActiveProfileIds(this.settings.getActiveProfiles());
        context.setInactiveProfileIds(Collections.emptyList());
        context.setSystemProperties(new Properties(System.getProperties()));
        ModelProblemCollector problemCollector = new ModelProblemCollector(){

            @Override
            public void add(ModelProblemCollectorRequest req) {
                LOGGER.warn(req.getMessage() + " " + req.getLocation());
            }
        };
        List<Profile> activeProfiles = selector.getActiveProfiles(profiles, context, problemCollector);
        LinkedHashSet<String> profileNames = new LinkedHashSet<String>();
        for (Profile ap : activeProfiles) {
            profileNames.add(ap.getId());
        }
        return profileNames;
    }

    private Settings buildSettings(File settingsFile, boolean useFallbackRepositories) throws SettingsBuildingException {
        String mirror;
        Settings settings;
        if (settingsFile == null) {
            settings = new Settings();
        } else {
            SettingsBuilder builder = new SettingsBuilderSupplier().get();
            DefaultSettingsBuildingRequest request = new DefaultSettingsBuildingRequest();
            request.setUserSettingsFile(settingsFile);
            SettingsBuildingResult result = builder.build(request);
            settings = result.getEffectiveSettings();
        }
        if (useFallbackRepositories) {
            shaded.org.apache.maven.settings.Profile fallbackProfile = new shaded.org.apache.maven.settings.Profile();
            fallbackProfile.setId("fallback");
            Repository central = new Repository();
            central.setId("central");
            central.setUrl(ContextOverrides.CENTRAL.getUrl());
            central.setReleases(new RepositoryPolicy());
            central.getReleases().setEnabled(true);
            central.getReleases().setUpdatePolicy("never");
            central.getReleases().setChecksumPolicy("warn");
            central.setSnapshots(new RepositoryPolicy());
            central.getSnapshots().setEnabled(false);
            fallbackProfile.setRepositories(Collections.singletonList(central));
            settings.addProfile(fallbackProfile);
            settings.addActiveProfile("fallback");
        }
        if ((mirror = System.getenv("MAVEN_MIRROR_URL")) == null || mirror.trim().isEmpty()) {
            mirror = System.getProperty("mavenMirrorUrl", "");
        }
        if (mirror != null && !mirror.trim().isEmpty()) {
            String url;
            String[] mirrorData = mirror.trim().split("::");
            String id = "mirror";
            if (mirrorData.length > 1) {
                id = mirrorData[0];
                url = mirrorData[1];
            } else {
                url = mirrorData[0];
            }
            Mirror m = new Mirror();
            m.setId(id);
            m.setUrl(url);
            m.setLayout("default");
            m.setMirrorOf("*");
            settings.setMirrors(Collections.singletonList(m));
            LOGGER.info("Setting global Maven mirror to {}", (Object)url);
        }
        return settings;
    }

    private void decryptCurrentSettings() {
        DefaultSettingsDecryptionRequest request = new DefaultSettingsDecryptionRequest(this.settings);
        SettingsDecryptionResult result = this.decrypter.decrypt(request);
        this.settings.setServers(result.getServers());
        this.settings.setProxies(result.getProxies());
    }

    private void determineLocalRepository() {
        String key = this.m_pid + "localRepository";
        String localRepositoryProperty = this.m_propertyResolver.get(key);
        int at = localRepositoryProperty == null ? -1 : localRepositoryProperty.indexOf("@");
        String localRepositoryLocation = at > 0 ? localRepositoryProperty.substring(0, at) : localRepositoryProperty;
        ArrayList<String> fallbacks = new ArrayList<String>(4);
        fallbacks.add(localRepositoryLocation);
        fallbacks.add(this.settings.getLocalRepository());
        fallbacks.add(System.getProperty("maven.repo.local"));
        fallbacks.add(System.getProperty("user.home") + "/.m2/repository");
        fallbacks.add(System.getProperty("java.io.tmpdir") + "/.m2/repository");
        File localRepository = this.findFirstAccessibleFile("localRepository", fallbacks, true);
        if (localRepository != null) {
            this.settings.setLocalRepository(localRepository.getAbsolutePath());
            this.set(key, localRepository);
        }
        MavenRepositoryURL localRepositoryURL = null;
        File fromPid = this.safeGetFile("localRepository", localRepositoryLocation, true);
        if (fromPid != null) {
            localRepositoryProperty = at > 0 ? fromPid.toURI().toString() + localRepositoryProperty.substring(at) : fromPid.toURI().toString() + "@id=local";
            try {
                localRepositoryURL = new MavenRepositoryURL(localRepositoryProperty);
            }
            catch (MalformedURLException unexpected) {
                LOGGER.warn(unexpected.getMessage(), (Throwable)unexpected);
            }
        } else {
            try {
                localRepositoryURL = localRepository == null ? null : new MavenRepositoryURL(localRepository.toURI().toString() + "@id=local");
            }
            catch (MalformedURLException unexpected) {
                LOGGER.warn(unexpected.getMessage(), (Throwable)unexpected);
            }
        }
        this.set(this.m_pid + "localRepositoryUrl", localRepositoryURL);
    }

    @Override
    public Settings getSettings() {
        return this.settings;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
        this.determineLocalRepository();
        if (this.decrypter != null) {
            this.decryptCurrentSettings();
        }
    }

    @Override
    public <T> T getProperty(String name, T defaultValue, Class<T> clazz) {
        if (!this.contains(this.m_pid + name)) {
            String value = this.m_propertyResolver.get(this.m_pid + name);
            return this.set(this.m_pid + name, value == null ? defaultValue : this.convert(value, clazz));
        }
        return this.get(this.m_pid + name);
    }

    private <T> T convert(String value, Class<T> clazz) {
        if (String.class == clazz) {
            return (T)value;
        }
        if (Integer.class == clazz) {
            return (T)Integer.valueOf(value);
        }
        if (Long.class == clazz) {
            return (T)Long.valueOf(value);
        }
        if (Boolean.class == clazz || Boolean.TYPE == clazz) {
            return (T)Boolean.valueOf("true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value));
        }
        throw new IllegalArgumentException("Can't convert \"" + value + "\" to " + clazz + ".");
    }

    public boolean contains(String propertyName) {
        return this.m_properties.containsKey(propertyName);
    }

    public <T> T set(String propertyName, T propertyValue) {
        this.m_properties.put(propertyName, propertyValue != null ? propertyValue : NULL_VALUE);
        return propertyValue;
    }

    public <T> T get(String propertyName) {
        Object v = this.m_properties.get(propertyName);
        return (T)(v != NULL_VALUE ? v : null);
    }
}

