/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.transx.jms.impl;

import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateRuntimeException;
import javax.jms.JMSConsumer;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.JMSProducer;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.ops4j.pax.transx.jms.impl.JMSConsumerImpl;
import org.ops4j.pax.transx.jms.impl.JMSProducerImpl;
import org.ops4j.pax.transx.jms.impl.Utils;

public class JMSContextImpl
implements JMSContext {
    private final Connection connection;
    private final int sessionMode;
    private boolean autoStart = true;
    private boolean closed;
    private Session session;
    private MessageProducer sharedProducer;
    private volatile Message lastMessagesWaitingAck;

    public JMSContextImpl(Connection connection, int sessionMode) {
        this.connection = connection;
        this.sessionMode = sessionMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Session getSession() {
        if (this.session == null) {
            JMSContextImpl jMSContextImpl = this;
            synchronized (jMSContextImpl) {
                if (this.closed) {
                    throw new IllegalStateRuntimeException("Context is closed");
                }
                if (this.session == null) {
                    try {
                        this.session = this.connection.createSession(this.sessionMode);
                    }
                    catch (JMSException e) {
                        throw Utils.convertToRuntimeException(e);
                    }
                }
            }
        }
        return this.session;
    }

    public void start() {
        try {
            this.connection.start();
        }
        catch (JMSException jmse) {
            throw Utils.convertToRuntimeException(jmse);
        }
    }

    public void stop() {
        try {
            this.connection.stop();
        }
        catch (JMSException jmse) {
            throw Utils.convertToRuntimeException(jmse);
        }
    }

    public synchronized void close() {
        try {
            this.closed = true;
            this.connection.close();
        }
        catch (JMSException jmse) {
            throw Utils.convertToRuntimeException(jmse);
        }
    }

    public void acknowledge() {
        if (this.lastMessagesWaitingAck != null) {
            try {
                this.lastMessagesWaitingAck.acknowledge();
            }
            catch (JMSException jmse) {
                throw Utils.convertToRuntimeException(jmse);
            }
        }
    }

    public void commit() {
        try {
            this.getSession().commit();
        }
        catch (JMSException jmse) {
            throw Utils.convertToRuntimeException(jmse);
        }
    }

    public void rollback() {
        try {
            this.getSession().rollback();
        }
        catch (JMSException jmse) {
            throw Utils.convertToRuntimeException(jmse);
        }
    }

    public void recover() {
        try {
            this.getSession().recover();
        }
        catch (JMSException jmse) {
            throw Utils.convertToRuntimeException(jmse);
        }
    }

    public void unsubscribe(String name) {
        try {
            this.getSession().unsubscribe(name);
        }
        catch (JMSException jmse) {
            throw Utils.convertToRuntimeException(jmse);
        }
    }

    public BytesMessage createBytesMessage() {
        try {
            return this.getSession().createBytesMessage();
        }
        catch (JMSException jmse) {
            throw Utils.convertToRuntimeException(jmse);
        }
    }

    public MapMessage createMapMessage() {
        try {
            return this.getSession().createMapMessage();
        }
        catch (JMSException jmse) {
            throw Utils.convertToRuntimeException(jmse);
        }
    }

    public Message createMessage() {
        try {
            return this.getSession().createMessage();
        }
        catch (JMSException jmse) {
            throw Utils.convertToRuntimeException(jmse);
        }
    }

    public ObjectMessage createObjectMessage() {
        try {
            return this.getSession().createObjectMessage();
        }
        catch (JMSException jmse) {
            throw Utils.convertToRuntimeException(jmse);
        }
    }

    public ObjectMessage createObjectMessage(Serializable object) {
        try {
            return this.getSession().createObjectMessage(object);
        }
        catch (JMSException jmse) {
            throw Utils.convertToRuntimeException(jmse);
        }
    }

    public StreamMessage createStreamMessage() {
        try {
            return this.getSession().createStreamMessage();
        }
        catch (JMSException jmse) {
            throw Utils.convertToRuntimeException(jmse);
        }
    }

    public TextMessage createTextMessage() {
        try {
            return this.getSession().createTextMessage();
        }
        catch (JMSException jmse) {
            throw Utils.convertToRuntimeException(jmse);
        }
    }

    public TextMessage createTextMessage(String text) {
        try {
            return this.getSession().createTextMessage(text);
        }
        catch (JMSException jmse) {
            throw Utils.convertToRuntimeException(jmse);
        }
    }

    public Queue createQueue(String queueName) {
        try {
            return this.getSession().createQueue(queueName);
        }
        catch (JMSException jmse) {
            throw Utils.convertToRuntimeException(jmse);
        }
    }

    public Topic createTopic(String topicName) {
        try {
            return this.getSession().createTopic(topicName);
        }
        catch (JMSException jmse) {
            throw Utils.convertToRuntimeException(jmse);
        }
    }

    public TemporaryQueue createTemporaryQueue() {
        try {
            return this.getSession().createTemporaryQueue();
        }
        catch (JMSException jmse) {
            throw Utils.convertToRuntimeException(jmse);
        }
    }

    public TemporaryTopic createTemporaryTopic() {
        try {
            return this.getSession().createTemporaryTopic();
        }
        catch (JMSException jmse) {
            throw Utils.convertToRuntimeException(jmse);
        }
    }

    public JMSContext createContext(int sessionMode) {
        return (JMSContext)Utils.unsupported("createContext");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JMSProducer createProducer() {
        try {
            if (this.sharedProducer == null) {
                JMSContextImpl jMSContextImpl = this;
                synchronized (jMSContextImpl) {
                    if (this.sharedProducer == null) {
                        this.sharedProducer = this.getSession().createProducer(null);
                    }
                }
            }
            return new JMSProducerImpl(this, this.sharedProducer);
        }
        catch (JMSException jmse) {
            throw Utils.convertToRuntimeException(jmse);
        }
    }

    public JMSConsumer createConsumer(Destination destination) {
        try {
            return this.startIfNeeded(new JMSConsumerImpl(this, this.getSession().createConsumer(destination)));
        }
        catch (JMSException jmse) {
            throw Utils.convertToRuntimeException(jmse);
        }
    }

    public JMSConsumer createConsumer(Destination destination, String selector) {
        try {
            return this.startIfNeeded(new JMSConsumerImpl(this, this.getSession().createConsumer(destination, selector)));
        }
        catch (JMSException jmse) {
            throw Utils.convertToRuntimeException(jmse);
        }
    }

    public JMSConsumer createConsumer(Destination destination, String selector, boolean noLocal) {
        try {
            return this.startIfNeeded(new JMSConsumerImpl(this, this.getSession().createConsumer(destination, selector, noLocal)));
        }
        catch (JMSException jmse) {
            throw Utils.convertToRuntimeException(jmse);
        }
    }

    public JMSConsumer createDurableConsumer(Topic topic, String name) {
        try {
            return this.startIfNeeded(new JMSConsumerImpl(this, this.getSession().createDurableConsumer(topic, name)));
        }
        catch (JMSException jmse) {
            throw Utils.convertToRuntimeException(jmse);
        }
    }

    public JMSConsumer createDurableConsumer(Topic topic, String name, String selector, boolean noLocal) {
        try {
            return this.startIfNeeded(new JMSConsumerImpl(this, this.getSession().createDurableConsumer(topic, name, selector, noLocal)));
        }
        catch (JMSException jmse) {
            throw Utils.convertToRuntimeException(jmse);
        }
    }

    public JMSConsumer createSharedConsumer(Topic topic, String name) {
        try {
            return this.startIfNeeded(new JMSConsumerImpl(this, this.getSession().createSharedConsumer(topic, name)));
        }
        catch (JMSException jmse) {
            throw Utils.convertToRuntimeException(jmse);
        }
    }

    public JMSConsumer createSharedConsumer(Topic topic, String name, String selector) {
        try {
            return this.startIfNeeded(new JMSConsumerImpl(this, this.getSession().createSharedConsumer(topic, name, selector)));
        }
        catch (JMSException jmse) {
            throw Utils.convertToRuntimeException(jmse);
        }
    }

    public JMSConsumer createSharedDurableConsumer(Topic topic, String name) {
        try {
            return this.startIfNeeded(new JMSConsumerImpl(this, this.getSession().createSharedDurableConsumer(topic, name)));
        }
        catch (JMSException jmse) {
            throw Utils.convertToRuntimeException(jmse);
        }
    }

    public JMSConsumer createSharedDurableConsumer(Topic topic, String name, String selector) {
        try {
            return this.startIfNeeded(new JMSConsumerImpl(this, this.getSession().createSharedDurableConsumer(topic, name, selector)));
        }
        catch (JMSException jmse) {
            throw Utils.convertToRuntimeException(jmse);
        }
    }

    public QueueBrowser createBrowser(Queue queue) {
        try {
            return this.startIfNeeded(this.getSession().createBrowser(queue));
        }
        catch (JMSException jmse) {
            throw Utils.convertToRuntimeException(jmse);
        }
    }

    public QueueBrowser createBrowser(Queue queue, String selector) {
        try {
            return this.startIfNeeded(this.getSession().createBrowser(queue, selector));
        }
        catch (JMSException jmse) {
            throw Utils.convertToRuntimeException(jmse);
        }
    }

    public boolean getAutoStart() {
        return this.autoStart;
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public String getClientID() {
        try {
            return this.connection.getClientID();
        }
        catch (JMSException jmse) {
            throw Utils.convertToRuntimeException(jmse);
        }
    }

    public void setClientID(String clientID) {
        try {
            this.connection.setClientID(clientID);
        }
        catch (JMSException jmse) {
            throw Utils.convertToRuntimeException(jmse);
        }
    }

    public ExceptionListener getExceptionListener() {
        try {
            return this.connection.getExceptionListener();
        }
        catch (JMSException jmse) {
            throw Utils.convertToRuntimeException(jmse);
        }
    }

    public void setExceptionListener(ExceptionListener listener) {
        try {
            this.connection.setExceptionListener(listener);
        }
        catch (JMSException jmse) {
            throw Utils.convertToRuntimeException(jmse);
        }
    }

    public ConnectionMetaData getMetaData() {
        try {
            return this.connection.getMetaData();
        }
        catch (JMSException jmse) {
            throw Utils.convertToRuntimeException(jmse);
        }
    }

    public int getSessionMode() {
        return this.sessionMode;
    }

    public boolean getTransacted() {
        return this.sessionMode == 0;
    }

    private <T> T startIfNeeded(T consumer) throws JMSException {
        if (this.getAutoStart()) {
            this.connection.start();
        }
        return consumer;
    }

    Message setLastMessage(Message lastMessageReceived) {
        if (this.sessionMode == 2) {
            this.lastMessagesWaitingAck = lastMessageReceived;
        }
        return lastMessageReceived;
    }
}

