/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl.cache;

import java.util.function.Function;
import org.apache.maven.impl.cache.DefaultRequestCache;

public class CachingSupplier<REQ, REP>
implements Function<REQ, REP> {
    protected final Function<REQ, REP> supplier;
    protected volatile Object value;

    public CachingSupplier(Function<REQ, REP> supplier) {
        this.supplier = supplier;
    }

    public Object getValue() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public REP apply(REQ req) {
        Object v = this.value;
        if (v == null) {
            CachingSupplier cachingSupplier = this;
            synchronized (cachingSupplier) {
                v = this.value;
                if (v == null) {
                    try {
                        v = this.value = this.supplier.apply(req);
                    }
                    catch (Exception e) {
                        v = this.value = new AltRes(e);
                    }
                }
            }
        }
        if (v instanceof AltRes) {
            AltRes altRes = (AltRes)v;
            DefaultRequestCache.uncheckedThrow(altRes.throwable);
        }
        return (REP)v;
    }

    public static class AltRes {
        protected final Throwable throwable;

        public AltRes(Throwable throwable) {
            this.throwable = throwable;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }
    }
}

