/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.runtime;

import java.net.InetSocketAddress;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.nifi.NiFiServer;
import org.apache.nifi.runtime.ManagementServer;
import org.apache.nifi.runtime.StandardManagementServer;

class ManagementServerProvider {
    static final String MANAGEMENT_SERVER_ADDRESS = "org.apache.nifi.management.server.address";
    private static final Pattern MANAGEMENT_SERVER_ADDRESS_PATTERN = Pattern.compile("^(.+?):([1-9][0-9]{3,4})$");
    private static final String MANAGEMENT_SERVER_DEFAULT_ADDRESS = "127.0.0.1:52020";
    private static final int ADDRESS_GROUP = 1;
    private static final int PORT_GROUP = 2;

    ManagementServerProvider() {
    }

    static ManagementServer getManagementServer(NiFiServer nifiServer) {
        String managementServerAddressProperty = System.getProperty(MANAGEMENT_SERVER_ADDRESS, MANAGEMENT_SERVER_DEFAULT_ADDRESS);
        Matcher matcher = MANAGEMENT_SERVER_ADDRESS_PATTERN.matcher(managementServerAddressProperty);
        if (matcher.matches()) {
            String addressGroup = matcher.group(1);
            String portGroup = matcher.group(2);
            int port = Integer.parseInt(portGroup);
            InetSocketAddress bindAddress = new InetSocketAddress(addressGroup, port);
            return new StandardManagementServer(bindAddress, nifiServer);
        }
        throw new IllegalStateException("Management Server Address System Property [%s] not valid [%s]".formatted(MANAGEMENT_SERVER_ADDRESS, managementServerAddressProperty));
    }
}

