/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.result.registry;

import java.io.IOException;
import java.io.PrintStream;
import org.apache.nifi.registry.extension.bundle.BundleVersion;
import org.apache.nifi.toolkit.cli.api.ResultType;
import org.apache.nifi.toolkit.cli.impl.result.AbstractWritableResult;

public class BundleVersionResult
extends AbstractWritableResult<BundleVersion> {
    private BundleVersion extensionBundleVersion;

    public BundleVersionResult(ResultType resultType, BundleVersion extensionBundleVersion) {
        super(resultType);
        this.extensionBundleVersion = extensionBundleVersion;
    }

    @Override
    public BundleVersion getResult() {
        return this.extensionBundleVersion;
    }

    @Override
    protected void writeSimpleResult(PrintStream output) throws IOException {
        String artifactId = this.extensionBundleVersion.getBundle().getArtifactId();
        String groupId = this.extensionBundleVersion.getBundle().getGroupId();
        String version = this.extensionBundleVersion.getVersionMetadata().getVersion();
        String bundleCoordinate = groupId + "::" + artifactId + "::" + version;
        output.println(bundleCoordinate);
    }
}

