/****************************************************************************
 * arch/arm/src/stm32f0l0g0/hardware/stm32g0_dmamux.h
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.  The
 * ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 ****************************************************************************/

#ifndef __ARCH_ARM_SRC_STM32F0L0G0_HARDWARE_STM32G0_DMAMUX_H
#define __ARCH_ARM_SRC_STM32F0L0G0_HARDWARE_STM32G0_DMAMUX_H

/****************************************************************************
 * Included Files
 ****************************************************************************/

#include <nuttx/config.h>
#include "chip.h"

/****************************************************************************
 * Pre-processor Definitions
 ****************************************************************************/

/* DMAMUX1 mapping **********************************************************/

/* Peripheral to DMAMUX request line mappings (RM0444 Rev 6, Table 55) */

#define DMAMUX1_REQ_GEN0            1
#define DMAMAP_DMA1_REQ_GEN0        DMAMAP_MAP(DMA1, DMAMUX1_REQ_GEN0)
#define DMAMAP_DMA2_REQ_GEN0        DMAMAP_MAP(DMA2, DMAMUX1_REQ_GEN0)
#define DMAMUX1_REQ_GEN1            2
#define DMAMAP_DMA1_REQ_GEN1        DMAMAP_MAP(DMA1, DMAMUX1_REQ_GEN1)
#define DMAMAP_DMA2_REQ_GEN1        DMAMAP_MAP(DMA2, DMAMUX1_REQ_GEN1)
#define DMAMUX1_REQ_GEN2            3
#define DMAMAP_DMA1_REQ_GEN2        DMAMAP_MAP(DMA1, DMAMUX1_REQ_GEN2)
#define DMAMAP_DMA2_REQ_GEN2        DMAMAP_MAP(DMA2, DMAMUX1_REQ_GEN2)
#define DMAMUX1_REQ_GEN3            4
#define DMAMAP_DMA1_REQ_GEN3        DMAMAP_MAP(DMA1, DMAMUX1_REQ_GEN3)
#define DMAMAP_DMA2_REQ_GEN3        DMAMAP_MAP(DMA2, DMAMUX1_REQ_GEN3)
#define DMAMUX1_ADC1                5
#define DMAMAP_DMA1_ADC1            DMAMAP_MAP(DMA1, DMAMUX1_ADC1)
#define DMAMAP_DMA2_ADC1            DMAMAP_MAP(DMA2, DMAMUX1_ADC1)
#define DMAMUX1_AES_IN              6
#define DMAMAP_DMA1_AES_IN          DMAMAP_MAP(DMA1, DMAMUX1_AES_IN)
#define DMAMAP_DMA2_AES_IN          DMAMAP_MAP(DMA2, DMAMUX1_AES_IN)
#define DMAMUX1_AES_OUT             7
#define DMAMAP_DMA1_AES_OUT         DMAMAP_MAP(DMA1, DMAMUX1_AES_OUT)
#define DMAMAP_DMA2_AES_OUT         DMAMAP_MAP(DMA2, DMAMUX1_AES_OUT)
#define DMAMUX1_DAC_CH1             8
#define DMAMAP_DMA1_DAC_CH1         DMAMAP_MAP(DMA1, DMAMUX1_DAC_CH1)
#define DMAMAP_DMA2_DAC_CH1         DMAMAP_MAP(DMA2, DMAMUX1_DAC_CH1)
#define DMAMUX1_DAC_CH2             9
#define DMAMAP_DMA1_DAC_CH2         DMAMAP_MAP(DMA1, DMAMUX1_DAC_CH2)
#define DMAMAP_DMA2_DAC_CH2         DMAMAP_MAP(DMA2, DMAMUX1_DAC_CH2)
#define DMAMUX1_I2C1_RX             10
#define DMAMAP_DMA1_I2C1_RX         DMAMAP_MAP(DMA1, DMAMUX1_I2C1_RX)
#define DMAMAP_DMA2_I2C1_RX         DMAMAP_MAP(DMA2, DMAMUX1_I2C1_RX)
#define DMAMUX1_I2C1_TX             11
#define DMAMAP_DMA1_I2C1_TX         DMAMAP_MAP(DMA1, DMAMUX1_I2C1_TX)
#define DMAMAP_DMA2_I2C1_TX         DMAMAP_MAP(DMA2, DMAMUX1_I2C1_TX)
#define DMAMUX1_I2C2_RX             12
#define DMAMAP_DMA1_I2C2_RX         DMAMAP_MAP(DMA1, DMAMUX1_I2C2_RX)
#define DMAMAP_DMA2_I2C2_RX         DMAMAP_MAP(DMA2, DMAMUX1_I2C2_RX)
#define DMAMUX1_I2C2_TX             13
#define DMAMAP_DMA1_I2C2_TX         DMAMAP_MAP(DMA1, DMAMUX1_I2C2_TX)
#define DMAMAP_DMA2_I2C2_TX         DMAMAP_MAP(DMA2, DMAMUX1_I2C2_TX)
#define DMAMUX1_LPUART1_RX          14
#define DMAMAP_DMA1_LPUART1_RX      DMAMAP_MAP(DMA1, DMAMUX1_LPUART1_RX)
#define DMAMAP_DMA2_LPUART1_RX      DMAMAP_MAP(DMA2, DMAMUX1_LPUART1_RX)
#define DMAMUX1_LPUART1_TX          15
#define DMAMAP_DMA1_LPUART1_TX      DMAMAP_MAP(DMA1, DMAMUX1_LPUART1_TX)
#define DMAMAP_DMA2_LPUART1_TX      DMAMAP_MAP(DMA2, DMAMUX1_LPUART1_TX)
#define DMAMUX1_SPI1_RX             16
#define DMAMAP_DMA1_SPI1_RX         DMAMAP_MAP(DMA1, DMAMUX1_SPI1_RX)
#define DMAMAP_DMA2_SPI1_RX         DMAMAP_MAP(DMA2, DMAMUX1_SPI1_RX)
#define DMAMUX1_SPI1_TX             17
#define DMAMAP_DMA1_SPI1_TX         DMAMAP_MAP(DMA1, DMAMUX1_SPI1_TX)
#define DMAMAP_DMA2_SPI1_TX         DMAMAP_MAP(DMA2, DMAMUX1_SPI1_TX)
#define DMAMUX1_SPI2_RX             18
#define DMAMAP_DMA1_SPI2_RX         DMAMAP_MAP(DMA1, DMAMUX1_SPI2_RX)
#define DMAMAP_DMA2_SPI2_RX         DMAMAP_MAP(DMA2, DMAMUX1_SPI2_RX)
#define DMAMUX1_SPI2_TX             19
#define DMAMAP_DMA1_SPI2_TX         DMAMAP_MAP(DMA1, DMAMUX1_SPI2_TX)
#define DMAMAP_DMA2_SPI2_TX         DMAMAP_MAP(DMA2, DMAMUX1_SPI2_TX)
#define DMAMUX1_TIM1_CH1            20
#define DMAMAP_DMA1_TIM1_CH1        DMAMAP_MAP(DMA1, DMAMUX1_TIM1_CH1)
#define DMAMAP_DMA2_TIM1_CH1        DMAMAP_MAP(DMA2, DMAMUX1_TIM1_CH1)
#define DMAMUX1_TIM1_CH2            21
#define DMAMAP_DMA1_TIM1_CH2        DMAMAP_MAP(DMA1, DMAMUX1_TIM1_CH2)
#define DMAMAP_DMA2_TIM1_CH2        DMAMAP_MAP(DMA2, DMAMUX1_TIM1_CH2)
#define DMAMUX1_TIM1_CH3            22
#define DMAMAP_DMA1_TIM1_CH3        DMAMAP_MAP(DMA1, DMAMUX1_TIM1_CH3)
#define DMAMAP_DMA2_TIM1_CH3        DMAMAP_MAP(DMA2, DMAMUX1_TIM1_CH3)
#define DMAMUX1_TIM1_CH4            23
#define DMAMAP_DMA1_TIM1_CH4        DMAMAP_MAP(DMA1, DMAMUX1_TIM1_CH4)
#define DMAMAP_DMA2_TIM1_CH4        DMAMAP_MAP(DMA2, DMAMUX1_TIM1_CH4)
#define DMAMUX1_TIM1_TRIG           24
#define DMAMAP_DMA1_TIM1_TRIG       DMAMAP_MAP(DMA1, DMAMUX1_TIM1_TRIG)
#define DMAMAP_DMA2_TIM1_TRIG       DMAMAP_MAP(DMA2, DMAMUX1_TIM1_TRIG)
#define DMAMUX1_TIM1_UP             25
#define DMAMAP_DMA1_TIM1_UP         DMAMAP_MAP(DMA1, DMAMUX1_TIM1_UP)
#define DMAMAP_DMA2_TIM1_UP         DMAMAP_MAP(DMA2, DMAMUX1_TIM1_UP)
#define DMAMUX1_TIM2_CH1            26
#define DMAMAP_DMA1_TIM2_CH1        DMAMAP_MAP(DMA1, DMAMUX1_TIM2_CH1)
#define DMAMAP_DMA2_TIM2_CH1        DMAMAP_MAP(DMA2, DMAMUX1_TIM2_CH1)
#define DMAMUX1_TIM2_CH2            27
#define DMAMAP_DMA1_TIM2_CH2        DMAMAP_MAP(DMA1, DMAMUX1_TIM2_CH2)
#define DMAMAP_DMA2_TIM2_CH2        DMAMAP_MAP(DMA2, DMAMUX1_TIM2_CH2)
#define DMAMUX1_TIM2_CH3            28
#define DMAMAP_DMA1_TIM2_CH3        DMAMAP_MAP(DMA1, DMAMUX1_TIM2_CH3)
#define DMAMAP_DMA2_TIM2_CH3        DMAMAP_MAP(DMA2, DMAMUX1_TIM2_CH3)
#define DMAMUX1_TIM2_CH4            29
#define DMAMAP_DMA1_TIM2_CH4        DMAMAP_MAP(DMA1, DMAMUX1_TIM2_CH4)
#define DMAMAP_DMA2_TIM2_CH4        DMAMAP_MAP(DMA2, DMAMUX1_TIM2_CH4)
#define DMAMUX1_TIM2_TRIG           30
#define DMAMAP_DMA1_TIM2_TRIG       DMAMAP_MAP(DMA1, DMAMUX1_TIM2_TRIG)
#define DMAMAP_DMA2_TIM2_TRIG       DMAMAP_MAP(DMA2, DMAMUX1_TIM2_TRIG)
#define DMAMUX1_TIM2_UP             31
#define DMAMAP_DMA1_TIM2_UP         DMAMAP_MAP(DMA1, DMAMUX1_TIM2_UP)
#define DMAMAP_DMA2_TIM2_UP         DMAMAP_MAP(DMA2, DMAMUX1_TIM2_UP)
#define DMAMUX1_TIM3_CH1            32
#define DMAMAP_DMA1_TIM3_CH1        DMAMAP_MAP(DMA1, DMAMUX1_TIM3_CH1)
#define DMAMAP_DMA2_TIM3_CH1        DMAMAP_MAP(DMA2, DMAMUX1_TIM3_CH1)
#define DMAMUX1_TIM3_CH2            33
#define DMAMAP_DMA1_TIM3_CH2        DMAMAP_MAP(DMA1, DMAMUX1_TIM3_CH2)
#define DMAMAP_DMA2_TIM3_CH2        DMAMAP_MAP(DMA2, DMAMUX1_TIM3_CH2)
#define DMAMUX1_TIM3_CH3            34
#define DMAMAP_DMA1_TIM3_CH3        DMAMAP_MAP(DMA1, DMAMUX1_TIM3_CH3)
#define DMAMAP_DMA2_TIM3_CH3        DMAMAP_MAP(DMA2, DMAMUX1_TIM3_CH3)
#define DMAMUX1_TIM3_CH4            35
#define DMAMAP_DMA1_TIM3_CH4        DMAMAP_MAP(DMA1, DMAMUX1_TIM3_CH4)
#define DMAMAP_DMA2_TIM3_CH4        DMAMAP_MAP(DMA2, DMAMUX1_TIM3_CH4)
#define DMAMUX1_TIM3_TRIG           36
#define DMAMAP_DMA1_TIM3_TRIG       DMAMAP_MAP(DMA1, DMAMUX1_TIM3_TRIG)
#define DMAMAP_DMA2_TIM3_TRIG       DMAMAP_MAP(DMA2, DMAMUX1_TIM3_TRIG)
#define DMAMUX1_TIM3_UP             37
#define DMAMAP_DMA1_TIM3_UP         DMAMAP_MAP(DMA1, DMAMUX1_TIM3_UP)
#define DMAMAP_DMA2_TIM3_UP         DMAMAP_MAP(DMA2, DMAMUX1_TIM3_UP)
#define DMAMUX1_TIM6_UP             38
#define DMAMAP_DMA1_TIM6_UP         DMAMAP_MAP(DMA1, DMAMUX1_TIM6_UP)
#define DMAMAP_DMA2_TIM6_UP         DMAMAP_MAP(DMA2, DMAMUX1_TIM6_UP)
#define DMAMUX1_TIM7_UP             39
#define DMAMAP_DMA1_TIM7_UP         DMAMAP_MAP(DMA1, DMAMUX1_TIM7_UP)
#define DMAMAP_DMA2_TIM7_UP         DMAMAP_MAP(DMA2, DMAMUX1_TIM7_UP)
#define DMAMUX1_TIM15_CH1           40
#define DMAMAP_DMA1_TIM15_CH1       DMAMAP_MAP(DMA1, DMAMUX1_TIM15_CH1)
#define DMAMAP_DMA2_TIM15_CH1       DMAMAP_MAP(DMA2, DMAMUX1_TIM15_CH1)
#define DMAMUX1_TIM15_CH2           41
#define DMAMAP_DMA1_TIM15_CH2       DMAMAP_MAP(DMA1, DMAMUX1_TIM15_CH2)
#define DMAMAP_DMA2_TIM15_CH2       DMAMAP_MAP(DMA2, DMAMUX1_TIM15_CH2)
#define DMAMUX1_TIM15_TRIG_COM      42
#define DMAMAP_DMA1_TIM15_TRIG_COM  DMAMAP_MAP(DMA1, DMAMUX1_TIM15_TRIG_COM)
#define DMAMAP_DMA2_TIM15_TRIG_COM  DMAMAP_MAP(DMA2, DMAMUX1_TIM15_TRIG_COM)
#define DMAMUX1_TIM15_UP            43
#define DMAMAP_DMA1_TIM15_UP        DMAMAP_MAP(DMA1, DMAMUX1_TIM15_UP)
#define DMAMAP_DMA2_TIM15_UP        DMAMAP_MAP(DMA2, DMAMUX1_TIM15_UP)
#define DMAMUX1_TIM16_CH1           44
#define DMAMAP_DMA1_TIM16_CH1       DMAMAP_MAP(DMA1, DMAMUX1_TIM16_CH1)
#define DMAMAP_DMA2_TIM16_CH1       DMAMAP_MAP(DMA2, DMAMUX1_TIM16_CH1)
#define DMAMUX1_TIM16_COM           45
#define DMAMAP_DMA1_TIM16_COM       DMAMAP_MAP(DMA1, DMAMUX1_TIM16_COM)
#define DMAMAP_DMA2_TIM16_COM       DMAMAP_MAP(DMA2, DMAMUX1_TIM16_COM)
#define DMAMUX1_TIM16_UP            46
#define DMAMAP_DMA1_TIM16_UP        DMAMAP_MAP(DMA1, DMAMUX1_TIM16_UP)
#define DMAMAP_DMA2_TIM16_UP        DMAMAP_MAP(DMA2, DMAMUX1_TIM16_UP)
#define DMAMUX1_TIM17_CH1           47
#define DMAMAP_DMA1_TIM17_CH1       DMAMAP_MAP(DMA1, DMAMUX1_TIM17_CH1)
#define DMAMAP_DMA2_TIM17_CH1       DMAMAP_MAP(DMA2, DMAMUX1_TIM17_CH1)
#define DMAMUX1_TIM17_COM           48
#define DMAMAP_DMA1_TIM17_COM       DMAMAP_MAP(DMA1, DMAMUX1_TIM17_COM)
#define DMAMAP_DMA2_TIM17_COM       DMAMAP_MAP(DMA2, DMAMUX1_TIM17_COM)
#define DMAMUX1_TIM17_UP            49
#define DMAMAP_DMA1_TIM17_UP        DMAMAP_MAP(DMA1, DMAMUX1_TIM17_UP)
#define DMAMAP_DMA2_TIM17_UP        DMAMAP_MAP(DMA2, DMAMUX1_TIM17_UP)
#define DMAMUX1_USART1_RX           50
#define DMAMAP_DMA1_USART1_RX       DMAMAP_MAP(DMA1, DMAMUX1_USART1_RX)
#define DMAMAP_DMA2_USART1_RX       DMAMAP_MAP(DMA2, DMAMUX1_USART1_RX)
#define DMAMUX1_USART1_TX           51
#define DMAMAP_DMA1_USART1_TX       DMAMAP_MAP(DMA1, DMAMUX1_USART1_TX)
#define DMAMAP_DMA2_USART1_TX       DMAMAP_MAP(DMA2, DMAMUX1_USART1_TX)
#define DMAMUX1_USART2_RX           52
#define DMAMAP_DMA1_USART2_RX       DMAMAP_MAP(DMA1, DMAMUX1_USART2_RX)
#define DMAMAP_DMA2_USART2_RX       DMAMAP_MAP(DMA2, DMAMUX1_USART2_RX)
#define DMAMUX1_USART2_TX           53
#define DMAMAP_DMA1_USART2_TX       DMAMAP_MAP(DMA1, DMAMUX1_USART2_TX)
#define DMAMAP_DMA2_USART2_TX       DMAMAP_MAP(DMA2, DMAMUX1_USART2_TX)
#define DMAMUX1_USART3_RX           54
#define DMAMAP_DMA1_USART3_RX       DMAMAP_MAP(DMA1, DMAMUX1_USART3_RX)
#define DMAMAP_DMA2_USART3_RX       DMAMAP_MAP(DMA2, DMAMUX1_USART3_RX)
#define DMAMUX1_USART3_TX           55
#define DMAMAP_DMA1_USART3_TX       DMAMAP_MAP(DMA1, DMAMUX1_USART3_TX)
#define DMAMAP_DMA2_USART3_TX       DMAMAP_MAP(DMA2, DMAMUX1_USART3_TX)
#define DMAMUX1_USART4_RX           56
#define DMAMAP_DMA1_USART4_RX       DMAMAP_MAP(DMA1, DMAMUX1_USART4_RX)
#define DMAMAP_DMA2_USART4_RX       DMAMAP_MAP(DMA2, DMAMUX1_USART4_RX)
#define DMAMUX1_USART4_TX           57
#define DMAMAP_DMA1_USART4_TX       DMAMAP_MAP(DMA1, DMAMUX1_USART4_TX)
#define DMAMAP_DMA2_USART4_TX       DMAMAP_MAP(DMA2, DMAMUX1_USART4_TX)
#define DMAMUX1_UCPD1_RX            58
#define DMAMAP_DMA1_UCPD1_RX        DMAMAP_MAP(DMA1, DMAMUX1_UCPD1_RX)
#define DMAMAP_DMA2_UCPD1_RX        DMAMAP_MAP(DMA2, DMAMUX1_UCPD1_RX)
#define DMAMUX1_UCPD1_TX            59
#define DMAMAP_DMA1_UCPD1_TX        DMAMAP_MAP(DMA1, DMAMUX1_UCPD1_TX)
#define DMAMAP_DMA2_UCPD1_TX        DMAMAP_MAP(DMA2, DMAMUX1_UCPD1_TX)
#define DMAMUX1_UCPD2_RX            60
#define DMAMAP_DMA1_UCPD2_RX        DMAMAP_MAP(DMA1, DMAMUX1_UCPD2_RX)
#define DMAMAP_DMA2_UCPD2_RX        DMAMAP_MAP(DMA2, DMAMUX1_UCPD2_RX)
#define DMAMUX1_UCPD2_TX            61
#define DMAMAP_DMA1_UCPD2_TX        DMAMAP_MAP(DMA1, DMAMUX1_UCPD2_TX)
#define DMAMAP_DMA2_UCPD2_TX        DMAMAP_MAP(DMA2, DMAMUX1_UCPD2_TX)
#define DMAMUX1_I2C3_RX             62
#define DMAMAP_DMA1_I2C3_RX         DMAMAP_MAP(DMA1, DMAMUX1_I2C3_RX)
#define DMAMAP_DMA2_I2C3_RX         DMAMAP_MAP(DMA2, DMAMUX1_I2C3_RX)
#define DMAMUX1_I2C3_TX             63
#define DMAMAP_DMA1_I2C3_TX         DMAMAP_MAP(DMA1, DMAMUX1_I2C3_TX)
#define DMAMAP_DMA2_I2C3_TX         DMAMAP_MAP(DMA2, DMAMUX1_I2C3_TX)
#define DMAMUX1_LPUART2_RX          64
#define DMAMAP_DMA1_LPUART2_RX      DMAMAP_MAP(DMA1, DMAMUX1_LPUART2_RX)
#define DMAMAP_DMA2_LPUART2_RX      DMAMAP_MAP(DMA2, DMAMUX1_LPUART2_RX)
#define DMAMUX1_LPUART2_TX          65
#define DMAMAP_DMA1_LPUART2_TX      DMAMAP_MAP(DMA1, DMAMUX1_LPUART2_TX)
#define DMAMAP_DMA2_LPUART2_TX      DMAMAP_MAP(DMA2, DMAMUX1_LPUART2_TX)
#define DMAMUX1_SPI3_RX             66
#define DMAMAP_DMA1_SPI3_RX         DMAMAP_MAP(DMA1, DMAMUX1_SPI3_RX)
#define DMAMAP_DMA2_SPI3_RX         DMAMAP_MAP(DMA2, DMAMUX1_SPI3_RX)
#define DMAMUX1_SPI3_TX             67
#define DMAMAP_DMA1_SPI3_TX         DMAMAP_MAP(DMA1, DMAMUX1_SPI3_TX)
#define DMAMAP_DMA2_SPI3_TX         DMAMAP_MAP(DMA2, DMAMUX1_SPI3_TX)
#define DMAMUX1_TIM4_CH1            68
#define DMAMAP_DMA1_TIM4_CH1        DMAMAP_MAP(DMA1, DMAMUX1_TIM4_CH1)
#define DMAMAP_DMA2_TIM4_CH1        DMAMAP_MAP(DMA2, DMAMUX1_TIM4_CH1)
#define DMAMUX1_TIM4_CH2            69
#define DMAMAP_DMA1_TIM4_CH2        DMAMAP_MAP(DMA1, DMAMUX1_TIM4_CH2)
#define DMAMAP_DMA2_TIM4_CH2        DMAMAP_MAP(DMA2, DMAMUX1_TIM4_CH2)
#define DMAMUX1_TIM4_CH3            70
#define DMAMAP_DMA1_TIM4_CH3        DMAMAP_MAP(DMA1, DMAMUX1_TIM4_CH3)
#define DMAMAP_DMA2_TIM4_CH3        DMAMAP_MAP(DMA2, DMAMUX1_TIM4_CH3)
#define DMAMUX1_TIM4_CH4            71
#define DMAMAP_DMA1_TIM4_CH4        DMAMAP_MAP(DMA1, DMAMUX1_TIM4_CH4)
#define DMAMAP_DMA2_TIM4_CH4        DMAMAP_MAP(DMA2, DMAMUX1_TIM4_CH4)
#define DMAMUX1_TIM4_TRIG           72
#define DMAMAP_DMA1_TIM4_TRIG       DMAMAP_MAP(DMA1, DMAMUX1_TIM4_TRIG)
#define DMAMAP_DMA2_TIM4_TRIG       DMAMAP_MAP(DMA2, DMAMUX1_TIM4_TRIG)
#define DMAMUX1_TIM4_UP             73
#define DMAMAP_DMA1_TIM4_UP         DMAMAP_MAP(DMA1, DMAMUX1_TIM4_UP)
#define DMAMAP_DMA2_TIM4_UP         DMAMAP_MAP(DMA2, DMAMUX1_TIM4_UP)
#define DMAMUX1_USART5_RX           74
#define DMAMAP_DMA1_USART5_RX       DMAMAP_MAP(DMA1, DMAMUX1_USART5_RX)
#define DMAMAP_DMA2_USART5_RX       DMAMAP_MAP(DMA2, DMAMUX1_USART5_RX)
#define DMAMUX1_USART5_TX           75
#define DMAMAP_DMA1_USART5_TX       DMAMAP_MAP(DMA1, DMAMUX1_USART5_TX)
#define DMAMAP_DMA2_USART5_TX       DMAMAP_MAP(DMA2, DMAMUX1_USART5_TX)
#define DMAMUX1_USART6_RX           76
#define DMAMAP_DMA1_USART6_RX       DMAMAP_MAP(DMA1, DMAMUX1_USART6_RX)
#define DMAMAP_DMA2_USART6_RX       DMAMAP_MAP(DMA2, DMAMUX1_USART6_RX)
#define DMAMUX1_USART6_TX           77
#define DMAMAP_DMA1_USART6_TX       DMAMAP_MAP(DMA1, DMAMUX1_USART6_TX)
#define DMAMAP_DMA2_USART6_TX       DMAMAP_MAP(DMA2, DMAMUX1_USART6_TX)

/* DMAMUX trigger input sources (Table 56, RM0444 Rev 6) */

#define DMAMUX_TRIG_EXTI0           0
#define DMAMUX_TRIG_EXTI1           1
#define DMAMUX_TRIG_EXTI2           2
#define DMAMUX_TRIG_EXTI3           3
#define DMAMUX_TRIG_EXTI4           4
#define DMAMUX_TRIG_EXTI5           5
#define DMAMUX_TRIG_EXTI6           6
#define DMAMUX_TRIG_EXTI7           7
#define DMAMUX_TRIG_EXTI8           8
#define DMAMUX_TRIG_EXTI9           9
#define DMAMUX_TRIG_EXTI10          10
#define DMAMUX_TRIG_EXTI11          11
#define DMAMUX_TRIG_EXTI12          12
#define DMAMUX_TRIG_EXTI13          13
#define DMAMUX_TRIG_EXTI14          14
#define DMAMUX_TRIG_EXTI15          15
#define DMAMUX_TRIG_EVT0            16
#define DMAMUX_TRIG_EVT1            17
#define DMAMUX_TRIG_EVT2            18
#define DMAMUX_TRIG_EVT3            19
#define DMAMUX_TRIG_LPTIM1_OUT      20
#define DMAMUX_TRIG_LPTIM2_OUT      21
#define DMAMUX_TRIG_TIM14_OC        22

/* Sync inputs use the same values as trigger inputs (Table 57) */

#define DMAMUX_SYNC_EXTI0           0
#define DMAMUX_SYNC_EXTI1           1
#define DMAMUX_SYNC_EXTI2           2
#define DMAMUX_SYNC_EXTI3           3
#define DMAMUX_SYNC_EXTI4           4
#define DMAMUX_SYNC_EXTI5           5
#define DMAMUX_SYNC_EXTI6           6
#define DMAMUX_SYNC_EXTI7           7
#define DMAMUX_SYNC_EXTI8           8
#define DMAMUX_SYNC_EXTI9           9
#define DMAMUX_SYNC_EXTI10          10
#define DMAMUX_SYNC_EXTI11          11
#define DMAMUX_SYNC_EXTI12          12
#define DMAMUX_SYNC_EXTI13          13
#define DMAMUX_SYNC_EXTI14          14
#define DMAMUX_SYNC_EXTI15          15
#define DMAMUX_SYNC_EVT0            16
#define DMAMUX_SYNC_EVT1            17
#define DMAMUX_SYNC_EVT2            18
#define DMAMUX_SYNC_EVT3            19
#define DMAMUX_SYNC_LPTIM1_OUT      20
#define DMAMUX_SYNC_LPTIM2_OUT      21
#define DMAMUX_SYNC_TIM14_OC        22

#endif /* __ARCH_ARM_SRC_STM32F0L0G0_HARDWARE_STM32G0_DMAMUX_H */
