/****************************************************************************
 * arch/arm64/src/imx9/hardware/imx93/imx93_pinmux.h
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.  The
 * ASF licenses this file to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 ****************************************************************************/

#ifndef __ARCH_ARM64_SRC_IMX9_HARDWARE_IMX93_IMX93_PINMUX_H
#define __ARCH_ARM64_SRC_IMX9_HARDWARE_IMX93_IMX93_PINMUX_H

#define IOMUXC_PAD_DAP_TDI_JTAG_MUX_TDI                          IOMUX_PADCFG(0x443c0000, 0x0, 0x443c03d8, 0x00000000, 0x443c01b0)
#define IOMUXC_PAD_DAP_TDI_MQS2_LEFT                             IOMUX_PADCFG(0x443c0000, 0x1, 0x00000000, 0x00000000, 0x443c01b0)
#define IOMUXC_PAD_DAP_TDI_CAN2_TX                               IOMUX_PADCFG(0x443c0000, 0x3, 0x00000000, 0x00000000, 0x443c01b0)
#define IOMUXC_PAD_DAP_TDI_FLEXIO2_FLEXIO30                      IOMUX_PADCFG(0x443c0000, 0x4, 0x00000000, 0x00000000, 0x443c01b0)
#define IOMUXC_PAD_DAP_TDI_GPIO3_IO28                            IOMUX_PADCFG(0x443c0000, 0x5, 0x00000000, 0x00000000, 0x443c01b0)
#define IOMUXC_PAD_DAP_TDI_LPUART5_RX                            IOMUX_PADCFG(0x443c0000, 0x6, 0x443c0430, 0x00000000, 0x443c01b0)
#define IOMUXC_PAD_DAP_TMS_SWDIO_JTAG_MUX_TMS                    IOMUX_PADCFG(0x443c0004, 0x0, 0x443c03dc, 0x00000000, 0x443c01b4)
#define IOMUXC_PAD_DAP_TMS_SWDIO_FLEXIO2_FLEXIO31                IOMUX_PADCFG(0x443c0004, 0x4, 0x00000000, 0x00000000, 0x443c01b4)
#define IOMUXC_PAD_DAP_TMS_SWDIO_GPIO3_IO29                      IOMUX_PADCFG(0x443c0004, 0x5, 0x00000000, 0x00000000, 0x443c01b4)
#define IOMUXC_PAD_DAP_TMS_SWDIO_LPUART5_RTS_B                   IOMUX_PADCFG(0x443c0004, 0x6, 0x00000000, 0x00000000, 0x443c01b4)
#define IOMUXC_PAD_DAP_TCLK_SWCLK_JTAG_MUX_TCK                   IOMUX_PADCFG(0x443c0008, 0x0, 0x443c03d4, 0x00000000, 0x443c01b8)
#define IOMUXC_PAD_DAP_TCLK_SWCLK_FLEXIO1_FLEXIO30               IOMUX_PADCFG(0x443c0008, 0x4, 0x00000000, 0x00000000, 0x443c01b8)
#define IOMUXC_PAD_DAP_TCLK_SWCLK_GPIO3_IO30                     IOMUX_PADCFG(0x443c0008, 0x5, 0x00000000, 0x00000000, 0x443c01b8)
#define IOMUXC_PAD_DAP_TCLK_SWCLK_LPUART5_CTS_B                  IOMUX_PADCFG(0x443c0008, 0x6, 0x443c042c, 0x00000000, 0x443c01b8)
#define IOMUXC_PAD_DAP_TDO_TRACESWO_JTAG_MUX_TDO                 IOMUX_PADCFG(0x443c000c, 0x0, 0x00000000, 0x00000000, 0x443c01bc)
#define IOMUXC_PAD_DAP_TDO_TRACESWO_MQS2_RIGHT                   IOMUX_PADCFG(0x443c000c, 0x1, 0x00000000, 0x00000000, 0x443c01bc)
#define IOMUXC_PAD_DAP_TDO_TRACESWO_CAN2_RX                      IOMUX_PADCFG(0x443c000c, 0x3, 0x443c0364, 0x00000000, 0x443c01bc)
#define IOMUXC_PAD_DAP_TDO_TRACESWO_FLEXIO1_FLEXIO31             IOMUX_PADCFG(0x443c000c, 0x4, 0x00000000, 0x00000000, 0x443c01bc)
#define IOMUXC_PAD_DAP_TDO_TRACESWO_GPIO3_IO31                   IOMUX_PADCFG(0x443c000c, 0x5, 0x00000000, 0x00000000, 0x443c01bc)
#define IOMUXC_PAD_DAP_TDO_TRACESWO_LPUART5_TX                   IOMUX_PADCFG(0x443c000c, 0x6, 0x443c0434, 0x00000000, 0x443c01bc)
#define IOMUXC_PAD_GPIO_IO00_GPIO2_IO00                          IOMUX_PADCFG(0x443c0010, 0x0, 0x00000000, 0x00000000, 0x443c01c0)
#define IOMUXC_PAD_GPIO_IO00_LPI2C3_SDA                          IOMUX_PADCFG(0x443c0010, 0x1, 0x443c03e4, 0x00000000, 0x443c01c0)
#define IOMUXC_PAD_GPIO_IO00_MEDIAMIX_CAM_CLK                    IOMUX_PADCFG(0x443c0010, 0x2, 0x00000000, 0x00000000, 0x443c01c0)
#define IOMUXC_PAD_GPIO_IO00_MEDIAMIX_DISP_CLK                   IOMUX_PADCFG(0x443c0010, 0x3, 0x00000000, 0x00000000, 0x443c01c0)
#define IOMUXC_PAD_GPIO_IO00_LPSPI6_PCS0                         IOMUX_PADCFG(0x443c0010, 0x4, 0x00000000, 0x00000000, 0x443c01c0)
#define IOMUXC_PAD_GPIO_IO00_LPUART5_TX                          IOMUX_PADCFG(0x443c0010, 0x5, 0x443c0434, 0x00000001, 0x443c01c0)
#define IOMUXC_PAD_GPIO_IO00_LPI2C5_SDA                          IOMUX_PADCFG(0x443c0010, 0x6, 0x443c03ec, 0x00000000, 0x443c01c0)
#define IOMUXC_PAD_GPIO_IO00_FLEXIO1_FLEXIO00                    IOMUX_PADCFG(0x443c0010, 0x7, 0x443c036c, 0x00000000, 0x443c01c0)
#define IOMUXC_PAD_GPIO_IO01_GPIO2_IO01                          IOMUX_PADCFG(0x443c0014, 0x0, 0x00000000, 0x00000000, 0x443c01c4)
#define IOMUXC_PAD_GPIO_IO01_LPI2C3_SCL                          IOMUX_PADCFG(0x443c0014, 0x1, 0x443c03e0, 0x00000000, 0x443c01c4)
#define IOMUXC_PAD_GPIO_IO01_MEDIAMIX_CAM_DATA00                 IOMUX_PADCFG(0x443c0014, 0x2, 0x00000000, 0x00000000, 0x443c01c4)
#define IOMUXC_PAD_GPIO_IO01_MEDIAMIX_DISP_DE                    IOMUX_PADCFG(0x443c0014, 0x3, 0x00000000, 0x00000000, 0x443c01c4)
#define IOMUXC_PAD_GPIO_IO01_LPSPI6_SIN                          IOMUX_PADCFG(0x443c0014, 0x4, 0x00000000, 0x00000000, 0x443c01c4)
#define IOMUXC_PAD_GPIO_IO01_LPUART5_RX                          IOMUX_PADCFG(0x443c0014, 0x5, 0x443c0430, 0x00000001, 0x443c01c4)
#define IOMUXC_PAD_GPIO_IO01_LPI2C5_SCL                          IOMUX_PADCFG(0x443c0014, 0x6, 0x443c03e8, 0x00000000, 0x443c01c4)
#define IOMUXC_PAD_GPIO_IO01_FLEXIO1_FLEXIO01                    IOMUX_PADCFG(0x443c0014, 0x7, 0x443c0370, 0x00000000, 0x443c01c4)
#define IOMUXC_PAD_GPIO_IO02_GPIO2_IO02                          IOMUX_PADCFG(0x443c0018, 0x0, 0x00000000, 0x00000000, 0x443c01c8)
#define IOMUXC_PAD_GPIO_IO02_LPI2C4_SDA                          IOMUX_PADCFG(0x443c0018, 0x1, 0x00000000, 0x00000000, 0x443c01c8)
#define IOMUXC_PAD_GPIO_IO02_MEDIAMIX_CAM_VSYNC                  IOMUX_PADCFG(0x443c0018, 0x2, 0x00000000, 0x00000000, 0x443c01c8)
#define IOMUXC_PAD_GPIO_IO02_MEDIAMIX_DISP_VSYNC                 IOMUX_PADCFG(0x443c0018, 0x3, 0x00000000, 0x00000000, 0x443c01c8)
#define IOMUXC_PAD_GPIO_IO02_LPSPI6_SOUT                         IOMUX_PADCFG(0x443c0018, 0x4, 0x00000000, 0x00000000, 0x443c01c8)
#define IOMUXC_PAD_GPIO_IO02_LPUART5_CTS_B                       IOMUX_PADCFG(0x443c0018, 0x5, 0x443c042c, 0x00000001, 0x443c01c8)
#define IOMUXC_PAD_GPIO_IO02_LPI2C6_SDA                          IOMUX_PADCFG(0x443c0018, 0x6, 0x443c03f4, 0x00000000, 0x443c01c8)
#define IOMUXC_PAD_GPIO_IO02_FLEXIO1_FLEXIO02                    IOMUX_PADCFG(0x443c0018, 0x7, 0x443c0374, 0x00000000, 0x443c01c8)
#define IOMUXC_PAD_GPIO_IO03_GPIO2_IO03                          IOMUX_PADCFG(0x443c001c, 0x0, 0x00000000, 0x00000000, 0x443c01cc)
#define IOMUXC_PAD_GPIO_IO03_LPI2C4_SCL                          IOMUX_PADCFG(0x443c001c, 0x1, 0x00000000, 0x00000000, 0x443c01cc)
#define IOMUXC_PAD_GPIO_IO03_MEDIAMIX_CAM_HSYNC                  IOMUX_PADCFG(0x443c001c, 0x2, 0x00000000, 0x00000000, 0x443c01cc)
#define IOMUXC_PAD_GPIO_IO03_MEDIAMIX_DISP_HSYNC                 IOMUX_PADCFG(0x443c001c, 0x3, 0x00000000, 0x00000000, 0x443c01cc)
#define IOMUXC_PAD_GPIO_IO03_LPSPI6_SCK                          IOMUX_PADCFG(0x443c001c, 0x4, 0x00000000, 0x00000000, 0x443c01cc)
#define IOMUXC_PAD_GPIO_IO03_LPUART5_RTS_B                       IOMUX_PADCFG(0x443c001c, 0x5, 0x00000000, 0x00000000, 0x443c01cc)
#define IOMUXC_PAD_GPIO_IO03_LPI2C6_SCL                          IOMUX_PADCFG(0x443c001c, 0x6, 0x443c03f0, 0x00000000, 0x443c01cc)
#define IOMUXC_PAD_GPIO_IO03_FLEXIO1_FLEXIO03                    IOMUX_PADCFG(0x443c001c, 0x7, 0x443c0378, 0x00000000, 0x443c01cc)
#define IOMUXC_PAD_GPIO_IO04_GPIO2_IO04                          IOMUX_PADCFG(0x443c0020, 0x0, 0x00000000, 0x00000000, 0x443c01d0)
#define IOMUXC_PAD_GPIO_IO04_TPM3_CH0                            IOMUX_PADCFG(0x443c0020, 0x1, 0x00000000, 0x00000000, 0x443c01d0)
#define IOMUXC_PAD_GPIO_IO04_PDM_CLK                             IOMUX_PADCFG(0x443c0020, 0x2, 0x00000000, 0x00000000, 0x443c01d0)
#define IOMUXC_PAD_GPIO_IO04_MEDIAMIX_DISP_DATA00                IOMUX_PADCFG(0x443c0020, 0x3, 0x00000000, 0x00000000, 0x443c01d0)
#define IOMUXC_PAD_GPIO_IO04_LPSPI7_PCS0                         IOMUX_PADCFG(0x443c0020, 0x4, 0x00000000, 0x00000000, 0x443c01d0)
#define IOMUXC_PAD_GPIO_IO04_LPUART6_TX                          IOMUX_PADCFG(0x443c0020, 0x5, 0x00000000, 0x00000000, 0x443c01d0)
#define IOMUXC_PAD_GPIO_IO04_LPI2C6_SDA                          IOMUX_PADCFG(0x443c0020, 0x6, 0x443c03f4, 0x00000001, 0x443c01d0)
#define IOMUXC_PAD_GPIO_IO04_FLEXIO1_FLEXIO04                    IOMUX_PADCFG(0x443c0020, 0x7, 0x443c037c, 0x00000000, 0x443c01d0)
#define IOMUXC_PAD_GPIO_IO05_GPIO2_IO05                          IOMUX_PADCFG(0x443c0024, 0x0, 0x00000000, 0x00000000, 0x443c01d4)
#define IOMUXC_PAD_GPIO_IO05_TPM4_CH0                            IOMUX_PADCFG(0x443c0024, 0x1, 0x00000000, 0x00000000, 0x443c01d4)
#define IOMUXC_PAD_GPIO_IO05_PDM_BIT_STREAM00                    IOMUX_PADCFG(0x443c0024, 0x2, 0x443c0438, 0x00000000, 0x443c01d4)
#define IOMUXC_PAD_GPIO_IO05_MEDIAMIX_DISP_DATA01                IOMUX_PADCFG(0x443c0024, 0x3, 0x00000000, 0x00000000, 0x443c01d4)
#define IOMUXC_PAD_GPIO_IO05_LPSPI7_SIN                          IOMUX_PADCFG(0x443c0024, 0x4, 0x00000000, 0x00000000, 0x443c01d4)
#define IOMUXC_PAD_GPIO_IO05_LPUART6_RX                          IOMUX_PADCFG(0x443c0024, 0x5, 0x00000000, 0x00000000, 0x443c01d4)
#define IOMUXC_PAD_GPIO_IO05_LPI2C6_SCL                          IOMUX_PADCFG(0x443c0024, 0x6, 0x443c03f0, 0x00000001, 0x443c01d4)
#define IOMUXC_PAD_GPIO_IO05_FLEXIO1_FLEXIO05                    IOMUX_PADCFG(0x443c0024, 0x7, 0x443c0380, 0x00000000, 0x443c01d4)
#define IOMUXC_PAD_GPIO_IO06_GPIO2_IO06                          IOMUX_PADCFG(0x443c0028, 0x0, 0x00000000, 0x00000000, 0x443c01d8)
#define IOMUXC_PAD_GPIO_IO06_TPM5_CH0                            IOMUX_PADCFG(0x443c0028, 0x1, 0x00000000, 0x00000000, 0x443c01d8)
#define IOMUXC_PAD_GPIO_IO06_PDM_BIT_STREAM01                    IOMUX_PADCFG(0x443c0028, 0x2, 0x443c043c, 0x00000000, 0x443c01d8)
#define IOMUXC_PAD_GPIO_IO06_MEDIAMIX_DISP_DATA02                IOMUX_PADCFG(0x443c0028, 0x3, 0x00000000, 0x00000000, 0x443c01d8)
#define IOMUXC_PAD_GPIO_IO06_LPSPI7_SOUT                         IOMUX_PADCFG(0x443c0028, 0x4, 0x00000000, 0x00000000, 0x443c01d8)
#define IOMUXC_PAD_GPIO_IO06_LPUART6_CTS_B                       IOMUX_PADCFG(0x443c0028, 0x5, 0x00000000, 0x00000000, 0x443c01d8)
#define IOMUXC_PAD_GPIO_IO06_LPI2C7_SDA                          IOMUX_PADCFG(0x443c0028, 0x6, 0x443c03fc, 0x00000000, 0x443c01d8)
#define IOMUXC_PAD_GPIO_IO06_FLEXIO1_FLEXIO06                    IOMUX_PADCFG(0x443c0028, 0x7, 0x443c0384, 0x00000000, 0x443c01d8)
#define IOMUXC_PAD_GPIO_IO07_GPIO2_IO07                          IOMUX_PADCFG(0x443c002c, 0x0, 0x00000000, 0x00000000, 0x443c01dc)
#define IOMUXC_PAD_GPIO_IO07_LPSPI3_PCS1                         IOMUX_PADCFG(0x443c002c, 0x1, 0x00000000, 0x00000000, 0x443c01dc)
#define IOMUXC_PAD_GPIO_IO07_MEDIAMIX_CAM_DATA01                 IOMUX_PADCFG(0x443c002c, 0x2, 0x00000000, 0x00000000, 0x443c01dc)
#define IOMUXC_PAD_GPIO_IO07_MEDIAMIX_DISP_DATA03                IOMUX_PADCFG(0x443c002c, 0x3, 0x00000000, 0x00000000, 0x443c01dc)
#define IOMUXC_PAD_GPIO_IO07_LPSPI7_SCK                          IOMUX_PADCFG(0x443c002c, 0x4, 0x00000000, 0x00000000, 0x443c01dc)
#define IOMUXC_PAD_GPIO_IO07_LPUART6_RTS_B                       IOMUX_PADCFG(0x443c002c, 0x5, 0x00000000, 0x00000000, 0x443c01dc)
#define IOMUXC_PAD_GPIO_IO07_LPI2C7_SCL                          IOMUX_PADCFG(0x443c002c, 0x6, 0x443c03f8, 0x00000000, 0x443c01dc)
#define IOMUXC_PAD_GPIO_IO07_FLEXIO1_FLEXIO07                    IOMUX_PADCFG(0x443c002c, 0x7, 0x443c0388, 0x00000000, 0x443c01dc)
#define IOMUXC_PAD_GPIO_IO08_GPIO2_IO08                          IOMUX_PADCFG(0x443c0030, 0x0, 0x00000000, 0x00000000, 0x443c01e0)
#define IOMUXC_PAD_GPIO_IO08_LPSPI3_PCS0                         IOMUX_PADCFG(0x443c0030, 0x1, 0x00000000, 0x00000000, 0x443c01e0)
#define IOMUXC_PAD_GPIO_IO08_MEDIAMIX_CAM_DATA02                 IOMUX_PADCFG(0x443c0030, 0x2, 0x00000000, 0x00000000, 0x443c01e0)
#define IOMUXC_PAD_GPIO_IO08_MEDIAMIX_DISP_DATA04                IOMUX_PADCFG(0x443c0030, 0x3, 0x00000000, 0x00000000, 0x443c01e0)
#define IOMUXC_PAD_GPIO_IO08_TPM6_CH0                            IOMUX_PADCFG(0x443c0030, 0x4, 0x00000000, 0x00000000, 0x443c01e0)
#define IOMUXC_PAD_GPIO_IO08_LPUART7_TX                          IOMUX_PADCFG(0x443c0030, 0x5, 0x00000000, 0x00000000, 0x443c01e0)
#define IOMUXC_PAD_GPIO_IO08_LPI2C7_SDA                          IOMUX_PADCFG(0x443c0030, 0x6, 0x443c03fc, 0x00000001, 0x443c01e0)
#define IOMUXC_PAD_GPIO_IO08_FLEXIO1_FLEXIO08                    IOMUX_PADCFG(0x443c0030, 0x7, 0x443c038c, 0x00000000, 0x443c01e0)
#define IOMUXC_PAD_GPIO_IO09_GPIO2_IO09                          IOMUX_PADCFG(0x443c0034, 0x0, 0x00000000, 0x00000000, 0x443c01e4)
#define IOMUXC_PAD_GPIO_IO09_LPSPI3_SIN                          IOMUX_PADCFG(0x443c0034, 0x1, 0x00000000, 0x00000000, 0x443c01e4)
#define IOMUXC_PAD_GPIO_IO09_MEDIAMIX_CAM_DATA03                 IOMUX_PADCFG(0x443c0034, 0x2, 0x00000000, 0x00000000, 0x443c01e4)
#define IOMUXC_PAD_GPIO_IO09_MEDIAMIX_DISP_DATA05                IOMUX_PADCFG(0x443c0034, 0x3, 0x00000000, 0x00000000, 0x443c01e4)
#define IOMUXC_PAD_GPIO_IO09_TPM3_EXTCLK                         IOMUX_PADCFG(0x443c0034, 0x4, 0x00000000, 0x00000000, 0x443c01e4)
#define IOMUXC_PAD_GPIO_IO09_LPUART7_RX                          IOMUX_PADCFG(0x443c0034, 0x5, 0x00000000, 0x00000000, 0x443c01e4)
#define IOMUXC_PAD_GPIO_IO09_LPI2C7_SCL                          IOMUX_PADCFG(0x443c0034, 0x6, 0x443c03f8, 0x00000001, 0x443c01e4)
#define IOMUXC_PAD_GPIO_IO09_FLEXIO1_FLEXIO09                    IOMUX_PADCFG(0x443c0034, 0x7, 0x443c0390, 0x00000000, 0x443c01e4)
#define IOMUXC_PAD_GPIO_IO10_GPIO2_IO10                          IOMUX_PADCFG(0x443c0038, 0x0, 0x00000000, 0x00000000, 0x443c01e8)
#define IOMUXC_PAD_GPIO_IO10_LPSPI3_SOUT                         IOMUX_PADCFG(0x443c0038, 0x1, 0x00000000, 0x00000000, 0x443c01e8)
#define IOMUXC_PAD_GPIO_IO10_MEDIAMIX_CAM_DATA04                 IOMUX_PADCFG(0x443c0038, 0x2, 0x00000000, 0x00000000, 0x443c01e8)
#define IOMUXC_PAD_GPIO_IO10_MEDIAMIX_DISP_DATA06                IOMUX_PADCFG(0x443c0038, 0x3, 0x00000000, 0x00000000, 0x443c01e8)
#define IOMUXC_PAD_GPIO_IO10_TPM4_EXTCLK                         IOMUX_PADCFG(0x443c0038, 0x4, 0x00000000, 0x00000000, 0x443c01e8)
#define IOMUXC_PAD_GPIO_IO10_LPUART7_CTS_B                       IOMUX_PADCFG(0x443c0038, 0x5, 0x00000000, 0x00000000, 0x443c01e8)
#define IOMUXC_PAD_GPIO_IO10_LPI2C8_SDA                          IOMUX_PADCFG(0x443c0038, 0x6, 0x443c0404, 0x00000000, 0x443c01e8)
#define IOMUXC_PAD_GPIO_IO10_FLEXIO1_FLEXIO10                    IOMUX_PADCFG(0x443c0038, 0x7, 0x443c0394, 0x00000000, 0x443c01e8)
#define IOMUXC_PAD_GPIO_IO11_GPIO2_IO11                          IOMUX_PADCFG(0x443c003c, 0x0, 0x00000000, 0x00000000, 0x443c01ec)
#define IOMUXC_PAD_GPIO_IO11_LPSPI3_SCK                          IOMUX_PADCFG(0x443c003c, 0x1, 0x00000000, 0x00000000, 0x443c01ec)
#define IOMUXC_PAD_GPIO_IO11_MEDIAMIX_CAM_DATA05                 IOMUX_PADCFG(0x443c003c, 0x2, 0x00000000, 0x00000000, 0x443c01ec)
#define IOMUXC_PAD_GPIO_IO11_MEDIAMIX_DISP_DATA07                IOMUX_PADCFG(0x443c003c, 0x3, 0x00000000, 0x00000000, 0x443c01ec)
#define IOMUXC_PAD_GPIO_IO11_TPM5_EXTCLK                         IOMUX_PADCFG(0x443c003c, 0x4, 0x00000000, 0x00000000, 0x443c01ec)
#define IOMUXC_PAD_GPIO_IO11_LPUART7_RTS_B                       IOMUX_PADCFG(0x443c003c, 0x5, 0x00000000, 0x00000000, 0x443c01ec)
#define IOMUXC_PAD_GPIO_IO11_LPI2C8_SCL                          IOMUX_PADCFG(0x443c003c, 0x6, 0x443c0400, 0x00000000, 0x443c01ec)
#define IOMUXC_PAD_GPIO_IO11_FLEXIO1_FLEXIO11                    IOMUX_PADCFG(0x443c003c, 0x7, 0x443c0398, 0x00000000, 0x443c01ec)
#define IOMUXC_PAD_GPIO_IO12_GPIO2_IO12                          IOMUX_PADCFG(0x443c0040, 0x0, 0x00000000, 0x00000000, 0x443c01f0)
#define IOMUXC_PAD_GPIO_IO12_TPM3_CH2                            IOMUX_PADCFG(0x443c0040, 0x1, 0x00000000, 0x00000000, 0x443c01f0)
#define IOMUXC_PAD_GPIO_IO12_PDM_BIT_STREAM02                    IOMUX_PADCFG(0x443c0040, 0x2, 0x443c0440, 0x00000000, 0x443c01f0)
#define IOMUXC_PAD_GPIO_IO12_MEDIAMIX_DISP_DATA08                IOMUX_PADCFG(0x443c0040, 0x3, 0x00000000, 0x00000000, 0x443c01f0)
#define IOMUXC_PAD_GPIO_IO12_LPSPI8_PCS0                         IOMUX_PADCFG(0x443c0040, 0x4, 0x00000000, 0x00000000, 0x443c01f0)
#define IOMUXC_PAD_GPIO_IO12_LPUART8_TX                          IOMUX_PADCFG(0x443c0040, 0x5, 0x00000000, 0x00000000, 0x443c01f0)
#define IOMUXC_PAD_GPIO_IO12_LPI2C8_SDA                          IOMUX_PADCFG(0x443c0040, 0x6, 0x443c0404, 0x00000001, 0x443c01f0)
#define IOMUXC_PAD_GPIO_IO12_SAI3_RX_SYNC                        IOMUX_PADCFG(0x443c0040, 0x7, 0x443c0450, 0x00000000, 0x443c01f0)
#define IOMUXC_PAD_GPIO_IO13_GPIO2_IO13                          IOMUX_PADCFG(0x443c0044, 0x0, 0x00000000, 0x00000000, 0x443c01f4)
#define IOMUXC_PAD_GPIO_IO13_TPM4_CH2                            IOMUX_PADCFG(0x443c0044, 0x1, 0x00000000, 0x00000000, 0x443c01f4)
#define IOMUXC_PAD_GPIO_IO13_PDM_BIT_STREAM03                    IOMUX_PADCFG(0x443c0044, 0x2, 0x443c0444, 0x00000000, 0x443c01f4)
#define IOMUXC_PAD_GPIO_IO13_MEDIAMIX_DISP_DATA09                IOMUX_PADCFG(0x443c0044, 0x3, 0x00000000, 0x00000000, 0x443c01f4)
#define IOMUXC_PAD_GPIO_IO13_LPSPI8_SIN                          IOMUX_PADCFG(0x443c0044, 0x4, 0x00000000, 0x00000000, 0x443c01f4)
#define IOMUXC_PAD_GPIO_IO13_LPUART8_RX                          IOMUX_PADCFG(0x443c0044, 0x5, 0x00000000, 0x00000000, 0x443c01f4)
#define IOMUXC_PAD_GPIO_IO13_LPI2C8_SCL                          IOMUX_PADCFG(0x443c0044, 0x6, 0x443c0400, 0x00000001, 0x443c01f4)
#define IOMUXC_PAD_GPIO_IO13_FLEXIO1_FLEXIO13                    IOMUX_PADCFG(0x443c0044, 0x7, 0x443c039c, 0x00000000, 0x443c01f4)
#define IOMUXC_PAD_GPIO_IO14_GPIO2_IO14                          IOMUX_PADCFG(0x443c0048, 0x0, 0x00000000, 0x00000000, 0x443c01f8)
#define IOMUXC_PAD_GPIO_IO14_LPUART3_TX                          IOMUX_PADCFG(0x443c0048, 0x1, 0x443c041c, 0x00000000, 0x443c01f8)
#define IOMUXC_PAD_GPIO_IO14_MEDIAMIX_CAM_DATA06                 IOMUX_PADCFG(0x443c0048, 0x2, 0x00000000, 0x00000000, 0x443c01f8)
#define IOMUXC_PAD_GPIO_IO14_MEDIAMIX_DISP_DATA10                IOMUX_PADCFG(0x443c0048, 0x3, 0x00000000, 0x00000000, 0x443c01f8)
#define IOMUXC_PAD_GPIO_IO14_LPSPI8_SOUT                         IOMUX_PADCFG(0x443c0048, 0x4, 0x00000000, 0x00000000, 0x443c01f8)
#define IOMUXC_PAD_GPIO_IO14_LPUART8_CTS_B                       IOMUX_PADCFG(0x443c0048, 0x5, 0x00000000, 0x00000000, 0x443c01f8)
#define IOMUXC_PAD_GPIO_IO14_LPUART4_TX                          IOMUX_PADCFG(0x443c0048, 0x6, 0x443c0428, 0x00000000, 0x443c01f8)
#define IOMUXC_PAD_GPIO_IO14_FLEXIO1_FLEXIO14                    IOMUX_PADCFG(0x443c0048, 0x7, 0x443c03a0, 0x00000000, 0x443c01f8)
#define IOMUXC_PAD_GPIO_IO15_GPIO2_IO15                          IOMUX_PADCFG(0x443c004c, 0x0, 0x00000000, 0x00000000, 0x443c01fc)
#define IOMUXC_PAD_GPIO_IO15_LPUART3_RX                          IOMUX_PADCFG(0x443c004c, 0x1, 0x443c0418, 0x00000000, 0x443c01fc)
#define IOMUXC_PAD_GPIO_IO15_MEDIAMIX_CAM_DATA07                 IOMUX_PADCFG(0x443c004c, 0x2, 0x00000000, 0x00000000, 0x443c01fc)
#define IOMUXC_PAD_GPIO_IO15_MEDIAMIX_DISP_DATA11                IOMUX_PADCFG(0x443c004c, 0x3, 0x00000000, 0x00000000, 0x443c01fc)
#define IOMUXC_PAD_GPIO_IO15_LPSPI8_SCK                          IOMUX_PADCFG(0x443c004c, 0x4, 0x00000000, 0x00000000, 0x443c01fc)
#define IOMUXC_PAD_GPIO_IO15_LPUART8_RTS_B                       IOMUX_PADCFG(0x443c004c, 0x5, 0x00000000, 0x00000000, 0x443c01fc)
#define IOMUXC_PAD_GPIO_IO15_LPUART4_RX                          IOMUX_PADCFG(0x443c004c, 0x6, 0x443c0424, 0x00000000, 0x443c01fc)
#define IOMUXC_PAD_GPIO_IO15_FLEXIO1_FLEXIO15                    IOMUX_PADCFG(0x443c004c, 0x7, 0x443c03a4, 0x00000000, 0x443c01fc)
#define IOMUXC_PAD_GPIO_IO16_GPIO2_IO16                          IOMUX_PADCFG(0x443c0050, 0x0, 0x00000000, 0x00000000, 0x443c0200)
#define IOMUXC_PAD_GPIO_IO16_SAI3_TX_BCLK                        IOMUX_PADCFG(0x443c0050, 0x1, 0x00000000, 0x00000000, 0x443c0200)
#define IOMUXC_PAD_GPIO_IO16_PDM_BIT_STREAM02                    IOMUX_PADCFG(0x443c0050, 0x2, 0x443c0440, 0x00000001, 0x443c0200)
#define IOMUXC_PAD_GPIO_IO16_MEDIAMIX_DISP_DATA12                IOMUX_PADCFG(0x443c0050, 0x3, 0x00000000, 0x00000000, 0x443c0200)
#define IOMUXC_PAD_GPIO_IO16_LPUART3_CTS_B                       IOMUX_PADCFG(0x443c0050, 0x4, 0x443c0414, 0x00000000, 0x443c0200)
#define IOMUXC_PAD_GPIO_IO16_LPSPI4_PCS2                         IOMUX_PADCFG(0x443c0050, 0x5, 0x00000000, 0x00000000, 0x443c0200)
#define IOMUXC_PAD_GPIO_IO16_LPUART4_CTS_B                       IOMUX_PADCFG(0x443c0050, 0x6, 0x443c0420, 0x00000000, 0x443c0200)
#define IOMUXC_PAD_GPIO_IO16_FLEXIO1_FLEXIO16                    IOMUX_PADCFG(0x443c0050, 0x7, 0x443c03a8, 0x00000000, 0x443c0200)
#define IOMUXC_PAD_GPIO_IO17_GPIO2_IO17                          IOMUX_PADCFG(0x443c0054, 0x0, 0x00000000, 0x00000000, 0x443c0204)
#define IOMUXC_PAD_GPIO_IO17_SAI3_MCLK                           IOMUX_PADCFG(0x443c0054, 0x1, 0x00000000, 0x00000000, 0x443c0204)
#define IOMUXC_PAD_GPIO_IO17_MEDIAMIX_CAM_DATA08                 IOMUX_PADCFG(0x443c0054, 0x2, 0x00000000, 0x00000000, 0x443c0204)
#define IOMUXC_PAD_GPIO_IO17_MEDIAMIX_DISP_DATA13                IOMUX_PADCFG(0x443c0054, 0x3, 0x00000000, 0x00000000, 0x443c0204)
#define IOMUXC_PAD_GPIO_IO17_LPUART3_RTS_B                       IOMUX_PADCFG(0x443c0054, 0x4, 0x00000000, 0x00000000, 0x443c0204)
#define IOMUXC_PAD_GPIO_IO17_LPSPI4_PCS1                         IOMUX_PADCFG(0x443c0054, 0x5, 0x00000000, 0x00000000, 0x443c0204)
#define IOMUXC_PAD_GPIO_IO17_LPUART4_RTS_B                       IOMUX_PADCFG(0x443c0054, 0x6, 0x00000000, 0x00000000, 0x443c0204)
#define IOMUXC_PAD_GPIO_IO17_FLEXIO1_FLEXIO17                    IOMUX_PADCFG(0x443c0054, 0x7, 0x443c03ac, 0x00000000, 0x443c0204)
#define IOMUXC_PAD_GPIO_IO18_GPIO2_IO18                          IOMUX_PADCFG(0x443c0058, 0x0, 0x00000000, 0x00000000, 0x443c0208)
#define IOMUXC_PAD_GPIO_IO18_SAI3_RX_BCLK                        IOMUX_PADCFG(0x443c0058, 0x1, 0x443c044c, 0x00000000, 0x443c0208)
#define IOMUXC_PAD_GPIO_IO18_MEDIAMIX_CAM_DATA09                 IOMUX_PADCFG(0x443c0058, 0x2, 0x00000000, 0x00000000, 0x443c0208)
#define IOMUXC_PAD_GPIO_IO18_MEDIAMIX_DISP_DATA14                IOMUX_PADCFG(0x443c0058, 0x3, 0x00000000, 0x00000000, 0x443c0208)
#define IOMUXC_PAD_GPIO_IO18_LPSPI5_PCS0                         IOMUX_PADCFG(0x443c0058, 0x4, 0x00000000, 0x00000000, 0x443c0208)
#define IOMUXC_PAD_GPIO_IO18_LPSPI4_PCS0                         IOMUX_PADCFG(0x443c0058, 0x5, 0x00000000, 0x00000000, 0x443c0208)
#define IOMUXC_PAD_GPIO_IO18_TPM5_CH2                            IOMUX_PADCFG(0x443c0058, 0x6, 0x00000000, 0x00000000, 0x443c0208)
#define IOMUXC_PAD_GPIO_IO18_FLEXIO1_FLEXIO18                    IOMUX_PADCFG(0x443c0058, 0x7, 0x443c03b0, 0x00000000, 0x443c0208)
#define IOMUXC_PAD_GPIO_IO19_GPIO2_IO19                          IOMUX_PADCFG(0x443c005c, 0x0, 0x00000000, 0x00000000, 0x443c020c)
#define IOMUXC_PAD_GPIO_IO19_SAI3_RX_SYNC                        IOMUX_PADCFG(0x443c005c, 0x1, 0x443c0450, 0x00000001, 0x443c020c)
#define IOMUXC_PAD_GPIO_IO19_PDM_BIT_STREAM03                    IOMUX_PADCFG(0x443c005c, 0x2, 0x443c0444, 0x00000001, 0x443c020c)
#define IOMUXC_PAD_GPIO_IO19_MEDIAMIX_DISP_DATA15                IOMUX_PADCFG(0x443c005c, 0x3, 0x00000000, 0x00000000, 0x443c020c)
#define IOMUXC_PAD_GPIO_IO19_LPSPI5_SIN                          IOMUX_PADCFG(0x443c005c, 0x4, 0x00000000, 0x00000000, 0x443c020c)
#define IOMUXC_PAD_GPIO_IO19_LPSPI4_SIN                          IOMUX_PADCFG(0x443c005c, 0x5, 0x00000000, 0x00000000, 0x443c020c)
#define IOMUXC_PAD_GPIO_IO19_TPM6_CH2                            IOMUX_PADCFG(0x443c005c, 0x6, 0x00000000, 0x00000000, 0x443c020c)
#define IOMUXC_PAD_GPIO_IO19_SAI3_TX_DATA00                      IOMUX_PADCFG(0x443c005c, 0x7, 0x00000000, 0x00000000, 0x443c020c)
#define IOMUXC_PAD_GPIO_IO20_GPIO2_IO20                          IOMUX_PADCFG(0x443c0060, 0x0, 0x00000000, 0x00000000, 0x443c0210)
#define IOMUXC_PAD_GPIO_IO20_SAI3_RX_DATA00                      IOMUX_PADCFG(0x443c0060, 0x1, 0x00000000, 0x00000000, 0x443c0210)
#define IOMUXC_PAD_GPIO_IO20_PDM_BIT_STREAM00                    IOMUX_PADCFG(0x443c0060, 0x2, 0x443c0438, 0x00000001, 0x443c0210)
#define IOMUXC_PAD_GPIO_IO20_MEDIAMIX_DISP_DATA16                IOMUX_PADCFG(0x443c0060, 0x3, 0x00000000, 0x00000000, 0x443c0210)
#define IOMUXC_PAD_GPIO_IO20_LPSPI5_SOUT                         IOMUX_PADCFG(0x443c0060, 0x4, 0x00000000, 0x00000000, 0x443c0210)
#define IOMUXC_PAD_GPIO_IO20_LPSPI4_SOUT                         IOMUX_PADCFG(0x443c0060, 0x5, 0x00000000, 0x00000000, 0x443c0210)
#define IOMUXC_PAD_GPIO_IO20_TPM3_CH1                            IOMUX_PADCFG(0x443c0060, 0x6, 0x00000000, 0x00000000, 0x443c0210)
#define IOMUXC_PAD_GPIO_IO20_FLEXIO1_FLEXIO20                    IOMUX_PADCFG(0x443c0060, 0x7, 0x443c03b4, 0x00000000, 0x443c0210)
#define IOMUXC_PAD_GPIO_IO21_GPIO2_IO21                          IOMUX_PADCFG(0x443c0064, 0x0, 0x00000000, 0x00000000, 0x443c0214)
#define IOMUXC_PAD_GPIO_IO21_SAI3_TX_DATA00                      IOMUX_PADCFG(0x443c0064, 0x1, 0x00000000, 0x00000000, 0x443c0214)
#define IOMUXC_PAD_GPIO_IO21_PDM_CLK                             IOMUX_PADCFG(0x443c0064, 0x2, 0x00000000, 0x00000000, 0x443c0214)
#define IOMUXC_PAD_GPIO_IO21_MEDIAMIX_DISP_DATA17                IOMUX_PADCFG(0x443c0064, 0x3, 0x00000000, 0x00000000, 0x443c0214)
#define IOMUXC_PAD_GPIO_IO21_LPSPI5_SCK                          IOMUX_PADCFG(0x443c0064, 0x4, 0x00000000, 0x00000000, 0x443c0214)
#define IOMUXC_PAD_GPIO_IO21_LPSPI4_SCK                          IOMUX_PADCFG(0x443c0064, 0x5, 0x00000000, 0x00000000, 0x443c0214)
#define IOMUXC_PAD_GPIO_IO21_TPM4_CH1                            IOMUX_PADCFG(0x443c0064, 0x6, 0x00000000, 0x00000000, 0x443c0214)
#define IOMUXC_PAD_GPIO_IO21_SAI3_RX_BCLK                        IOMUX_PADCFG(0x443c0064, 0x7, 0x443c044c, 0x00000001, 0x443c0214)
#define IOMUXC_PAD_GPIO_IO22_GPIO2_IO22                          IOMUX_PADCFG(0x443c0068, 0x0, 0x00000000, 0x00000000, 0x443c0218)
#define IOMUXC_PAD_GPIO_IO22_USDHC3_CLK                          IOMUX_PADCFG(0x443c0068, 0x1, 0x443c0458, 0x00000000, 0x443c0218)
#define IOMUXC_PAD_GPIO_IO22_SPDIF_IN                            IOMUX_PADCFG(0x443c0068, 0x2, 0x443c0454, 0x00000000, 0x443c0218)
#define IOMUXC_PAD_GPIO_IO22_MEDIAMIX_DISP_DATA18                IOMUX_PADCFG(0x443c0068, 0x3, 0x00000000, 0x00000000, 0x443c0218)
#define IOMUXC_PAD_GPIO_IO22_TPM5_CH1                            IOMUX_PADCFG(0x443c0068, 0x4, 0x00000000, 0x00000000, 0x443c0218)
#define IOMUXC_PAD_GPIO_IO22_TPM6_EXTCLK                         IOMUX_PADCFG(0x443c0068, 0x5, 0x00000000, 0x00000000, 0x443c0218)
#define IOMUXC_PAD_GPIO_IO22_LPI2C5_SDA                          IOMUX_PADCFG(0x443c0068, 0x6, 0x443c03ec, 0x00000001, 0x443c0218)
#define IOMUXC_PAD_GPIO_IO22_FLEXIO1_FLEXIO22                    IOMUX_PADCFG(0x443c0068, 0x7, 0x443c03b8, 0x00000000, 0x443c0218)
#define IOMUXC_PAD_GPIO_IO23_GPIO2_IO23                          IOMUX_PADCFG(0x443c006c, 0x0, 0x00000000, 0x00000000, 0x443c021c)
#define IOMUXC_PAD_GPIO_IO23_USDHC3_CMD                          IOMUX_PADCFG(0x443c006c, 0x1, 0x443c045c, 0x00000000, 0x443c021c)
#define IOMUXC_PAD_GPIO_IO23_SPDIF_OUT                           IOMUX_PADCFG(0x443c006c, 0x2, 0x00000000, 0x00000000, 0x443c021c)
#define IOMUXC_PAD_GPIO_IO23_MEDIAMIX_DISP_DATA19                IOMUX_PADCFG(0x443c006c, 0x3, 0x00000000, 0x00000000, 0x443c021c)
#define IOMUXC_PAD_GPIO_IO23_TPM6_CH1                            IOMUX_PADCFG(0x443c006c, 0x4, 0x00000000, 0x00000000, 0x443c021c)
#define IOMUXC_PAD_GPIO_IO23_LPI2C5_SCL                          IOMUX_PADCFG(0x443c006c, 0x6, 0x443c03e8, 0x00000001, 0x443c021c)
#define IOMUXC_PAD_GPIO_IO23_FLEXIO1_FLEXIO23                    IOMUX_PADCFG(0x443c006c, 0x7, 0x443c03bc, 0x00000000, 0x443c021c)
#define IOMUXC_PAD_GPIO_IO24_GPIO2_IO24                          IOMUX_PADCFG(0x443c0070, 0x0, 0x00000000, 0x00000000, 0x443c0220)
#define IOMUXC_PAD_GPIO_IO24_USDHC3_DATA0                        IOMUX_PADCFG(0x443c0070, 0x1, 0x443c0460, 0x00000000, 0x443c0220)
#define IOMUXC_PAD_GPIO_IO24_MEDIAMIX_DISP_DATA20                IOMUX_PADCFG(0x443c0070, 0x3, 0x00000000, 0x00000000, 0x443c0220)
#define IOMUXC_PAD_GPIO_IO24_TPM3_CH3                            IOMUX_PADCFG(0x443c0070, 0x4, 0x00000000, 0x00000000, 0x443c0220)
#define IOMUXC_PAD_GPIO_IO24_JTAG_MUX_TDO                        IOMUX_PADCFG(0x443c0070, 0x5, 0x00000000, 0x00000000, 0x443c0220)
#define IOMUXC_PAD_GPIO_IO24_LPSPI6_PCS1                         IOMUX_PADCFG(0x443c0070, 0x6, 0x00000000, 0x00000000, 0x443c0220)
#define IOMUXC_PAD_GPIO_IO24_FLEXIO1_FLEXIO24                    IOMUX_PADCFG(0x443c0070, 0x7, 0x443c03c0, 0x00000000, 0x443c0220)
#define IOMUXC_PAD_GPIO_IO25_GPIO2_IO25                          IOMUX_PADCFG(0x443c0074, 0x0, 0x00000000, 0x00000000, 0x443c0224)
#define IOMUXC_PAD_GPIO_IO25_USDHC3_DATA1                        IOMUX_PADCFG(0x443c0074, 0x1, 0x443c0464, 0x00000000, 0x443c0224)
#define IOMUXC_PAD_GPIO_IO25_CAN2_TX                             IOMUX_PADCFG(0x443c0074, 0x2, 0x00000000, 0x00000000, 0x443c0224)
#define IOMUXC_PAD_GPIO_IO25_MEDIAMIX_DISP_DATA21                IOMUX_PADCFG(0x443c0074, 0x3, 0x00000000, 0x00000000, 0x443c0224)
#define IOMUXC_PAD_GPIO_IO25_TPM4_CH3                            IOMUX_PADCFG(0x443c0074, 0x4, 0x00000000, 0x00000000, 0x443c0224)
#define IOMUXC_PAD_GPIO_IO25_JTAG_MUX_TCK                        IOMUX_PADCFG(0x443c0074, 0x5, 0x443c03d4, 0x00000001, 0x443c0224)
#define IOMUXC_PAD_GPIO_IO25_LPSPI7_PCS1                         IOMUX_PADCFG(0x443c0074, 0x6, 0x00000000, 0x00000000, 0x443c0224)
#define IOMUXC_PAD_GPIO_IO25_FLEXIO1_FLEXIO25                    IOMUX_PADCFG(0x443c0074, 0x7, 0x443c03c4, 0x00000000, 0x443c0224)
#define IOMUXC_PAD_GPIO_IO26_GPIO2_IO26                          IOMUX_PADCFG(0x443c0078, 0x0, 0x00000000, 0x00000000, 0x443c0228)
#define IOMUXC_PAD_GPIO_IO26_USDHC3_DATA2                        IOMUX_PADCFG(0x443c0078, 0x1, 0x443c0468, 0x00000000, 0x443c0228)
#define IOMUXC_PAD_GPIO_IO26_PDM_BIT_STREAM01                    IOMUX_PADCFG(0x443c0078, 0x2, 0x443c043c, 0x00000001, 0x443c0228)
#define IOMUXC_PAD_GPIO_IO26_MEDIAMIX_DISP_DATA22                IOMUX_PADCFG(0x443c0078, 0x3, 0x00000000, 0x00000000, 0x443c0228)
#define IOMUXC_PAD_GPIO_IO26_TPM5_CH3                            IOMUX_PADCFG(0x443c0078, 0x4, 0x00000000, 0x00000000, 0x443c0228)
#define IOMUXC_PAD_GPIO_IO26_JTAG_MUX_TDI                        IOMUX_PADCFG(0x443c0078, 0x5, 0x443c03d8, 0x00000001, 0x443c0228)
#define IOMUXC_PAD_GPIO_IO26_LPSPI8_PCS1                         IOMUX_PADCFG(0x443c0078, 0x6, 0x00000000, 0x00000000, 0x443c0228)
#define IOMUXC_PAD_GPIO_IO26_SAI3_TX_SYNC                        IOMUX_PADCFG(0x443c0078, 0x7, 0x00000000, 0x00000000, 0x443c0228)
#define IOMUXC_PAD_GPIO_IO27_GPIO2_IO27                          IOMUX_PADCFG(0x443c007c, 0x0, 0x00000000, 0x00000000, 0x443c022c)
#define IOMUXC_PAD_GPIO_IO27_USDHC3_DATA3                        IOMUX_PADCFG(0x443c007c, 0x1, 0x443c046c, 0x00000000, 0x443c022c)
#define IOMUXC_PAD_GPIO_IO27_CAN2_RX                             IOMUX_PADCFG(0x443c007c, 0x2, 0x443c0364, 0x00000001, 0x443c022c)
#define IOMUXC_PAD_GPIO_IO27_MEDIAMIX_DISP_DATA23                IOMUX_PADCFG(0x443c007c, 0x3, 0x00000000, 0x00000000, 0x443c022c)
#define IOMUXC_PAD_GPIO_IO27_TPM6_CH3                            IOMUX_PADCFG(0x443c007c, 0x4, 0x00000000, 0x00000000, 0x443c022c)
#define IOMUXC_PAD_GPIO_IO27_JTAG_MUX_TMS                        IOMUX_PADCFG(0x443c007c, 0x5, 0x443c03dc, 0x00000001, 0x443c022c)
#define IOMUXC_PAD_GPIO_IO27_LPSPI5_PCS1                         IOMUX_PADCFG(0x443c007c, 0x6, 0x00000000, 0x00000000, 0x443c022c)
#define IOMUXC_PAD_GPIO_IO27_FLEXIO1_FLEXIO27                    IOMUX_PADCFG(0x443c007c, 0x7, 0x443c03c8, 0x00000000, 0x443c022c)
#define IOMUXC_PAD_GPIO_IO28_GPIO2_IO28                          IOMUX_PADCFG(0x443c0080, 0x0, 0x00000000, 0x00000000, 0x443c0230)
#define IOMUXC_PAD_GPIO_IO28_LPI2C3_SDA                          IOMUX_PADCFG(0x443c0080, 0x1, 0x443c03e4, 0x00000001, 0x443c0230)
#define IOMUXC_PAD_GPIO_IO28_FLEXIO1_FLEXIO28                    IOMUX_PADCFG(0x443c0080, 0x7, 0x00000000, 0x00000000, 0x443c0230)
#define IOMUXC_PAD_GPIO_IO29_GPIO2_IO29                          IOMUX_PADCFG(0x443c0084, 0x0, 0x00000000, 0x00000000, 0x443c0234)
#define IOMUXC_PAD_GPIO_IO29_LPI2C3_SCL                          IOMUX_PADCFG(0x443c0084, 0x1, 0x443c03e0, 0x00000001, 0x443c0234)
#define IOMUXC_PAD_GPIO_IO29_FLEXIO1_FLEXIO29                    IOMUX_PADCFG(0x443c0084, 0x7, 0x00000000, 0x00000000, 0x443c0234)
#define IOMUXC_PAD_CCM_CLKO1_CCMSRCGPCMIX_CLKO1                  IOMUX_PADCFG(0x443c0088, 0x0, 0x00000000, 0x00000000, 0x443c0238)
#define IOMUXC_PAD_CCM_CLKO1_FLEXIO1_FLEXIO26                    IOMUX_PADCFG(0x443c0088, 0x4, 0x00000000, 0x00000000, 0x443c0238)
#define IOMUXC_PAD_CCM_CLKO1_GPIO3_IO26                          IOMUX_PADCFG(0x443c0088, 0x5, 0x00000000, 0x00000000, 0x443c0238)
#define IOMUXC_PAD_CCM_CLKO2_GPIO3_IO27                          IOMUX_PADCFG(0x443c008c, 0x5, 0x00000000, 0x00000000, 0x443c023c)
#define IOMUXC_PAD_CCM_CLKO2_CCMSRCGPCMIX_CLKO2                  IOMUX_PADCFG(0x443c008c, 0x0, 0x00000000, 0x00000000, 0x443c023c)
#define IOMUXC_PAD_CCM_CLKO2_FLEXIO1_FLEXIO27                    IOMUX_PADCFG(0x443c008c, 0x4, 0x443c03c8, 0x00000001, 0x443c023c)
#define IOMUXC_PAD_CCM_CLKO3_CCMSRCGPCMIX_CLKO3                  IOMUX_PADCFG(0x443c0090, 0x0, 0x00000000, 0x00000000, 0x443c0240)
#define IOMUXC_PAD_CCM_CLKO3_FLEXIO2_FLEXIO28                    IOMUX_PADCFG(0x443c0090, 0x4, 0x00000000, 0x00000000, 0x443c0240)
#define IOMUXC_PAD_CCM_CLKO3_GPIO4_IO28                          IOMUX_PADCFG(0x443c0090, 0x5, 0x00000000, 0x00000000, 0x443c0240)
#define IOMUXC_PAD_CCM_CLKO4_CCMSRCGPCMIX_CLKO4                  IOMUX_PADCFG(0x443c0094, 0x0, 0x00000000, 0x00000000, 0x443c0244)
#define IOMUXC_PAD_CCM_CLKO4_FLEXIO2_FLEXIO29                    IOMUX_PADCFG(0x443c0094, 0x4, 0x00000000, 0x00000000, 0x443c0244)
#define IOMUXC_PAD_CCM_CLKO4_GPIO4_IO29                          IOMUX_PADCFG(0x443c0094, 0x5, 0x00000000, 0x00000000, 0x443c0244)
#define IOMUXC_PAD_ENET1_MDC_ENET_QOS_MDC                        IOMUX_PADCFG(0x443c0098, 0x0, 0x00000000, 0x00000000, 0x443c0248)
#define IOMUXC_PAD_ENET1_MDC_LPUART3_DCB_B                       IOMUX_PADCFG(0x443c0098, 0x1, 0x00000000, 0x00000000, 0x443c0248)
#define IOMUXC_PAD_ENET1_MDC_I3C2_SCL                            IOMUX_PADCFG(0x443c0098, 0x2, 0x443c03cc, 0x00000000, 0x443c0248)
#define IOMUXC_PAD_ENET1_MDC_HSIOMIX_OTG_ID1                     IOMUX_PADCFG(0x443c0098, 0x3, 0x00000000, 0x00000000, 0x443c0248)
#define IOMUXC_PAD_ENET1_MDC_FLEXIO2_FLEXIO00                    IOMUX_PADCFG(0x443c0098, 0x4, 0x00000000, 0x00000000, 0x443c0248)
#define IOMUXC_PAD_ENET1_MDC_GPIO4_IO00                          IOMUX_PADCFG(0x443c0098, 0x5, 0x00000000, 0x00000000, 0x443c0248)
#define IOMUXC_PAD_ENET1_MDIO_ENET_QOS_MDIO                      IOMUX_PADCFG(0x443c009c, 0x0, 0x00000000, 0x00000000, 0x443c024c)
#define IOMUXC_PAD_ENET1_MDIO_LPUART3_RIN_B                      IOMUX_PADCFG(0x443c009c, 0x1, 0x00000000, 0x00000000, 0x443c024c)
#define IOMUXC_PAD_ENET1_MDIO_I3C2_SDA                           IOMUX_PADCFG(0x443c009c, 0x2, 0x443c03d0, 0x00000000, 0x443c024c)
#define IOMUXC_PAD_ENET1_MDIO_HSIOMIX_OTG_PWR1                   IOMUX_PADCFG(0x443c009c, 0x3, 0x00000000, 0x00000000, 0x443c024c)
#define IOMUXC_PAD_ENET1_MDIO_FLEXIO2_FLEXIO01                   IOMUX_PADCFG(0x443c009c, 0x4, 0x00000000, 0x00000000, 0x443c024c)
#define IOMUXC_PAD_ENET1_MDIO_GPIO4_IO01                         IOMUX_PADCFG(0x443c009c, 0x5, 0x00000000, 0x00000000, 0x443c024c)
#define IOMUXC_PAD_ENET1_TD3_ENET_QOS_RGMII_TD3                  IOMUX_PADCFG(0x443c00a0, 0x0, 0x00000000, 0x00000000, 0x443c0250)
#define IOMUXC_PAD_ENET1_TD3_CAN2_TX                             IOMUX_PADCFG(0x443c00a0, 0x2, 0x00000000, 0x00000000, 0x443c0250)
#define IOMUXC_PAD_ENET1_TD3_HSIOMIX_OTG_ID2                     IOMUX_PADCFG(0x443c00a0, 0x3, 0x00000000, 0x00000000, 0x443c0250)
#define IOMUXC_PAD_ENET1_TD3_FLEXIO2_FLEXIO02                    IOMUX_PADCFG(0x443c00a0, 0x4, 0x00000000, 0x00000000, 0x443c0250)
#define IOMUXC_PAD_ENET1_TD3_GPIO4_IO02                          IOMUX_PADCFG(0x443c00a0, 0x5, 0x00000000, 0x00000000, 0x443c0250)
#define IOMUXC_PAD_ENET1_TD2_ENET_QOS_RGMII_TD2                  IOMUX_PADCFG(0x443c00a4, 0x0, 0x00000000, 0x00000000, 0x443c0254)
#define IOMUXC_PAD_ENET1_TD2_CCM_ENET_QOS_CLOCK_GENERATE_REF_CLK IOMUX_PADCFG(0x443c00a4, 0x1, 0x00000000, 0x00000000, 0x443c0254)
#define IOMUXC_PAD_ENET1_TD2_CAN2_RX                             IOMUX_PADCFG(0x443c00a4, 0x2, 0x443c0364, 0x00000002, 0x443c0254)
#define IOMUXC_PAD_ENET1_TD2_HSIOMIX_OTG_OC2                     IOMUX_PADCFG(0x443c00a4, 0x3, 0x00000000, 0x00000000, 0x443c0254)
#define IOMUXC_PAD_ENET1_TD2_FLEXIO2_FLEXIO03                    IOMUX_PADCFG(0x443c00a4, 0x4, 0x00000000, 0x00000000, 0x443c0254)
#define IOMUXC_PAD_ENET1_TD2_GPIO4_IO03                          IOMUX_PADCFG(0x443c00a4, 0x5, 0x00000000, 0x00000000, 0x443c0254)
#define IOMUXC_PAD_ENET1_TD1_ENET_QOS_RGMII_TD1                  IOMUX_PADCFG(0x443c00a8, 0x0, 0x00000000, 0x00000000, 0x443c0258)
#define IOMUXC_PAD_ENET1_TD1_LPUART3_RTS_B                       IOMUX_PADCFG(0x443c00a8, 0x1, 0x00000000, 0x00000000, 0x443c0258)
#define IOMUXC_PAD_ENET1_TD1_I3C2_PUR                            IOMUX_PADCFG(0x443c00a8, 0x2, 0x00000000, 0x00000000, 0x443c0258)
#define IOMUXC_PAD_ENET1_TD1_HSIOMIX_OTG_OC1                     IOMUX_PADCFG(0x443c00a8, 0x3, 0x00000000, 0x00000000, 0x443c0258)
#define IOMUXC_PAD_ENET1_TD1_FLEXIO2_FLEXIO04                    IOMUX_PADCFG(0x443c00a8, 0x4, 0x00000000, 0x00000000, 0x443c0258)
#define IOMUXC_PAD_ENET1_TD1_GPIO4_IO04                          IOMUX_PADCFG(0x443c00a8, 0x5, 0x00000000, 0x00000000, 0x443c0258)
#define IOMUXC_PAD_ENET1_TD1_I3C2_PUR_B                          IOMUX_PADCFG(0x443c00a8, 0x6, 0x00000000, 0x00000000, 0x443c0258)
#define IOMUXC_PAD_ENET1_TD0_ENET_QOS_RGMII_TD0                  IOMUX_PADCFG(0x443c00ac, 0x0, 0x00000000, 0x00000000, 0x443c025c)
#define IOMUXC_PAD_ENET1_TD0_LPUART3_TX                          IOMUX_PADCFG(0x443c00ac, 0x1, 0x443c041c, 0x00000001, 0x443c025c)
#define IOMUXC_PAD_ENET1_TD0_FLEXIO2_FLEXIO05                    IOMUX_PADCFG(0x443c00ac, 0x4, 0x00000000, 0x00000000, 0x443c025c)
#define IOMUXC_PAD_ENET1_TD0_GPIO4_IO05                          IOMUX_PADCFG(0x443c00ac, 0x5, 0x00000000, 0x00000000, 0x443c025c)
#define IOMUXC_PAD_ENET1_TX_CTL_ENET_QOS_RGMII_TX_CTL            IOMUX_PADCFG(0x443c00b0, 0x0, 0x00000000, 0x00000000, 0x443c0260)
#define IOMUXC_PAD_ENET1_TX_CTL_LPUART3_DTR_B                    IOMUX_PADCFG(0x443c00b0, 0x1, 0x00000000, 0x00000000, 0x443c0260)
#define IOMUXC_PAD_ENET1_TX_CTL_FLEXIO2_FLEXIO06                 IOMUX_PADCFG(0x443c00b0, 0x4, 0x00000000, 0x00000000, 0x443c0260)
#define IOMUXC_PAD_ENET1_TX_CTL_GPIO4_IO06                       IOMUX_PADCFG(0x443c00b0, 0x5, 0x00000000, 0x00000000, 0x443c0260)
#define IOMUXC_PAD_ENET1_TXC_CCM_ENET_QOS_CLOCK_GENERATE_TX_CLK  IOMUX_PADCFG(0x443c00b4, 0x0, 0x00000000, 0x00000000, 0x443c0264)
#define IOMUXC_PAD_ENET1_TXC_ENET_QOS_TX_ER                      IOMUX_PADCFG(0x443c00b4, 0x1, 0x00000000, 0x00000000, 0x443c0264)
#define IOMUXC_PAD_ENET1_TXC_FLEXIO2_FLEXIO07                    IOMUX_PADCFG(0x443c00b4, 0x4, 0x00000000, 0x00000000, 0x443c0264)
#define IOMUXC_PAD_ENET1_TXC_GPIO4_IO07                          IOMUX_PADCFG(0x443c00b4, 0x5, 0x00000000, 0x00000000, 0x443c0264)
#define IOMUXC_PAD_ENET1_RX_CTL_ENET_QOS_RGMII_RX_CTL            IOMUX_PADCFG(0x443c00b8, 0x0, 0x00000000, 0x00000000, 0x443c0268)
#define IOMUXC_PAD_ENET1_RX_CTL_LPUART3_DSR_B                    IOMUX_PADCFG(0x443c00b8, 0x1, 0x00000000, 0x00000000, 0x443c0268)
#define IOMUXC_PAD_ENET1_RX_CTL_HSIOMIX_OTG_PWR2                 IOMUX_PADCFG(0x443c00b8, 0x3, 0x00000000, 0x00000000, 0x443c0268)
#define IOMUXC_PAD_ENET1_RX_CTL_FLEXIO2_FLEXIO08                 IOMUX_PADCFG(0x443c00b8, 0x4, 0x00000000, 0x00000000, 0x443c0268)
#define IOMUXC_PAD_ENET1_RX_CTL_GPIO4_IO08                       IOMUX_PADCFG(0x443c00b8, 0x5, 0x00000000, 0x00000000, 0x443c0268)
#define IOMUXC_PAD_ENET1_RXC_CCM_ENET_QOS_CLOCK_GENERATE_RX_CLK  IOMUX_PADCFG(0x443c00bc, 0x0, 0x00000000, 0x00000000, 0x443c026c)
#define IOMUXC_PAD_ENET1_RXC_ENET_QOS_RX_ER                      IOMUX_PADCFG(0x443c00bc, 0x1, 0x00000000, 0x00000000, 0x443c026c)
#define IOMUXC_PAD_ENET1_RXC_FLEXIO2_FLEXIO09                    IOMUX_PADCFG(0x443c00bc, 0x4, 0x00000000, 0x00000000, 0x443c026c)
#define IOMUXC_PAD_ENET1_RXC_GPIO4_IO09                          IOMUX_PADCFG(0x443c00bc, 0x5, 0x00000000, 0x00000000, 0x443c026c)
#define IOMUXC_PAD_ENET1_RD0_ENET_QOS_RGMII_RD0                  IOMUX_PADCFG(0x443c00c0, 0x0, 0x00000000, 0x00000000, 0x443c0270)
#define IOMUXC_PAD_ENET1_RD0_LPUART3_RX                          IOMUX_PADCFG(0x443c00c0, 0x1, 0x443c0418, 0x00000001, 0x443c0270)
#define IOMUXC_PAD_ENET1_RD0_FLEXIO2_FLEXIO10                    IOMUX_PADCFG(0x443c00c0, 0x4, 0x00000000, 0x00000000, 0x443c0270)
#define IOMUXC_PAD_ENET1_RD0_GPIO4_IO10                          IOMUX_PADCFG(0x443c00c0, 0x5, 0x00000000, 0x00000000, 0x443c0270)
#define IOMUXC_PAD_ENET1_RD1_ENET_QOS_RGMII_RD1                  IOMUX_PADCFG(0x443c00c4, 0x0, 0x00000000, 0x00000000, 0x443c0274)
#define IOMUXC_PAD_ENET1_RD1_LPUART3_CTS_B                       IOMUX_PADCFG(0x443c00c4, 0x1, 0x443c0414, 0x00000001, 0x443c0274)
#define IOMUXC_PAD_ENET1_RD1_LPTMR2_ALT1                         IOMUX_PADCFG(0x443c00c4, 0x3, 0x443c0408, 0x00000000, 0x443c0274)
#define IOMUXC_PAD_ENET1_RD1_FLEXIO2_FLEXIO11                    IOMUX_PADCFG(0x443c00c4, 0x4, 0x00000000, 0x00000000, 0x443c0274)
#define IOMUXC_PAD_ENET1_RD1_GPIO4_IO11                          IOMUX_PADCFG(0x443c00c4, 0x5, 0x00000000, 0x00000000, 0x443c0274)
#define IOMUXC_PAD_ENET1_RD2_ENET_QOS_RGMII_RD2                  IOMUX_PADCFG(0x443c00c8, 0x0, 0x00000000, 0x00000000, 0x443c0278)
#define IOMUXC_PAD_ENET1_RD2_LPTMR2_ALT2                         IOMUX_PADCFG(0x443c00c8, 0x3, 0x443c040c, 0x00000000, 0x443c0278)
#define IOMUXC_PAD_ENET1_RD2_FLEXIO2_FLEXIO12                    IOMUX_PADCFG(0x443c00c8, 0x4, 0x00000000, 0x00000000, 0x443c0278)
#define IOMUXC_PAD_ENET1_RD2_GPIO4_IO12                          IOMUX_PADCFG(0x443c00c8, 0x5, 0x00000000, 0x00000000, 0x443c0278)
#define IOMUXC_PAD_ENET1_RD3_ENET_QOS_RGMII_RD3                  IOMUX_PADCFG(0x443c00cc, 0x0, 0x00000000, 0x00000000, 0x443c027c)
#define IOMUXC_PAD_ENET1_RD3_FLEXSPI1_TESTER_TRIGGER             IOMUX_PADCFG(0x443c00cc, 0x2, 0x00000000, 0x00000000, 0x443c027c)
#define IOMUXC_PAD_ENET1_RD3_LPTMR2_ALT3                         IOMUX_PADCFG(0x443c00cc, 0x3, 0x443c0410, 0x00000000, 0x443c027c)
#define IOMUXC_PAD_ENET1_RD3_FLEXIO2_FLEXIO13                    IOMUX_PADCFG(0x443c00cc, 0x4, 0x00000000, 0x00000000, 0x443c027c)
#define IOMUXC_PAD_ENET1_RD3_GPIO4_IO13                          IOMUX_PADCFG(0x443c00cc, 0x5, 0x00000000, 0x00000000, 0x443c027c)
#define IOMUXC_PAD_ENET2_MDC_ENET1_MDC                           IOMUX_PADCFG(0x443c00d0, 0x0, 0x00000000, 0x00000000, 0x443c0280)
#define IOMUXC_PAD_ENET2_MDC_LPUART4_DCB_B                       IOMUX_PADCFG(0x443c00d0, 0x1, 0x00000000, 0x00000000, 0x443c0280)
#define IOMUXC_PAD_ENET2_MDC_SAI2_RX_SYNC                        IOMUX_PADCFG(0x443c00d0, 0x2, 0x00000000, 0x00000000, 0x443c0280)
#define IOMUXC_PAD_ENET2_MDC_FLEXIO2_FLEXIO14                    IOMUX_PADCFG(0x443c00d0, 0x4, 0x00000000, 0x00000000, 0x443c0280)
#define IOMUXC_PAD_ENET2_MDC_GPIO4_IO14                          IOMUX_PADCFG(0x443c00d0, 0x5, 0x00000000, 0x00000000, 0x443c0280)
#define IOMUXC_PAD_ENET2_MDIO_ENET1_MDIO                         IOMUX_PADCFG(0x443c00d4, 0x0, 0x00000000, 0x00000000, 0x443c0284)
#define IOMUXC_PAD_ENET2_MDIO_LPUART4_RIN_B                      IOMUX_PADCFG(0x443c00d4, 0x1, 0x00000000, 0x00000000, 0x443c0284)
#define IOMUXC_PAD_ENET2_MDIO_SAI2_RX_BCLK                       IOMUX_PADCFG(0x443c00d4, 0x2, 0x00000000, 0x00000000, 0x443c0284)
#define IOMUXC_PAD_ENET2_MDIO_FLEXIO2_FLEXIO15                   IOMUX_PADCFG(0x443c00d4, 0x4, 0x00000000, 0x00000000, 0x443c0284)
#define IOMUXC_PAD_ENET2_MDIO_GPIO4_IO15                         IOMUX_PADCFG(0x443c00d4, 0x5, 0x00000000, 0x00000000, 0x443c0284)
#define IOMUXC_PAD_ENET2_TD3_SAI2_RX_DATA00                      IOMUX_PADCFG(0x443c00d8, 0x2, 0x00000000, 0x00000000, 0x443c0288)
#define IOMUXC_PAD_ENET2_TD3_FLEXIO2_FLEXIO16                    IOMUX_PADCFG(0x443c00d8, 0x4, 0x00000000, 0x00000000, 0x443c0288)
#define IOMUXC_PAD_ENET2_TD3_GPIO4_IO16                          IOMUX_PADCFG(0x443c00d8, 0x5, 0x00000000, 0x00000000, 0x443c0288)
#define IOMUXC_PAD_ENET2_TD3_ENET1_RGMII_TD3                     IOMUX_PADCFG(0x443c00d8, 0x0, 0x00000000, 0x00000000, 0x443c0288)
#define IOMUXC_PAD_ENET2_TD2_ENET1_RGMII_TD2                     IOMUX_PADCFG(0x443c00dc, 0x0, 0x00000000, 0x00000000, 0x443c028c)
#define IOMUXC_PAD_ENET2_TD2_ENET1_TX_CLK                        IOMUX_PADCFG(0x443c00dc, 0x1, 0x00000000, 0x00000000, 0x443c028c)
#define IOMUXC_PAD_ENET2_TD2_SAI2_RX_DATA01                      IOMUX_PADCFG(0x443c00dc, 0x2, 0x00000000, 0x00000000, 0x443c028c)
#define IOMUXC_PAD_ENET2_TD2_FLEXIO2_FLEXIO17                    IOMUX_PADCFG(0x443c00dc, 0x4, 0x00000000, 0x00000000, 0x443c028c)
#define IOMUXC_PAD_ENET2_TD2_GPIO4_IO17                          IOMUX_PADCFG(0x443c00dc, 0x5, 0x00000000, 0x00000000, 0x443c028c)
#define IOMUXC_PAD_ENET2_TD1_ENET1_RGMII_TD1                     IOMUX_PADCFG(0x443c00e0, 0x0, 0x00000000, 0x00000000, 0x443c0290)
#define IOMUXC_PAD_ENET2_TD1_LPUART4_RTS_B                       IOMUX_PADCFG(0x443c00e0, 0x1, 0x00000000, 0x00000000, 0x443c0290)
#define IOMUXC_PAD_ENET2_TD1_SAI2_RX_DATA02                      IOMUX_PADCFG(0x443c00e0, 0x2, 0x00000000, 0x00000000, 0x443c0290)
#define IOMUXC_PAD_ENET2_TD1_FLEXIO2_FLEXIO18                    IOMUX_PADCFG(0x443c00e0, 0x4, 0x00000000, 0x00000000, 0x443c0290)
#define IOMUXC_PAD_ENET2_TD1_GPIO4_IO18                          IOMUX_PADCFG(0x443c00e0, 0x5, 0x00000000, 0x00000000, 0x443c0290)
#define IOMUXC_PAD_ENET2_TD0_ENET1_RGMII_TD0                     IOMUX_PADCFG(0x443c00e4, 0x0, 0x00000000, 0x00000000, 0x443c0294)
#define IOMUXC_PAD_ENET2_TD0_LPUART4_TX                          IOMUX_PADCFG(0x443c00e4, 0x1, 0x443c0428, 0x00000001, 0x443c0294)
#define IOMUXC_PAD_ENET2_TD0_SAI2_RX_DATA03                      IOMUX_PADCFG(0x443c00e4, 0x2, 0x00000000, 0x00000000, 0x443c0294)
#define IOMUXC_PAD_ENET2_TD0_FLEXIO2_FLEXIO19                    IOMUX_PADCFG(0x443c00e4, 0x4, 0x00000000, 0x00000000, 0x443c0294)
#define IOMUXC_PAD_ENET2_TD0_GPIO4_IO19                          IOMUX_PADCFG(0x443c00e4, 0x5, 0x00000000, 0x00000000, 0x443c0294)
#define IOMUXC_PAD_ENET2_TX_CTL_ENET1_RGMII_TX_CTL               IOMUX_PADCFG(0x443c00e8, 0x0, 0x00000000, 0x00000000, 0x443c0298)
#define IOMUXC_PAD_ENET2_TX_CTL_LPUART4_DTR_B                    IOMUX_PADCFG(0x443c00e8, 0x1, 0x00000000, 0x00000000, 0x443c0298)
#define IOMUXC_PAD_ENET2_TX_CTL_SAI2_TX_SYNC                     IOMUX_PADCFG(0x443c00e8, 0x2, 0x00000000, 0x00000000, 0x443c0298)
#define IOMUXC_PAD_ENET2_TX_CTL_FLEXIO2_FLEXIO20                 IOMUX_PADCFG(0x443c00e8, 0x4, 0x00000000, 0x00000000, 0x443c0298)
#define IOMUXC_PAD_ENET2_TX_CTL_GPIO4_IO20                       IOMUX_PADCFG(0x443c00e8, 0x5, 0x00000000, 0x00000000, 0x443c0298)
#define IOMUXC_PAD_ENET2_TXC_ENET1_RGMII_TXC                     IOMUX_PADCFG(0x443c00ec, 0x0, 0x00000000, 0x00000000, 0x443c029c)
#define IOMUXC_PAD_ENET2_TXC_ENET1_TX_ER                         IOMUX_PADCFG(0x443c00ec, 0x1, 0x00000000, 0x00000000, 0x443c029c)
#define IOMUXC_PAD_ENET2_TXC_SAI2_TX_BCLK                        IOMUX_PADCFG(0x443c00ec, 0x2, 0x00000000, 0x00000000, 0x443c029c)
#define IOMUXC_PAD_ENET2_TXC_FLEXIO2_FLEXIO21                    IOMUX_PADCFG(0x443c00ec, 0x4, 0x00000000, 0x00000000, 0x443c029c)
#define IOMUXC_PAD_ENET2_TXC_GPIO4_IO21                          IOMUX_PADCFG(0x443c00ec, 0x5, 0x00000000, 0x00000000, 0x443c029c)
#define IOMUXC_PAD_ENET2_RX_CTL_ENET1_RGMII_RX_CTL               IOMUX_PADCFG(0x443c00f0, 0x0, 0x00000000, 0x00000000, 0x443c02a0)
#define IOMUXC_PAD_ENET2_RX_CTL_LPUART4_DSR_B                    IOMUX_PADCFG(0x443c00f0, 0x1, 0x00000000, 0x00000000, 0x443c02a0)
#define IOMUXC_PAD_ENET2_RX_CTL_SAI2_TX_DATA00                   IOMUX_PADCFG(0x443c00f0, 0x2, 0x00000000, 0x00000000, 0x443c02a0)
#define IOMUXC_PAD_ENET2_RX_CTL_FLEXIO2_FLEXIO22                 IOMUX_PADCFG(0x443c00f0, 0x4, 0x00000000, 0x00000000, 0x443c02a0)
#define IOMUXC_PAD_ENET2_RX_CTL_GPIO4_IO22                       IOMUX_PADCFG(0x443c00f0, 0x5, 0x00000000, 0x00000000, 0x443c02a0)
#define IOMUXC_PAD_ENET2_RXC_ENET1_RGMII_RXC                     IOMUX_PADCFG(0x443c00f4, 0x0, 0x00000000, 0x00000000, 0x443c02a4)
#define IOMUXC_PAD_ENET2_RXC_ENET1_RX_ER                         IOMUX_PADCFG(0x443c00f4, 0x1, 0x00000000, 0x00000000, 0x443c02a4)
#define IOMUXC_PAD_ENET2_RXC_SAI2_TX_DATA01                      IOMUX_PADCFG(0x443c00f4, 0x2, 0x00000000, 0x00000000, 0x443c02a4)
#define IOMUXC_PAD_ENET2_RXC_FLEXIO2_FLEXIO23                    IOMUX_PADCFG(0x443c00f4, 0x4, 0x00000000, 0x00000000, 0x443c02a4)
#define IOMUXC_PAD_ENET2_RXC_GPIO4_IO23                          IOMUX_PADCFG(0x443c00f4, 0x5, 0x00000000, 0x00000000, 0x443c02a4)
#define IOMUXC_PAD_ENET2_RD0_ENET1_RGMII_RD0                     IOMUX_PADCFG(0x443c00f8, 0x0, 0x00000000, 0x00000000, 0x443c02a8)
#define IOMUXC_PAD_ENET2_RD0_LPUART4_RX                          IOMUX_PADCFG(0x443c00f8, 0x1, 0x443c0424, 0x00000001, 0x443c02a8)
#define IOMUXC_PAD_ENET2_RD0_SAI2_TX_DATA02                      IOMUX_PADCFG(0x443c00f8, 0x2, 0x00000000, 0x00000000, 0x443c02a8)
#define IOMUXC_PAD_ENET2_RD0_FLEXIO2_FLEXIO24                    IOMUX_PADCFG(0x443c00f8, 0x4, 0x00000000, 0x00000000, 0x443c02a8)
#define IOMUXC_PAD_ENET2_RD0_GPIO4_IO24                          IOMUX_PADCFG(0x443c00f8, 0x5, 0x00000000, 0x00000000, 0x443c02a8)
#define IOMUXC_PAD_ENET2_RD1_ENET1_RGMII_RD1                     IOMUX_PADCFG(0x443c00fc, 0x0, 0x00000000, 0x00000000, 0x443c02ac)
#define IOMUXC_PAD_ENET2_RD1_SPDIF_IN                            IOMUX_PADCFG(0x443c00fc, 0x1, 0x443c0454, 0x00000001, 0x443c02ac)
#define IOMUXC_PAD_ENET2_RD1_SAI2_TX_DATA03                      IOMUX_PADCFG(0x443c00fc, 0x2, 0x00000000, 0x00000000, 0x443c02ac)
#define IOMUXC_PAD_ENET2_RD1_FLEXIO2_FLEXIO25                    IOMUX_PADCFG(0x443c00fc, 0x4, 0x00000000, 0x00000000, 0x443c02ac)
#define IOMUXC_PAD_ENET2_RD1_GPIO4_IO25                          IOMUX_PADCFG(0x443c00fc, 0x5, 0x00000000, 0x00000000, 0x443c02ac)
#define IOMUXC_PAD_ENET2_RD2_ENET1_RGMII_RD2                     IOMUX_PADCFG(0x443c0100, 0x0, 0x00000000, 0x00000000, 0x443c02b0)
#define IOMUXC_PAD_ENET2_RD2_LPUART4_CTS_B                       IOMUX_PADCFG(0x443c0100, 0x1, 0x443c0420, 0x00000001, 0x443c02b0)
#define IOMUXC_PAD_ENET2_RD2_SAI2_MCLK                           IOMUX_PADCFG(0x443c0100, 0x2, 0x00000000, 0x00000000, 0x443c02b0)
#define IOMUXC_PAD_ENET2_RD2_MQS2_RIGHT                          IOMUX_PADCFG(0x443c0100, 0x3, 0x00000000, 0x00000000, 0x443c02b0)
#define IOMUXC_PAD_ENET2_RD2_FLEXIO2_FLEXIO26                    IOMUX_PADCFG(0x443c0100, 0x4, 0x00000000, 0x00000000, 0x443c02b0)
#define IOMUXC_PAD_ENET2_RD2_GPIO4_IO26                          IOMUX_PADCFG(0x443c0100, 0x5, 0x00000000, 0x00000000, 0x443c02b0)
#define IOMUXC_PAD_ENET2_RD3_ENET1_RGMII_RD3                     IOMUX_PADCFG(0x443c0104, 0x0, 0x00000000, 0x00000000, 0x443c02b4)
#define IOMUXC_PAD_ENET2_RD3_SPDIF_OUT                           IOMUX_PADCFG(0x443c0104, 0x1, 0x00000000, 0x00000000, 0x443c02b4)
#define IOMUXC_PAD_ENET2_RD3_SPDIF_IN                            IOMUX_PADCFG(0x443c0104, 0x2, 0x443c0454, 0x00000002, 0x443c02b4)
#define IOMUXC_PAD_ENET2_RD3_MQS2_LEFT                           IOMUX_PADCFG(0x443c0104, 0x3, 0x00000000, 0x00000000, 0x443c02b4)
#define IOMUXC_PAD_ENET2_RD3_FLEXIO2_FLEXIO27                    IOMUX_PADCFG(0x443c0104, 0x4, 0x00000000, 0x00000000, 0x443c02b4)
#define IOMUXC_PAD_ENET2_RD3_GPIO4_IO27                          IOMUX_PADCFG(0x443c0104, 0x5, 0x00000000, 0x00000000, 0x443c02b4)
#define IOMUXC_PAD_SD1_CLK_FLEXIO1_FLEXIO08                      IOMUX_PADCFG(0x443c0108, 0x4, 0x443c038c, 0x00000001, 0x443c02b8)
#define IOMUXC_PAD_SD1_CLK_GPIO3_IO08                            IOMUX_PADCFG(0x443c0108, 0x5, 0x00000000, 0x00000000, 0x443c02b8)
#define IOMUXC_PAD_SD1_CLK_USDHC1_CLK                            IOMUX_PADCFG(0x443c0108, 0x0, 0x00000000, 0x00000000, 0x443c02b8)
#define IOMUXC_PAD_SD1_CMD_USDHC1_CMD                            IOMUX_PADCFG(0x443c010c, 0x0, 0x00000000, 0x00000000, 0x443c02bc)
#define IOMUXC_PAD_SD1_CMD_FLEXIO1_FLEXIO09                      IOMUX_PADCFG(0x443c010c, 0x4, 0x443c0390, 0x00000001, 0x443c02bc)
#define IOMUXC_PAD_SD1_CMD_GPIO3_IO09                            IOMUX_PADCFG(0x443c010c, 0x5, 0x00000000, 0x00000000, 0x443c02bc)
#define IOMUXC_PAD_SD1_DATA0_USDHC1_DATA0                        IOMUX_PADCFG(0x443c0110, 0x0, 0x00000000, 0x00000000, 0x443c02c0)
#define IOMUXC_PAD_SD1_DATA0_FLEXIO1_FLEXIO10                    IOMUX_PADCFG(0x443c0110, 0x4, 0x443c0394, 0x00000001, 0x443c02c0)
#define IOMUXC_PAD_SD1_DATA0_GPIO3_IO10                          IOMUX_PADCFG(0x443c0110, 0x5, 0x00000000, 0x00000000, 0x443c02c0)
#define IOMUXC_PAD_SD1_DATA1_USDHC1_DATA1                        IOMUX_PADCFG(0x443c0114, 0x0, 0x00000000, 0x00000000, 0x443c02c4)
#define IOMUXC_PAD_SD1_DATA1_FLEXIO1_FLEXIO11                    IOMUX_PADCFG(0x443c0114, 0x4, 0x443c0398, 0x00000001, 0x443c02c4)
#define IOMUXC_PAD_SD1_DATA1_GPIO3_IO11                          IOMUX_PADCFG(0x443c0114, 0x5, 0x00000000, 0x00000000, 0x443c02c4)
#define IOMUXC_PAD_SD1_DATA1_CCMSRCGPCMIX_INT_BOOT               IOMUX_PADCFG(0x443c0114, 0x6, 0x00000000, 0x00000000, 0x443c02c4)
#define IOMUXC_PAD_SD1_DATA2_USDHC1_DATA2                        IOMUX_PADCFG(0x443c0118, 0x0, 0x00000000, 0x00000000, 0x443c02c8)
#define IOMUXC_PAD_SD1_DATA2_FLEXIO1_FLEXIO12                    IOMUX_PADCFG(0x443c0118, 0x4, 0x00000000, 0x00000000, 0x443c02c8)
#define IOMUXC_PAD_SD1_DATA2_GPIO3_IO12                          IOMUX_PADCFG(0x443c0118, 0x5, 0x00000000, 0x00000000, 0x443c02c8)
#define IOMUXC_PAD_SD1_DATA2_CCMSRCGPCMIX_PMIC_READY             IOMUX_PADCFG(0x443c0118, 0x6, 0x00000000, 0x00000000, 0x443c02c8)
#define IOMUXC_PAD_SD1_DATA3_USDHC1_DATA3                        IOMUX_PADCFG(0x443c011c, 0x0, 0x00000000, 0x00000000, 0x443c02cc)
#define IOMUXC_PAD_SD1_DATA3_FLEXSPI1_A_SS1_B                    IOMUX_PADCFG(0x443c011c, 0x1, 0x00000000, 0x00000000, 0x443c02cc)
#define IOMUXC_PAD_SD1_DATA3_FLEXIO1_FLEXIO13                    IOMUX_PADCFG(0x443c011c, 0x4, 0x443c039c, 0x00000001, 0x443c02cc)
#define IOMUXC_PAD_SD1_DATA3_GPIO3_IO13                          IOMUX_PADCFG(0x443c011c, 0x5, 0x00000000, 0x00000000, 0x443c02cc)
#define IOMUXC_PAD_SD1_DATA4_USDHC1_DATA4                        IOMUX_PADCFG(0x443c0120, 0x0, 0x00000000, 0x00000000, 0x443c02d0)
#define IOMUXC_PAD_SD1_DATA4_FLEXSPI1_A_DATA04                   IOMUX_PADCFG(0x443c0120, 0x1, 0x00000000, 0x00000000, 0x443c02d0)
#define IOMUXC_PAD_SD1_DATA4_FLEXIO1_FLEXIO14                    IOMUX_PADCFG(0x443c0120, 0x4, 0x443c03a0, 0x00000001, 0x443c02d0)
#define IOMUXC_PAD_SD1_DATA4_GPIO3_IO14                          IOMUX_PADCFG(0x443c0120, 0x5, 0x00000000, 0x00000000, 0x443c02d0)
#define IOMUXC_PAD_SD1_DATA5_USDHC1_DATA5                        IOMUX_PADCFG(0x443c0124, 0x0, 0x00000000, 0x00000000, 0x443c02d4)
#define IOMUXC_PAD_SD1_DATA5_FLEXSPI1_A_DATA05                   IOMUX_PADCFG(0x443c0124, 0x1, 0x00000000, 0x00000000, 0x443c02d4)
#define IOMUXC_PAD_SD1_DATA5_USDHC1_RESET_B                      IOMUX_PADCFG(0x443c0124, 0x2, 0x00000000, 0x00000000, 0x443c02d4)
#define IOMUXC_PAD_SD1_DATA5_FLEXIO1_FLEXIO15                    IOMUX_PADCFG(0x443c0124, 0x4, 0x443c03a4, 0x00000001, 0x443c02d4)
#define IOMUXC_PAD_SD1_DATA5_GPIO3_IO15                          IOMUX_PADCFG(0x443c0124, 0x5, 0x00000000, 0x00000000, 0x443c02d4)
#define IOMUXC_PAD_SD1_DATA6_USDHC1_DATA6                        IOMUX_PADCFG(0x443c0128, 0x0, 0x00000000, 0x00000000, 0x443c02d8)
#define IOMUXC_PAD_SD1_DATA6_FLEXSPI1_A_DATA06                   IOMUX_PADCFG(0x443c0128, 0x1, 0x00000000, 0x00000000, 0x443c02d8)
#define IOMUXC_PAD_SD1_DATA6_USDHC1_CD_B                         IOMUX_PADCFG(0x443c0128, 0x2, 0x00000000, 0x00000000, 0x443c02d8)
#define IOMUXC_PAD_SD1_DATA6_FLEXIO1_FLEXIO16                    IOMUX_PADCFG(0x443c0128, 0x4, 0x443c03a8, 0x00000001, 0x443c02d8)
#define IOMUXC_PAD_SD1_DATA6_GPIO3_IO16                          IOMUX_PADCFG(0x443c0128, 0x5, 0x00000000, 0x00000000, 0x443c02d8)
#define IOMUXC_PAD_SD1_DATA7_USDHC1_DATA7                        IOMUX_PADCFG(0x443c012c, 0x0, 0x00000000, 0x00000000, 0x443c02dc)
#define IOMUXC_PAD_SD1_DATA7_FLEXSPI1_A_DATA07                   IOMUX_PADCFG(0x443c012c, 0x1, 0x00000000, 0x00000000, 0x443c02dc)
#define IOMUXC_PAD_SD1_DATA7_USDHC1_WP                           IOMUX_PADCFG(0x443c012c, 0x2, 0x00000000, 0x00000000, 0x443c02dc)
#define IOMUXC_PAD_SD1_DATA7_FLEXIO1_FLEXIO17                    IOMUX_PADCFG(0x443c012c, 0x4, 0x443c03ac, 0x00000001, 0x443c02dc)
#define IOMUXC_PAD_SD1_DATA7_GPIO3_IO17                          IOMUX_PADCFG(0x443c012c, 0x5, 0x00000000, 0x00000000, 0x443c02dc)
#define IOMUXC_PAD_SD1_STROBE_USDHC1_STROBE                      IOMUX_PADCFG(0x443c0130, 0x0, 0x00000000, 0x00000000, 0x443c02e0)
#define IOMUXC_PAD_SD1_STROBE_FLEXSPI1_A_DQS                     IOMUX_PADCFG(0x443c0130, 0x1, 0x00000000, 0x00000000, 0x443c02e0)
#define IOMUXC_PAD_SD1_STROBE_FLEXIO1_FLEXIO18                   IOMUX_PADCFG(0x443c0130, 0x4, 0x443c03b0, 0x00000001, 0x443c02e0)
#define IOMUXC_PAD_SD1_STROBE_GPIO3_IO18                         IOMUX_PADCFG(0x443c0130, 0x5, 0x00000000, 0x00000000, 0x443c02e0)
#define IOMUXC_PAD_SD2_VSELECT_USDHC2_VSELECT                    IOMUX_PADCFG(0x443c0134, 0x0, 0x00000000, 0x00000000, 0x443c02e4)
#define IOMUXC_PAD_SD2_VSELECT_USDHC2_WP                         IOMUX_PADCFG(0x443c0134, 0x1, 0x00000000, 0x00000000, 0x443c02e4)
#define IOMUXC_PAD_SD2_VSELECT_LPTMR2_ALT3                       IOMUX_PADCFG(0x443c0134, 0x2, 0x443c0410, 0x00000001, 0x443c02e4)
#define IOMUXC_PAD_SD2_VSELECT_FLEXIO1_FLEXIO19                  IOMUX_PADCFG(0x443c0134, 0x4, 0x00000000, 0x00000000, 0x443c02e4)
#define IOMUXC_PAD_SD2_VSELECT_GPIO3_IO19                        IOMUX_PADCFG(0x443c0134, 0x5, 0x00000000, 0x00000000, 0x443c02e4)
#define IOMUXC_PAD_SD2_VSELECT_CCMSRCGPCMIX_EXT_CLK1             IOMUX_PADCFG(0x443c0134, 0x6, 0x443c0368, 0x00000000, 0x443c02e4)
#define IOMUXC_PAD_SD3_CLK_USDHC3_CLK                            IOMUX_PADCFG(0x443c0138, 0x0, 0x443c0458, 0x00000001, 0x443c02e8)
#define IOMUXC_PAD_SD3_CLK_FLEXSPI1_A_SCLK                       IOMUX_PADCFG(0x443c0138, 0x1, 0x00000000, 0x00000000, 0x443c02e8)
#define IOMUXC_PAD_SD3_CLK_FLEXIO1_FLEXIO20                      IOMUX_PADCFG(0x443c0138, 0x4, 0x443c03b4, 0x00000001, 0x443c02e8)
#define IOMUXC_PAD_SD3_CLK_GPIO3_IO20                            IOMUX_PADCFG(0x443c0138, 0x5, 0x00000000, 0x00000000, 0x443c02e8)
#define IOMUXC_PAD_SD3_CMD_USDHC3_CMD                            IOMUX_PADCFG(0x443c013c, 0x0, 0x443c045c, 0x00000001, 0x443c02ec)
#define IOMUXC_PAD_SD3_CMD_FLEXSPI1_A_SS0_B                      IOMUX_PADCFG(0x443c013c, 0x1, 0x00000000, 0x00000000, 0x443c02ec)
#define IOMUXC_PAD_SD3_CMD_FLEXIO1_FLEXIO21                      IOMUX_PADCFG(0x443c013c, 0x4, 0x00000000, 0x00000000, 0x443c02ec)
#define IOMUXC_PAD_SD3_CMD_GPIO3_IO21                            IOMUX_PADCFG(0x443c013c, 0x5, 0x00000000, 0x00000000, 0x443c02ec)
#define IOMUXC_PAD_SD3_DATA0_USDHC3_DATA0                        IOMUX_PADCFG(0x443c0140, 0x0, 0x443c0460, 0x00000001, 0x443c02f0)
#define IOMUXC_PAD_SD3_DATA0_FLEXSPI1_A_DATA00                   IOMUX_PADCFG(0x443c0140, 0x1, 0x00000000, 0x00000000, 0x443c02f0)
#define IOMUXC_PAD_SD3_DATA0_FLEXIO1_FLEXIO22                    IOMUX_PADCFG(0x443c0140, 0x4, 0x443c03b8, 0x00000001, 0x443c02f0)
#define IOMUXC_PAD_SD3_DATA0_GPIO3_IO22                          IOMUX_PADCFG(0x443c0140, 0x5, 0x00000000, 0x00000000, 0x443c02f0)
#define IOMUXC_PAD_SD3_DATA1_USDHC3_DATA1                        IOMUX_PADCFG(0x443c0144, 0x0, 0x443c0464, 0x00000001, 0x443c02f4)
#define IOMUXC_PAD_SD3_DATA1_FLEXSPI1_A_DATA01                   IOMUX_PADCFG(0x443c0144, 0x1, 0x00000000, 0x00000000, 0x443c02f4)
#define IOMUXC_PAD_SD3_DATA1_FLEXIO1_FLEXIO23                    IOMUX_PADCFG(0x443c0144, 0x4, 0x443c03bc, 0x00000001, 0x443c02f4)
#define IOMUXC_PAD_SD3_DATA1_GPIO3_IO23                          IOMUX_PADCFG(0x443c0144, 0x5, 0x00000000, 0x00000000, 0x443c02f4)
#define IOMUXC_PAD_SD3_DATA2_USDHC3_DATA2                        IOMUX_PADCFG(0x443c0148, 0x0, 0x443c0468, 0x00000001, 0x443c02f8)
#define IOMUXC_PAD_SD3_DATA2_FLEXSPI1_A_DATA02                   IOMUX_PADCFG(0x443c0148, 0x1, 0x00000000, 0x00000000, 0x443c02f8)
#define IOMUXC_PAD_SD3_DATA2_FLEXIO1_FLEXIO24                    IOMUX_PADCFG(0x443c0148, 0x4, 0x443c03c0, 0x00000001, 0x443c02f8)
#define IOMUXC_PAD_SD3_DATA2_GPIO3_IO24                          IOMUX_PADCFG(0x443c0148, 0x5, 0x00000000, 0x00000000, 0x443c02f8)
#define IOMUXC_PAD_SD3_DATA3_USDHC3_DATA3                        IOMUX_PADCFG(0x443c014c, 0x0, 0x443c046c, 0x00000001, 0x443c02fc)
#define IOMUXC_PAD_SD3_DATA3_FLEXSPI1_A_DATA03                   IOMUX_PADCFG(0x443c014c, 0x1, 0x00000000, 0x00000000, 0x443c02fc)
#define IOMUXC_PAD_SD3_DATA3_FLEXIO1_FLEXIO25                    IOMUX_PADCFG(0x443c014c, 0x4, 0x443c03c4, 0x00000001, 0x443c02fc)
#define IOMUXC_PAD_SD3_DATA3_GPIO3_IO25                          IOMUX_PADCFG(0x443c014c, 0x5, 0x00000000, 0x00000000, 0x443c02fc)
#define IOMUXC_PAD_SD2_CD_B_USDHC2_CD_B                          IOMUX_PADCFG(0x443c0150, 0x0, 0x00000000, 0x00000000, 0x443c0300)
#define IOMUXC_PAD_SD2_CD_B_ENET_QOS_1588_EVENT0_IN              IOMUX_PADCFG(0x443c0150, 0x1, 0x00000000, 0x00000000, 0x443c0300)
#define IOMUXC_PAD_SD2_CD_B_I3C2_SCL                             IOMUX_PADCFG(0x443c0150, 0x2, 0x443c03cc, 0x00000001, 0x443c0300)
#define IOMUXC_PAD_SD2_CD_B_FLEXIO1_FLEXIO00                     IOMUX_PADCFG(0x443c0150, 0x4, 0x443c036c, 0x00000001, 0x443c0300)
#define IOMUXC_PAD_SD2_CD_B_GPIO3_IO00                           IOMUX_PADCFG(0x443c0150, 0x5, 0x00000000, 0x00000000, 0x443c0300)
#define IOMUXC_PAD_SD2_CLK_USDHC2_CLK                            IOMUX_PADCFG(0x443c0154, 0x0, 0x00000000, 0x00000000, 0x443c0304)
#define IOMUXC_PAD_SD2_CLK_ENET_QOS_1588_EVENT0_OUT              IOMUX_PADCFG(0x443c0154, 0x1, 0x00000000, 0x00000000, 0x443c0304)
#define IOMUXC_PAD_SD2_CLK_I3C2_SDA                              IOMUX_PADCFG(0x443c0154, 0x2, 0x443c03d0, 0x00000001, 0x443c0304)
#define IOMUXC_PAD_SD2_CLK_FLEXIO1_FLEXIO01                      IOMUX_PADCFG(0x443c0154, 0x4, 0x443c0370, 0x00000001, 0x443c0304)
#define IOMUXC_PAD_SD2_CLK_GPIO3_IO01                            IOMUX_PADCFG(0x443c0154, 0x5, 0x00000000, 0x00000000, 0x443c0304)
#define IOMUXC_PAD_SD2_CLK_CCMSRCGPCMIX_OBSERVE0                 IOMUX_PADCFG(0x443c0154, 0x6, 0x00000000, 0x00000000, 0x443c0304)
#define IOMUXC_PAD_SD2_CMD_USDHC2_CMD                            IOMUX_PADCFG(0x443c0158, 0x0, 0x00000000, 0x00000000, 0x443c0308)
#define IOMUXC_PAD_SD2_CMD_ENET1_1588_EVENT0_IN                  IOMUX_PADCFG(0x443c0158, 0x1, 0x00000000, 0x00000000, 0x443c0308)
#define IOMUXC_PAD_SD2_CMD_I3C2_PUR                              IOMUX_PADCFG(0x443c0158, 0x2, 0x00000000, 0x00000000, 0x443c0308)
#define IOMUXC_PAD_SD2_CMD_I3C2_PUR_B                            IOMUX_PADCFG(0x443c0158, 0x3, 0x00000000, 0x00000000, 0x443c0308)
#define IOMUXC_PAD_SD2_CMD_FLEXIO1_FLEXIO02                      IOMUX_PADCFG(0x443c0158, 0x4, 0x443c0374, 0x00000001, 0x443c0308)
#define IOMUXC_PAD_SD2_CMD_GPIO3_IO02                            IOMUX_PADCFG(0x443c0158, 0x5, 0x00000000, 0x00000000, 0x443c0308)
#define IOMUXC_PAD_SD2_CMD_CCMSRCGPCMIX_OBSERVE1                 IOMUX_PADCFG(0x443c0158, 0x6, 0x00000000, 0x00000000, 0x443c0308)
#define IOMUXC_PAD_SD2_DATA0_USDHC2_DATA0                        IOMUX_PADCFG(0x443c015c, 0x0, 0x00000000, 0x00000000, 0x443c030c)
#define IOMUXC_PAD_SD2_DATA0_ENET1_1588_EVENT0_OUT               IOMUX_PADCFG(0x443c015c, 0x1, 0x00000000, 0x00000000, 0x443c030c)
#define IOMUXC_PAD_SD2_DATA0_CAN2_TX                             IOMUX_PADCFG(0x443c015c, 0x2, 0x00000000, 0x00000000, 0x443c030c)
#define IOMUXC_PAD_SD2_DATA0_FLEXIO1_FLEXIO03                    IOMUX_PADCFG(0x443c015c, 0x4, 0x443c0378, 0x00000001, 0x443c030c)
#define IOMUXC_PAD_SD2_DATA0_GPIO3_IO03                          IOMUX_PADCFG(0x443c015c, 0x5, 0x00000000, 0x00000000, 0x443c030c)
#define IOMUXC_PAD_SD2_DATA0_CCMSRCGPCMIX_OBSERVE2               IOMUX_PADCFG(0x443c015c, 0x6, 0x00000000, 0x00000000, 0x443c030c)
#define IOMUXC_PAD_SD2_DATA1_USDHC2_DATA1                        IOMUX_PADCFG(0x443c0160, 0x0, 0x00000000, 0x00000000, 0x443c0310)
#define IOMUXC_PAD_SD2_DATA1_ENET1_1588_EVENT1_IN                IOMUX_PADCFG(0x443c0160, 0x1, 0x00000000, 0x00000000, 0x443c0310)
#define IOMUXC_PAD_SD2_DATA1_CAN2_RX                             IOMUX_PADCFG(0x443c0160, 0x2, 0x443c0364, 0x00000003, 0x443c0310)
#define IOMUXC_PAD_SD2_DATA1_FLEXIO1_FLEXIO04                    IOMUX_PADCFG(0x443c0160, 0x4, 0x443c037c, 0x00000001, 0x443c0310)
#define IOMUXC_PAD_SD2_DATA1_GPIO3_IO04                          IOMUX_PADCFG(0x443c0160, 0x5, 0x00000000, 0x00000000, 0x443c0310)
#define IOMUXC_PAD_SD2_DATA1_CCMSRCGPCMIX_WAIT                   IOMUX_PADCFG(0x443c0160, 0x6, 0x00000000, 0x00000000, 0x443c0310)
#define IOMUXC_PAD_SD2_DATA2_USDHC2_DATA2                        IOMUX_PADCFG(0x443c0164, 0x0, 0x00000000, 0x00000000, 0x443c0314)
#define IOMUXC_PAD_SD2_DATA2_ENET1_1588_EVENT1_OUT               IOMUX_PADCFG(0x443c0164, 0x1, 0x00000000, 0x00000000, 0x443c0314)
#define IOMUXC_PAD_SD2_DATA2_MQS2_RIGHT                          IOMUX_PADCFG(0x443c0164, 0x2, 0x00000000, 0x00000000, 0x443c0314)
#define IOMUXC_PAD_SD2_DATA2_FLEXIO1_FLEXIO05                    IOMUX_PADCFG(0x443c0164, 0x4, 0x443c0380, 0x00000001, 0x443c0314)
#define IOMUXC_PAD_SD2_DATA2_GPIO3_IO05                          IOMUX_PADCFG(0x443c0164, 0x5, 0x00000000, 0x00000000, 0x443c0314)
#define IOMUXC_PAD_SD2_DATA2_CCMSRCGPCMIX_STOP                   IOMUX_PADCFG(0x443c0164, 0x6, 0x00000000, 0x00000000, 0x443c0314)
#define IOMUXC_PAD_SD2_DATA3_USDHC2_DATA3                        IOMUX_PADCFG(0x443c0168, 0x0, 0x00000000, 0x00000000, 0x443c0318)
#define IOMUXC_PAD_SD2_DATA3_LPTMR2_ALT1                         IOMUX_PADCFG(0x443c0168, 0x1, 0x443c0408, 0x00000001, 0x443c0318)
#define IOMUXC_PAD_SD2_DATA3_MQS2_LEFT                           IOMUX_PADCFG(0x443c0168, 0x2, 0x00000000, 0x00000000, 0x443c0318)
#define IOMUXC_PAD_SD2_DATA3_FLEXIO1_FLEXIO06                    IOMUX_PADCFG(0x443c0168, 0x4, 0x443c0384, 0x00000001, 0x443c0318)
#define IOMUXC_PAD_SD2_DATA3_GPIO3_IO06                          IOMUX_PADCFG(0x443c0168, 0x5, 0x00000000, 0x00000000, 0x443c0318)
#define IOMUXC_PAD_SD2_DATA3_CCMSRCGPCMIX_EARLY_RESET            IOMUX_PADCFG(0x443c0168, 0x6, 0x00000000, 0x00000000, 0x443c0318)
#define IOMUXC_PAD_SD2_RESET_B_USDHC2_RESET_B                    IOMUX_PADCFG(0x443c016c, 0x0, 0x00000000, 0x00000000, 0x443c031c)
#define IOMUXC_PAD_SD2_RESET_B_LPTMR2_ALT2                       IOMUX_PADCFG(0x443c016c, 0x1, 0x443c040c, 0x00000001, 0x443c031c)
#define IOMUXC_PAD_SD2_RESET_B_FLEXIO1_FLEXIO07                  IOMUX_PADCFG(0x443c016c, 0x4, 0x443c0388, 0x00000001, 0x443c031c)
#define IOMUXC_PAD_SD2_RESET_B_GPIO3_IO07                        IOMUX_PADCFG(0x443c016c, 0x5, 0x00000000, 0x00000000, 0x443c031c)
#define IOMUXC_PAD_SD2_RESET_B_CCMSRCGPCMIX_SYSTEM_RESET         IOMUX_PADCFG(0x443c016c, 0x6, 0x00000000, 0x00000000, 0x443c031c)
#define IOMUXC_PAD_I2C1_SCL_LPI2C1_SCL                           IOMUX_PADCFG(0x443c0170, 0x0, 0x00000000, 0x00000000, 0x443c0320)
#define IOMUXC_PAD_I2C1_SCL_I3C1_SCL                             IOMUX_PADCFG(0x443c0170, 0x1, 0x00000000, 0x00000000, 0x443c0320)
#define IOMUXC_PAD_I2C1_SCL_LPUART1_DCB_B                        IOMUX_PADCFG(0x443c0170, 0x2, 0x00000000, 0x00000000, 0x443c0320)
#define IOMUXC_PAD_I2C1_SCL_TPM2_CH0                             IOMUX_PADCFG(0x443c0170, 0x3, 0x00000000, 0x00000000, 0x443c0320)
#define IOMUXC_PAD_I2C1_SCL_GPIO1_IO00                           IOMUX_PADCFG(0x443c0170, 0x5, 0x00000000, 0x00000000, 0x443c0320)
#define IOMUXC_PAD_I2C1_SDA_LPI2C1_SDA                           IOMUX_PADCFG(0x443c0174, 0x0, 0x00000000, 0x00000000, 0x443c0324)
#define IOMUXC_PAD_I2C1_SDA_I3C1_SDA                             IOMUX_PADCFG(0x443c0174, 0x1, 0x00000000, 0x00000000, 0x443c0324)
#define IOMUXC_PAD_I2C1_SDA_LPUART1_RIN_B                        IOMUX_PADCFG(0x443c0174, 0x2, 0x00000000, 0x00000000, 0x443c0324)
#define IOMUXC_PAD_I2C1_SDA_TPM2_CH1                             IOMUX_PADCFG(0x443c0174, 0x3, 0x00000000, 0x00000000, 0x443c0324)
#define IOMUXC_PAD_I2C1_SDA_GPIO1_IO01                           IOMUX_PADCFG(0x443c0174, 0x5, 0x00000000, 0x00000000, 0x443c0324)
#define IOMUXC_PAD_I2C2_SCL_LPI2C2_SCL                           IOMUX_PADCFG(0x443c0178, 0x0, 0x00000000, 0x00000000, 0x443c0328)
#define IOMUXC_PAD_I2C2_SCL_I3C1_PUR                             IOMUX_PADCFG(0x443c0178, 0x1, 0x00000000, 0x00000000, 0x443c0328)
#define IOMUXC_PAD_I2C2_SCL_LPUART2_DCB_B                        IOMUX_PADCFG(0x443c0178, 0x2, 0x00000000, 0x00000000, 0x443c0328)
#define IOMUXC_PAD_I2C2_SCL_TPM2_CH2                             IOMUX_PADCFG(0x443c0178, 0x3, 0x00000000, 0x00000000, 0x443c0328)
#define IOMUXC_PAD_I2C2_SCL_SAI1_RX_SYNC                         IOMUX_PADCFG(0x443c0178, 0x4, 0x00000000, 0x00000000, 0x443c0328)
#define IOMUXC_PAD_I2C2_SCL_GPIO1_IO02                           IOMUX_PADCFG(0x443c0178, 0x5, 0x00000000, 0x00000000, 0x443c0328)
#define IOMUXC_PAD_I2C2_SCL_I3C1_PUR_B                           IOMUX_PADCFG(0x443c0178, 0x6, 0x00000000, 0x00000000, 0x443c0328)
#define IOMUXC_PAD_I2C2_SDA_LPI2C2_SDA                           IOMUX_PADCFG(0x443c017c, 0x0, 0x00000000, 0x00000000, 0x443c032c)
#define IOMUXC_PAD_I2C2_SDA_LPUART2_RIN_B                        IOMUX_PADCFG(0x443c017c, 0x2, 0x00000000, 0x00000000, 0x443c032c)
#define IOMUXC_PAD_I2C2_SDA_TPM2_CH3                             IOMUX_PADCFG(0x443c017c, 0x3, 0x00000000, 0x00000000, 0x443c032c)
#define IOMUXC_PAD_I2C2_SDA_SAI1_RX_BCLK                         IOMUX_PADCFG(0x443c017c, 0x4, 0x00000000, 0x00000000, 0x443c032c)
#define IOMUXC_PAD_I2C2_SDA_GPIO1_IO03                           IOMUX_PADCFG(0x443c017c, 0x5, 0x00000000, 0x00000000, 0x443c032c)
#define IOMUXC_PAD_UART1_RXD_LPUART1_RX                          IOMUX_PADCFG(0x443c0180, 0x0, 0x00000000, 0x00000000, 0x443c0330)
#define IOMUXC_PAD_UART1_RXD_S400_UART_RX                        IOMUX_PADCFG(0x443c0180, 0x1, 0x00000000, 0x00000000, 0x443c0330)
#define IOMUXC_PAD_UART1_RXD_LPSPI2_SIN                          IOMUX_PADCFG(0x443c0180, 0x2, 0x00000000, 0x00000000, 0x443c0330)
#define IOMUXC_PAD_UART1_RXD_TPM1_CH0                            IOMUX_PADCFG(0x443c0180, 0x3, 0x00000000, 0x00000000, 0x443c0330)
#define IOMUXC_PAD_UART1_RXD_GPIO1_IO04                          IOMUX_PADCFG(0x443c0180, 0x5, 0x00000000, 0x00000000, 0x443c0330)
#define IOMUXC_PAD_UART1_TXD_LPUART1_TX                          IOMUX_PADCFG(0x443c0184, 0x0, 0x00000000, 0x00000000, 0x443c0334)
#define IOMUXC_PAD_UART1_TXD_S400_UART_TX                        IOMUX_PADCFG(0x443c0184, 0x1, 0x00000000, 0x00000000, 0x443c0334)
#define IOMUXC_PAD_UART1_TXD_LPSPI2_PCS0                         IOMUX_PADCFG(0x443c0184, 0x2, 0x00000000, 0x00000000, 0x443c0334)
#define IOMUXC_PAD_UART1_TXD_TPM1_CH1                            IOMUX_PADCFG(0x443c0184, 0x3, 0x00000000, 0x00000000, 0x443c0334)
#define IOMUXC_PAD_UART1_TXD_GPIO1_IO05                          IOMUX_PADCFG(0x443c0184, 0x5, 0x00000000, 0x00000000, 0x443c0334)
#define IOMUXC_PAD_UART2_RXD_LPUART2_RX                          IOMUX_PADCFG(0x443c0188, 0x0, 0x00000000, 0x00000000, 0x443c0338)
#define IOMUXC_PAD_UART2_RXD_LPUART1_CTS_B                       IOMUX_PADCFG(0x443c0188, 0x1, 0x00000000, 0x00000000, 0x443c0338)
#define IOMUXC_PAD_UART2_RXD_LPSPI2_SOUT                         IOMUX_PADCFG(0x443c0188, 0x2, 0x00000000, 0x00000000, 0x443c0338)
#define IOMUXC_PAD_UART2_RXD_TPM1_CH2                            IOMUX_PADCFG(0x443c0188, 0x3, 0x00000000, 0x00000000, 0x443c0338)
#define IOMUXC_PAD_UART2_RXD_SAI1_MCLK                           IOMUX_PADCFG(0x443c0188, 0x4, 0x443c0448, 0x00000000, 0x443c0338)
#define IOMUXC_PAD_UART2_RXD_GPIO1_IO06                          IOMUX_PADCFG(0x443c0188, 0x5, 0x00000000, 0x00000000, 0x443c0338)
#define IOMUXC_PAD_UART2_TXD_LPUART2_TX                          IOMUX_PADCFG(0x443c018c, 0x0, 0x00000000, 0x00000000, 0x443c033c)
#define IOMUXC_PAD_UART2_TXD_LPUART1_RTS_B                       IOMUX_PADCFG(0x443c018c, 0x1, 0x00000000, 0x00000000, 0x443c033c)
#define IOMUXC_PAD_UART2_TXD_LPSPI2_SCK                          IOMUX_PADCFG(0x443c018c, 0x2, 0x00000000, 0x00000000, 0x443c033c)
#define IOMUXC_PAD_UART2_TXD_TPM1_CH3                            IOMUX_PADCFG(0x443c018c, 0x3, 0x00000000, 0x00000000, 0x443c033c)
#define IOMUXC_PAD_UART2_TXD_GPIO1_IO07                          IOMUX_PADCFG(0x443c018c, 0x5, 0x00000000, 0x00000000, 0x443c033c)
#define IOMUXC_PAD_PDM_CLK_PDM_CLK                               IOMUX_PADCFG(0x443c0190, 0x0, 0x00000000, 0x00000000, 0x443c0340)
#define IOMUXC_PAD_PDM_CLK_MQS1_LEFT                             IOMUX_PADCFG(0x443c0190, 0x1, 0x00000000, 0x00000000, 0x443c0340)
#define IOMUXC_PAD_PDM_CLK_LPTMR1_ALT1                           IOMUX_PADCFG(0x443c0190, 0x4, 0x00000000, 0x00000000, 0x443c0340)
#define IOMUXC_PAD_PDM_CLK_GPIO1_IO08                            IOMUX_PADCFG(0x443c0190, 0x5, 0x00000000, 0x00000000, 0x443c0340)
#define IOMUXC_PAD_PDM_CLK_CAN1_TX                               IOMUX_PADCFG(0x443c0190, 0x6, 0x00000000, 0x00000000, 0x443c0340)
#define IOMUXC_PAD_PDM_BIT_STREAM0_PDM_BIT_STREAM00              IOMUX_PADCFG(0x443c0194, 0x0, 0x443c0438, 0x00000002, 0x443c0344)
#define IOMUXC_PAD_PDM_BIT_STREAM0_MQS1_RIGHT                    IOMUX_PADCFG(0x443c0194, 0x1, 0x00000000, 0x00000000, 0x443c0344)
#define IOMUXC_PAD_PDM_BIT_STREAM0_LPSPI1_PCS1                   IOMUX_PADCFG(0x443c0194, 0x2, 0x00000000, 0x00000000, 0x443c0344)
#define IOMUXC_PAD_PDM_BIT_STREAM0_TPM1_EXTCLK                   IOMUX_PADCFG(0x443c0194, 0x3, 0x00000000, 0x00000000, 0x443c0344)
#define IOMUXC_PAD_PDM_BIT_STREAM0_LPTMR1_ALT2                   IOMUX_PADCFG(0x443c0194, 0x4, 0x00000000, 0x00000000, 0x443c0344)
#define IOMUXC_PAD_PDM_BIT_STREAM0_GPIO1_IO09                    IOMUX_PADCFG(0x443c0194, 0x5, 0x00000000, 0x00000000, 0x443c0344)
#define IOMUXC_PAD_PDM_BIT_STREAM0_CAN1_RX                       IOMUX_PADCFG(0x443c0194, 0x6, 0x443c0360, 0x00000000, 0x443c0344)
#define IOMUXC_PAD_PDM_BIT_STREAM1_PDM_BIT_STREAM01              IOMUX_PADCFG(0x443c0198, 0x0, 0x443c043c, 0x00000002, 0x443c0348)
#define IOMUXC_PAD_PDM_BIT_STREAM1_NMI_GLUE_NMI                  IOMUX_PADCFG(0x443c0198, 0x1, 0x00000000, 0x00000000, 0x443c0348)
#define IOMUXC_PAD_PDM_BIT_STREAM1_LPSPI2_PCS1                   IOMUX_PADCFG(0x443c0198, 0x2, 0x00000000, 0x00000000, 0x443c0348)
#define IOMUXC_PAD_PDM_BIT_STREAM1_TPM2_EXTCLK                   IOMUX_PADCFG(0x443c0198, 0x3, 0x00000000, 0x00000000, 0x443c0348)
#define IOMUXC_PAD_PDM_BIT_STREAM1_LPTMR1_ALT3                   IOMUX_PADCFG(0x443c0198, 0x4, 0x00000000, 0x00000000, 0x443c0348)
#define IOMUXC_PAD_PDM_BIT_STREAM1_GPIO1_IO10                    IOMUX_PADCFG(0x443c0198, 0x5, 0x00000000, 0x00000000, 0x443c0348)
#define IOMUXC_PAD_PDM_BIT_STREAM1_CCMSRCGPCMIX_EXT_CLK1         IOMUX_PADCFG(0x443c0198, 0x6, 0x443c0368, 0x00000001, 0x443c0348)
#define IOMUXC_PAD_SAI1_TXFS_SAI1_TX_SYNC                        IOMUX_PADCFG(0x443c019c, 0x0, 0x00000000, 0x00000000, 0x443c034c)
#define IOMUXC_PAD_SAI1_TXFS_SAI1_TX_DATA01                      IOMUX_PADCFG(0x443c019c, 0x1, 0x00000000, 0x00000000, 0x443c034c)
#define IOMUXC_PAD_SAI1_TXFS_LPSPI1_PCS0                         IOMUX_PADCFG(0x443c019c, 0x2, 0x00000000, 0x00000000, 0x443c034c)
#define IOMUXC_PAD_SAI1_TXFS_LPUART2_DTR_B                       IOMUX_PADCFG(0x443c019c, 0x3, 0x00000000, 0x00000000, 0x443c034c)
#define IOMUXC_PAD_SAI1_TXFS_MQS1_LEFT                           IOMUX_PADCFG(0x443c019c, 0x4, 0x00000000, 0x00000000, 0x443c034c)
#define IOMUXC_PAD_SAI1_TXFS_GPIO1_IO11                          IOMUX_PADCFG(0x443c019c, 0x5, 0x00000000, 0x00000000, 0x443c034c)
#define IOMUXC_PAD_SAI1_TXC_SAI1_TX_BCLK                         IOMUX_PADCFG(0x443c01a0, 0x0, 0x00000000, 0x00000000, 0x443c0350)
#define IOMUXC_PAD_SAI1_TXC_LPUART2_CTS_B                        IOMUX_PADCFG(0x443c01a0, 0x1, 0x00000000, 0x00000000, 0x443c0350)
#define IOMUXC_PAD_SAI1_TXC_LPSPI1_SIN                           IOMUX_PADCFG(0x443c01a0, 0x2, 0x00000000, 0x00000000, 0x443c0350)
#define IOMUXC_PAD_SAI1_TXC_LPUART1_DSR_B                        IOMUX_PADCFG(0x443c01a0, 0x3, 0x00000000, 0x00000000, 0x443c0350)
#define IOMUXC_PAD_SAI1_TXC_CAN1_RX                              IOMUX_PADCFG(0x443c01a0, 0x4, 0x443c0360, 0x00000001, 0x443c0350)
#define IOMUXC_PAD_SAI1_TXC_GPIO1_IO12                           IOMUX_PADCFG(0x443c01a0, 0x5, 0x00000000, 0x00000000, 0x443c0350)
#define IOMUXC_PAD_SAI1_TXD0_SAI1_TX_DATA00                      IOMUX_PADCFG(0x443c01a4, 0x0, 0x00000000, 0x00000000, 0x443c0354)
#define IOMUXC_PAD_SAI1_TXD0_LPUART2_RTS_B                       IOMUX_PADCFG(0x443c01a4, 0x1, 0x00000000, 0x00000000, 0x443c0354)
#define IOMUXC_PAD_SAI1_TXD0_LPSPI1_SCK                          IOMUX_PADCFG(0x443c01a4, 0x2, 0x00000000, 0x00000000, 0x443c0354)
#define IOMUXC_PAD_SAI1_TXD0_LPUART1_DTR_B                       IOMUX_PADCFG(0x443c01a4, 0x3, 0x00000000, 0x00000000, 0x443c0354)
#define IOMUXC_PAD_SAI1_TXD0_CAN1_TX                             IOMUX_PADCFG(0x443c01a4, 0x4, 0x00000000, 0x00000000, 0x443c0354)
#define IOMUXC_PAD_SAI1_TXD0_GPIO1_IO13                          IOMUX_PADCFG(0x443c01a4, 0x5, 0x00000000, 0x00000000, 0x443c0354)
#define IOMUXC_PAD_SAI1_RXD0_SAI1_RX_DATA00                      IOMUX_PADCFG(0x443c01a8, 0x0, 0x00000000, 0x00000000, 0x443c0358)
#define IOMUXC_PAD_SAI1_RXD0_SAI1_MCLK                           IOMUX_PADCFG(0x443c01a8, 0x1, 0x443c0448, 0x00000001, 0x443c0358)
#define IOMUXC_PAD_SAI1_RXD0_LPSPI1_SOUT                         IOMUX_PADCFG(0x443c01a8, 0x2, 0x00000000, 0x00000000, 0x443c0358)
#define IOMUXC_PAD_SAI1_RXD0_LPUART2_DSR_B                       IOMUX_PADCFG(0x443c01a8, 0x3, 0x00000000, 0x00000000, 0x443c0358)
#define IOMUXC_PAD_SAI1_RXD0_MQS1_RIGHT                          IOMUX_PADCFG(0x443c01a8, 0x4, 0x00000000, 0x00000000, 0x443c0358)
#define IOMUXC_PAD_SAI1_RXD0_GPIO1_IO14                          IOMUX_PADCFG(0x443c01a8, 0x5, 0x00000000, 0x00000000, 0x443c0358)
#define IOMUXC_PAD_WDOG_ANY_WDOG1_WDOG_ANY                       IOMUX_PADCFG(0x443c01ac, 0x0, 0x00000000, 0x00000000, 0x443c035c)
#define IOMUXC_PAD_WDOG_ANY_GPIO1_IO15                           IOMUX_PADCFG(0x443c01ac, 0x5, 0x00000000, 0x00000000, 0x443c035c)

#endif /* __ARCH_ARM64_SRC_IMX9_HARDWARE_IMX93_IMX93_PINMUX_H */
