/****************************************************************************
 * apps/netutils/thttpd/cgi-src/phf.c
 *
 * SPDX-License-Identifier: BSD-2-Clause
 * SPDX-FileCopyrightText: 2009, 2015 Gregory Nutt. All rights reserved.
 * SPDX-FileCopyrightText: 1996 by Jef Poskanzer <jef@mail.acme.com>.
 * SPDX-FileContributor: Gregory Nutt <gnutt@nuttx.org>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 ****************************************************************************/

/* Old distributions of the NCSA and Apache web servers included a
 * version of the phf program that had a bug.  The program could
 * easily be made to run arbitrary shell commands.  There is no real
 * legitimate use for phf, so any attempts to run it must be considered
 * to be attacks.  Accordingly, this version of phf logs the attack
 * on stderr and then returns a page on CONFIG_THTTPD_CGI_OUTFD indicating
 * that phf doesn't exist.
 */

/****************************************************************************
 * Included Files
 ****************************************************************************/

#include <nuttx/config.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "config.h"

/****************************************************************************
 * Public Functions
 ****************************************************************************/

#ifdef CONFIG_THTTPD_BINFS
int phf_main(int argc, char *argv[])
#else
int main(int argc, char *argv[])
#endif
{
  fprintf(stderr, "phf CGI probe from %s\n", getenv("REMOTE_ADDR"));

  printf("Content-type: text/html\n"
         "Status: 404/html\n"
         "\n"
         "<HTML><HEAD><TITLE>404 Not Found</TITLE></HEAD>\n"
         "<BODY><H2>404 Not Found</H2>\n"
         "The requested object does not exist on this server.\n"
         "The link you followed is either outdated, inaccurate,\n"
         "or the server has been instructed not to let you have it.\n"
         "</BODY></HTML>\n");

  return 0;
}
