/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.buffer.Unpooled;
import org.apache.ozone.shaded.org.apache.ratis.util.Preconditions;

public final class StringUtils {
    private static final Charset UTF8 = StandardCharsets.UTF_8;

    private StringUtils() {
    }

    public static String bytes2String(byte[] bytes, int offset, int length) {
        return new String(bytes, offset, length, UTF8);
    }

    public static String bytes2String(ByteBuffer bytes) {
        return StringUtils.bytes2String(bytes, UTF8);
    }

    public static String bytes2String(ByteBuffer bytes, Charset charset) {
        return Unpooled.wrappedBuffer(bytes.asReadOnlyBuffer()).toString(charset);
    }

    public static String bytes2Hex(ByteBuffer buffer, int max) {
        Preconditions.assertTrue(max > 0, () -> "max = " + max + " <= 0");
        buffer = buffer.asReadOnlyBuffer();
        int remaining = buffer.remaining();
        boolean overflow = max < remaining;
        int n = overflow ? max : remaining;
        StringBuilder builder = new StringBuilder(3 * n + (overflow ? 3 : 0));
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                builder.append(String.format("%02X ", buffer.get()));
            }
            builder.setLength(builder.length() - 1);
        }
        if (overflow) {
            builder.append("...");
        }
        return builder.toString();
    }

    public static String bytes2Hex(ByteBuffer buffer) {
        return StringUtils.bytes2Hex(buffer, buffer.remaining());
    }

    public static String bytes2Hex(byte[] array) {
        return StringUtils.bytes2Hex(ByteBuffer.wrap(array));
    }

    public static String bytes2String(byte[] bytes) {
        return StringUtils.bytes2String(bytes, 0, bytes.length);
    }

    public static byte[] string2Bytes(String str) {
        return str.getBytes(UTF8);
    }

    public static String getLexicographicallyLowerString(String val) {
        int lastIdx;
        if (val == null || val.isEmpty()) {
            throw new IllegalArgumentException("Input string must not be null or empty");
        }
        char[] charVal = val.toCharArray();
        if (charVal[lastIdx = charVal.length - 1] == '\u0000') {
            throw new IllegalArgumentException("Cannot decrement character below Character.MIN_VALUE");
        }
        int n = lastIdx;
        charVal[n] = (char)(charVal[n] - '\u0001');
        return String.valueOf(charVal);
    }

    public static String getLexicographicallyHigherString(String val) {
        int lastIdx;
        if (val == null || val.isEmpty()) {
            throw new IllegalArgumentException("Input string must not be null or empty");
        }
        char[] charVal = val.toCharArray();
        if (charVal[lastIdx = charVal.length - 1] == '\uffff') {
            throw new IllegalArgumentException("Cannot increment character above Character.MAX_VALUE");
        }
        int n = lastIdx;
        charVal[n] = (char)(charVal[n] + '\u0001');
        return String.valueOf(charVal);
    }
}

