/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.CodecBuffer;
import org.apache.hadoop.hdds.utils.db.CodecException;
import org.apache.hadoop.hdds.utils.db.CopyObject;
import org.apache.ozone.shaded.jakarta.annotation.Nonnull;
import org.apache.ozone.shaded.org.apache.ratis.util.JavaUtils;
import org.apache.ozone.shaded.org.apache.ratis.util.function.CheckedFunction;

public class DelegatedCodec<T, DELEGATE>
implements Codec<T> {
    private final Codec<DELEGATE> delegate;
    private final CheckedFunction<DELEGATE, T, CodecException> forward;
    private final CheckedFunction<T, DELEGATE, CodecException> backward;
    private final Class<T> clazz;
    private final CopyType copyType;
    private final String name;

    public DelegatedCodec(Codec<DELEGATE> delegate, CheckedFunction<DELEGATE, T, CodecException> forward, CheckedFunction<T, DELEGATE, CodecException> backward, Class<T> clazz, CopyType copyType) {
        this.delegate = delegate;
        this.forward = forward;
        this.backward = backward;
        this.clazz = clazz;
        this.copyType = copyType;
        this.name = JavaUtils.getClassSimpleName(this.getTypeClass()) + "-delegate: " + delegate;
    }

    public DelegatedCodec(Codec<DELEGATE> delegate, CheckedFunction<DELEGATE, T, CodecException> forward, CheckedFunction<T, DELEGATE, CodecException> backward, Class<T> clazz) {
        this(delegate, forward, backward, clazz, CopyType.DEEP);
    }

    @Override
    public Class<T> getTypeClass() {
        return this.clazz;
    }

    @Override
    public final boolean supportCodecBuffer() {
        return this.delegate.supportCodecBuffer();
    }

    @Override
    public final CodecBuffer toCodecBuffer(@Nonnull T message, CodecBuffer.Allocator allocator) throws CodecException {
        return this.delegate.toCodecBuffer(this.backward.apply(message), allocator);
    }

    @Override
    public final T fromCodecBuffer(@Nonnull CodecBuffer buffer) throws CodecException {
        return this.forward.apply(this.delegate.fromCodecBuffer(buffer));
    }

    @Override
    public final byte[] toPersistedFormat(T message) throws CodecException {
        return this.delegate.toPersistedFormat(this.backward.apply(message));
    }

    @Override
    public final T fromPersistedFormat(byte[] bytes) throws CodecException {
        return this.forward.apply(this.delegate.fromPersistedFormat(bytes));
    }

    @Override
    public T copyObject(T message) {
        if (this.copyType == CopyType.SHALLOW) {
            return message;
        }
        if (this.copyType == CopyType.UNSUPPORTED) {
            throw new UnsupportedOperationException();
        }
        if (message instanceof CopyObject) {
            CopyObject casted = (CopyObject)message;
            return casted.copyObject();
        }
        try {
            return this.forward.apply(this.delegate.copyObject(this.backward.apply(message)));
        }
        catch (CodecException e) {
            throw new IllegalStateException("Failed to copyObject", e);
        }
    }

    public static <T, DELEGATE> DelegatedCodec<T, DELEGATE> decodeOnly(Codec<DELEGATE> delegate, CheckedFunction<DELEGATE, T, CodecException> forward, Class<T> clazz) {
        return new DelegatedCodec<T, DELEGATE>(delegate, forward, DelegatedCodec.unsupportedBackward(), clazz, CopyType.DEEP);
    }

    private static <A, B> CheckedFunction<A, B, CodecException> unsupportedBackward() {
        return a -> {
            throw new UnsupportedOperationException("Unsupported backward conversion");
        };
    }

    public String toString() {
        return this.name;
    }

    public static enum CopyType {
        DEEP,
        SHALLOW,
        UNSUPPORTED;

    }
}

