/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.hadoop.fs.StreamCapabilities;
import org.apache.hadoop.fs.Syncable;
import org.apache.ozone.shaded.jakarta.annotation.Nonnull;
import org.apache.ozone.shaded.org.apache.ratis.util.function.CheckedFunction;

public class SelectorOutputStream<OUT extends OutputStream>
extends OutputStream
implements Syncable,
StreamCapabilities {
    private final ByteArrayBuffer buffer;
    private final Underlying underlying;

    public SelectorOutputStream(int selectionThreshold, CheckedFunction<Integer, OUT, IOException> selector) {
        this.buffer = new ByteArrayBuffer(selectionThreshold);
        this.underlying = new Underlying(selector);
    }

    public OUT getUnderlying() {
        return (OUT)this.underlying.out;
    }

    @Override
    public void write(int b) throws IOException {
        OutputStream out = this.underlying.select(1, false);
        if (out != null) {
            out.write(b);
        } else {
            this.buffer.write((byte)b);
        }
    }

    @Override
    public void write(@Nonnull byte[] array, int off, int len) throws IOException {
        OutputStream selected = this.underlying.select(len, false);
        if (selected != null) {
            selected.write(array, off, len);
        } else {
            this.buffer.write(array, off, len);
        }
    }

    private OUT select() throws IOException {
        return (OUT)this.underlying.select(0, true);
    }

    @Override
    public void flush() throws IOException {
        ((OutputStream)this.select()).flush();
    }

    public void hflush() throws IOException {
        OUT out = this.select();
        if (!(out instanceof Syncable)) {
            throw new IllegalStateException("Failed to hflush: The underlying OutputStream (" + out.getClass() + ") is not Syncable.");
        }
        ((Syncable)out).hflush();
    }

    public void hsync() throws IOException {
        OUT out = this.select();
        if (!(out instanceof Syncable)) {
            throw new IllegalStateException("Failed to hsync: The underlying OutputStream (" + out.getClass() + ") is not Syncable.");
        }
        ((Syncable)out).hsync();
    }

    public boolean hasCapability(String capability) {
        try {
            OUT out = this.select();
            if (out instanceof StreamCapabilities) {
                return ((StreamCapabilities)out).hasCapability(capability);
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void close() throws IOException {
        ((OutputStream)this.select()).close();
    }

    static final class ByteArrayBuffer {
        private byte[] array;
        private int offset = 0;

        private ByteArrayBuffer(int capacity) {
            this.array = new byte[capacity];
        }

        private void assertRemaining(int outstandingBytes) {
            Objects.requireNonNull(this.array, "array == null");
            int remaining = this.array.length - this.offset;
            if (remaining < 0) {
                throw new IllegalStateException("remaining = " + remaining + " <= 0");
            }
            if (remaining < outstandingBytes) {
                throw new IllegalArgumentException("Buffer overflow: remaining = " + remaining + " < outstandingBytes = " + outstandingBytes);
            }
        }

        void write(byte b) {
            this.assertRemaining(1);
            this.array[this.offset] = b;
            ++this.offset;
        }

        void write(byte[] src, int srcOffset, int length) {
            Objects.requireNonNull(src, "src == null");
            this.assertRemaining(length);
            System.arraycopy(src, srcOffset, this.array, this.offset, length);
            this.offset += length;
        }

        <OUT extends OutputStream> OUT selectAndClose(int outstandingBytes, boolean force, CheckedFunction<Integer, OUT, IOException> selector) throws IOException {
            this.assertRemaining(0);
            int required = this.offset + outstandingBytes;
            if (force || required > this.array.length) {
                OutputStream out = (OutputStream)selector.apply(required);
                out.write(this.array, 0, this.offset);
                this.array = null;
                return (OUT)out;
            }
            return null;
        }
    }

    final class Underlying {
        private final CheckedFunction<Integer, OUT, IOException> selector;
        private OUT out;

        private Underlying(CheckedFunction<Integer, OUT, IOException> selector) {
            this.selector = selector;
        }

        private OUT select(int outstandingBytes, boolean force) throws IOException {
            if (this.out == null) {
                this.out = SelectorOutputStream.this.buffer.selectAndClose(outstandingBytes, force, this.selector);
            }
            return this.out;
        }
    }
}

