/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.common;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.hadoop.hdds.StringUtils;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.ozone.common.OzoneChecksumException;
import org.apache.ozone.shaded.net.jcip.annotations.Immutable;
import org.apache.ozone.shaded.org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ozone.shaded.org.apache.ratis.util.MemoizedSupplier;

@Immutable
public final class ChecksumData {
    private final ContainerProtos.ChecksumType type;
    private final int bytesPerChecksum;
    private final List<ByteString> checksums;
    private final Supplier<ContainerProtos.ChecksumData> protoSupplier;

    public ChecksumData(ContainerProtos.ChecksumType checksumType, int bytesPerChecksum) {
        this(checksumType, bytesPerChecksum, Collections.emptyList());
    }

    public ChecksumData(ContainerProtos.ChecksumType type, int bytesPerChecksum, List<ByteString> checksums) {
        this.type = Objects.requireNonNull(type, "type == null");
        this.bytesPerChecksum = bytesPerChecksum;
        this.checksums = Collections.unmodifiableList(checksums);
        this.protoSupplier = MemoizedSupplier.valueOf(() -> ContainerProtos.ChecksumData.newBuilder().setType(this.getChecksumType()).setBytesPerChecksum(this.getBytesPerChecksum()).addAllChecksums(this.getChecksums()).build());
    }

    public ContainerProtos.ChecksumType getChecksumType() {
        return this.type;
    }

    public int getBytesPerChecksum() {
        return this.bytesPerChecksum;
    }

    public List<ByteString> getChecksums() {
        return this.checksums;
    }

    public ContainerProtos.ChecksumData getProtoBufMessage() {
        return this.protoSupplier.get();
    }

    public static ChecksumData getFromProtoBuf(ContainerProtos.ChecksumData checksumDataProto) {
        Objects.requireNonNull(checksumDataProto, "checksumDataProto == null");
        return new ChecksumData(checksumDataProto.getType(), checksumDataProto.getBytesPerChecksum(), checksumDataProto.getChecksumsList());
    }

    public void verifyChecksumDataMatches(int thisStartIndex, ChecksumData that) throws OzoneChecksumException {
        int thisChecksumsCount = this.checksums.size();
        int thatChecksumsCount = that.checksums.size();
        if (thatChecksumsCount > thisChecksumsCount - thisStartIndex) {
            throw new OzoneChecksumException("Checksum count mismatched: thatChecksumsCount=" + thatChecksumsCount + " > thisChecksumsCount (=" + thisChecksumsCount + " ) - thisStartIndex (=" + thisStartIndex + ")");
        }
        for (int i = 0; i < thatChecksumsCount; ++i) {
            int j = i + thisStartIndex;
            if (this.checksums.get(j).equals(that.checksums.get(i))) continue;
            throw new OzoneChecksumException("Checksum mismatched: this.checksums(" + j + ") != that.checksums(" + i + "), thisStartIndex=" + thisStartIndex + ", this=" + this + ", that=" + that);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ChecksumData)) {
            return false;
        }
        ChecksumData that = (ChecksumData)obj;
        return Objects.equals(this.getChecksumType(), that.getChecksumType()) && Objects.equals(this.getBytesPerChecksum(), that.getBytesPerChecksum()) && Objects.equals(this.getChecksums(), that.getChecksums());
    }

    public int hashCode() {
        HashCodeBuilder hc = new HashCodeBuilder();
        hc.append(this.type);
        hc.append(this.bytesPerChecksum);
        hc.append(this.checksums.toArray());
        return hc.toHashCode();
    }

    public String toString() {
        StringBuilder b = new StringBuilder("ChecksumData{").append(this.type).append(", bytesPerChecksum=").append(this.bytesPerChecksum).append(", checksums=[");
        if (!this.checksums.isEmpty()) {
            for (ByteString checksum : this.checksums) {
                b.append(StringUtils.bytes2Hex(checksum.asReadOnlyByteBuffer())).append(", ");
            }
            b.setLength(b.length() - 2);
        }
        return b.append("]}").toString();
    }
}

