/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.ozone.om.S3Batcher;
import org.apache.hadoop.ozone.om.S3SecretCache;
import org.apache.hadoop.ozone.om.S3SecretFunction;
import org.apache.hadoop.ozone.om.helpers.S3SecretValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface S3SecretManager {
    public static final Logger LOG = LoggerFactory.getLogger(S3SecretManager.class);

    public S3SecretValue getSecret(String var1) throws IOException;

    public String getSecretString(String var1) throws IOException;

    public void storeSecret(String var1, S3SecretValue var2) throws IOException;

    public void revokeSecret(String var1) throws IOException;

    public void clearS3Cache(List<Long> var1);

    public <T> T doUnderLock(String var1, S3SecretFunction<T> var2) throws IOException;

    default public boolean hasS3Secret(String kerberosId) throws IOException {
        return this.getSecret(kerberosId) != null;
    }

    public S3Batcher batcher();

    default public boolean isBatchSupported() {
        return this.batcher() != null;
    }

    public S3SecretCache cache();

    default public void updateCache(String accessId, S3SecretValue secret) {
        S3SecretCache cache = this.cache();
        if (cache != null) {
            LOG.info("Updating cache for accessId/user: {}.", (Object)accessId);
            cache.put(accessId, secret);
        }
    }

    default public void invalidateCacheEntry(String id) {
        S3SecretCache cache = this.cache();
        if (cache != null) {
            cache.invalidate(id);
        }
    }

    default public void clearCache(List<Long> flushedTransactionIds) {
        S3SecretCache cache = this.cache();
        if (cache != null) {
            cache.clearCache(flushedTransactionIds);
        }
    }
}

