/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.io.opentelemetry.exporter.otlp.http.metrics;

import java.util.Collection;
import java.util.StringJoiner;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.http.HttpExporter;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.http.HttpExporterBuilder;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.marshal.Marshaler;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.otlp.metrics.MetricReusableDataMarshaler;
import org.apache.ozone.shaded.io.opentelemetry.exporter.otlp.http.metrics.OtlpHttpMetricExporterBuilder;
import org.apache.ozone.shaded.io.opentelemetry.sdk.common.CompletableResultCode;
import org.apache.ozone.shaded.io.opentelemetry.sdk.common.export.MemoryMode;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.Aggregation;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.InstrumentType;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.data.MetricData;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.export.AggregationTemporalitySelector;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.export.DefaultAggregationSelector;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.export.MetricExporter;

@ThreadSafe
public final class OtlpHttpMetricExporter
implements MetricExporter {
    private final HttpExporterBuilder<Marshaler> builder;
    private final HttpExporter<Marshaler> delegate;
    final AggregationTemporalitySelector aggregationTemporalitySelector;
    final DefaultAggregationSelector defaultAggregationSelector;
    private final MetricReusableDataMarshaler marshaler;

    OtlpHttpMetricExporter(HttpExporterBuilder<Marshaler> builder, HttpExporter<Marshaler> delegate, AggregationTemporalitySelector aggregationTemporalitySelector, DefaultAggregationSelector defaultAggregationSelector, MemoryMode memoryMode) {
        this.builder = builder;
        this.delegate = delegate;
        this.aggregationTemporalitySelector = aggregationTemporalitySelector;
        this.defaultAggregationSelector = defaultAggregationSelector;
        this.marshaler = new MetricReusableDataMarshaler(memoryMode, delegate::export);
    }

    public static OtlpHttpMetricExporter getDefault() {
        return OtlpHttpMetricExporter.builder().build();
    }

    public static OtlpHttpMetricExporterBuilder builder() {
        return new OtlpHttpMetricExporterBuilder();
    }

    public OtlpHttpMetricExporterBuilder toBuilder() {
        return new OtlpHttpMetricExporterBuilder(this.builder.copy(), this.aggregationTemporalitySelector, this.defaultAggregationSelector, this.marshaler.getMemoryMode());
    }

    @Override
    public AggregationTemporality getAggregationTemporality(InstrumentType instrumentType) {
        return this.aggregationTemporalitySelector.getAggregationTemporality(instrumentType);
    }

    @Override
    public Aggregation getDefaultAggregation(InstrumentType instrumentType) {
        return this.defaultAggregationSelector.getDefaultAggregation(instrumentType);
    }

    @Override
    public MemoryMode getMemoryMode() {
        return this.marshaler.getMemoryMode();
    }

    @Override
    public CompletableResultCode export(Collection<MetricData> metrics) {
        return this.marshaler.export(metrics);
    }

    @Override
    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode shutdown() {
        return this.delegate.shutdown();
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", "OtlpHttpMetricExporter{", "}");
        joiner.add(this.builder.toString(false));
        joiner.add("aggregationTemporalitySelector=" + AggregationTemporalitySelector.asString(this.aggregationTemporalitySelector));
        joiner.add("defaultAggregationSelector=" + DefaultAggregationSelector.asString(this.defaultAggregationSelector));
        joiner.add("memoryMode=" + (Object)((Object)this.marshaler.getMemoryMode()));
        return joiner.toString();
    }
}

