/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.io.opentelemetry.sdk.internal;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.ozone.shaded.io.opentelemetry.sdk.internal.ExceptionAttributeResolver;
import org.apache.ozone.shaded.io.opentelemetry.sdk.internal.StackTraceRenderer;

final class DefaultExceptionAttributeResolver
implements ExceptionAttributeResolver {
    static final String ENABLE_JVM_STACKTRACE_PROPERTY = "otel.experimental.sdk.jvm_stacktrace";
    private final boolean jvmStacktraceEnabled;

    DefaultExceptionAttributeResolver(boolean jvmStacktraceEnabled) {
        this.jvmStacktraceEnabled = jvmStacktraceEnabled;
    }

    @Override
    public void setExceptionAttributes(ExceptionAttributeResolver.AttributeSetter attributeSetter, Throwable throwable, int maxAttributeLength) {
        String exceptionMessage;
        String exceptionType = throwable.getClass().getCanonicalName();
        if (exceptionType != null) {
            attributeSetter.setAttribute(ExceptionAttributeResolver.EXCEPTION_TYPE, exceptionType);
        }
        if ((exceptionMessage = throwable.getMessage()) != null) {
            attributeSetter.setAttribute(ExceptionAttributeResolver.EXCEPTION_MESSAGE, exceptionMessage);
        }
        String exceptionStacktrace = this.jvmStacktraceEnabled ? DefaultExceptionAttributeResolver.jvmStacktrace(throwable) : DefaultExceptionAttributeResolver.limitsAwareStacktrace(throwable, maxAttributeLength);
        attributeSetter.setAttribute(ExceptionAttributeResolver.EXCEPTION_STACKTRACE, exceptionStacktrace);
    }

    private static String jvmStacktrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        try (PrintWriter printWriter = new PrintWriter(stringWriter);){
            throwable.printStackTrace(printWriter);
        }
        return stringWriter.toString();
    }

    private static String limitsAwareStacktrace(Throwable throwable, int maxAttributeLength) {
        return new StackTraceRenderer(throwable, maxAttributeLength).render();
    }
}

