/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.io.opentelemetry.sdk.metrics;

import java.util.function.Consumer;
import org.apache.ozone.shaded.io.opentelemetry.api.common.Attributes;
import org.apache.ozone.shaded.io.opentelemetry.api.metrics.LongGauge;
import org.apache.ozone.shaded.io.opentelemetry.api.metrics.LongGaugeBuilder;
import org.apache.ozone.shaded.io.opentelemetry.api.metrics.ObservableLongGauge;
import org.apache.ozone.shaded.io.opentelemetry.api.metrics.ObservableLongMeasurement;
import org.apache.ozone.shaded.io.opentelemetry.context.Context;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.AbstractInstrument;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.InstrumentBuilder;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.InstrumentType;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.InstrumentValueType;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.SdkMeter;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.internal.descriptor.Advice;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;

class SdkLongGauge
extends AbstractInstrument
implements LongGauge {
    final SdkMeter sdkMeter;
    final WriteableMetricStorage storage;

    SdkLongGauge(InstrumentDescriptor descriptor, SdkMeter sdkMeter, WriteableMetricStorage storage) {
        super(descriptor);
        this.sdkMeter = sdkMeter;
        this.storage = storage;
    }

    @Override
    public void set(long value, Attributes attributes) {
        this.storage.recordLong(value, attributes, Context.current());
    }

    @Override
    public void set(long value, Attributes attributes, Context context) {
        this.storage.recordLong(value, attributes, context);
    }

    @Override
    public void set(long value) {
        this.set(value, Attributes.empty());
    }

    static class SdkLongGaugeBuilder
    implements LongGaugeBuilder {
        final InstrumentBuilder builder;

        SdkLongGaugeBuilder(SdkMeter sdkMeter, String name, String description, String unit, Advice.AdviceBuilder adviceBuilder) {
            this.builder = new InstrumentBuilder(name, InstrumentType.GAUGE, InstrumentValueType.LONG, sdkMeter).setDescription(description).setUnit(unit).setAdviceBuilder(adviceBuilder);
        }

        @Override
        public LongGaugeBuilder setDescription(String description) {
            this.builder.setDescription(description);
            return this;
        }

        @Override
        public LongGaugeBuilder setUnit(String unit) {
            this.builder.setUnit(unit);
            return this;
        }

        @Override
        public SdkLongGauge build() {
            return this.builder.buildSynchronousInstrument(SdkLongGauge::new);
        }

        @Override
        public ObservableLongGauge buildWithCallback(Consumer<ObservableLongMeasurement> callback) {
            return this.builder.buildLongAsynchronousInstrument(InstrumentType.OBSERVABLE_GAUGE, callback);
        }

        @Override
        public ObservableLongMeasurement buildObserver() {
            return this.builder.buildObservableMeasurement(InstrumentType.OBSERVABLE_GAUGE);
        }

        public String toString() {
            return this.builder.toStringHelper(this.getClass().getSimpleName());
        }
    }
}

