/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.internal.aggregator;

import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.ozone.shaded.io.opentelemetry.api.common.Attributes;
import org.apache.ozone.shaded.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import org.apache.ozone.shaded.io.opentelemetry.sdk.common.export.MemoryMode;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.data.LongExemplarData;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.data.LongPointData;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.data.MetricData;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.AbstractSumAggregator;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorHandle;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.internal.concurrent.AdderUtil;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.internal.concurrent.LongAdder;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.internal.data.ImmutableLongPointData;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.internal.data.ImmutableMetricData;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.internal.data.ImmutableSumData;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.internal.data.MutableLongPointData;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarReservoir;
import org.apache.ozone.shaded.io.opentelemetry.sdk.resources.Resource;

public final class LongSumAggregator
extends AbstractSumAggregator<LongPointData, LongExemplarData> {
    private final Supplier<ExemplarReservoir<LongExemplarData>> reservoirSupplier;
    private final MemoryMode memoryMode;

    public LongSumAggregator(InstrumentDescriptor instrumentDescriptor, Supplier<ExemplarReservoir<LongExemplarData>> reservoirSupplier, MemoryMode memoryMode) {
        super(instrumentDescriptor);
        this.reservoirSupplier = reservoirSupplier;
        this.memoryMode = memoryMode;
    }

    @Override
    public AggregatorHandle<LongPointData, LongExemplarData> createHandle() {
        return new Handle(this.reservoirSupplier.get(), this.memoryMode);
    }

    @Override
    public LongPointData diff(LongPointData previousPoint, LongPointData currentPoint) {
        return ImmutableLongPointData.create(currentPoint.getStartEpochNanos(), currentPoint.getEpochNanos(), currentPoint.getAttributes(), currentPoint.getValue() - previousPoint.getValue(), currentPoint.getExemplars());
    }

    @Override
    public void diffInPlace(LongPointData previousReusablePoint, LongPointData currentPoint) {
        ((MutableLongPointData)previousReusablePoint).set(currentPoint.getStartEpochNanos(), currentPoint.getEpochNanos(), currentPoint.getAttributes(), currentPoint.getValue() - previousReusablePoint.getValue(), currentPoint.getExemplars());
    }

    @Override
    public LongPointData createReusablePoint() {
        return new MutableLongPointData();
    }

    @Override
    public void copyPoint(LongPointData point, LongPointData toReusablePoint) {
        ((MutableLongPointData)toReusablePoint).set(point);
    }

    @Override
    public MetricData toMetricData(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, MetricDescriptor descriptor, Collection<LongPointData> points, AggregationTemporality temporality) {
        return ImmutableMetricData.createLongSum(resource, instrumentationScopeInfo, descriptor.getName(), descriptor.getDescription(), descriptor.getSourceInstrument().getUnit(), ImmutableSumData.create(this.isMonotonic(), temporality, points));
    }

    static final class Handle
    extends AggregatorHandle<LongPointData, LongExemplarData> {
        private final LongAdder current = AdderUtil.createLongAdder();
        @Nullable
        private final MutableLongPointData reusablePointData;

        Handle(ExemplarReservoir<LongExemplarData> exemplarReservoir, MemoryMode memoryMode) {
            super(exemplarReservoir);
            this.reusablePointData = memoryMode == MemoryMode.REUSABLE_DATA ? new MutableLongPointData() : null;
        }

        @Override
        protected LongPointData doAggregateThenMaybeReset(long startEpochNanos, long epochNanos, Attributes attributes, List<LongExemplarData> exemplars, boolean reset) {
            long value;
            long l = value = reset ? this.current.sumThenReset() : this.current.sum();
            if (this.reusablePointData != null) {
                this.reusablePointData.set(startEpochNanos, epochNanos, attributes, value, exemplars);
                return this.reusablePointData;
            }
            return ImmutableLongPointData.create(startEpochNanos, epochNanos, attributes, value, exemplars);
        }

        @Override
        public void doRecordLong(long value) {
            this.current.add(value);
        }
    }
}

