/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.internal.state;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ozone.shaded.io.opentelemetry.api.common.Attributes;
import org.apache.ozone.shaded.io.opentelemetry.context.Context;
import org.apache.ozone.shaded.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import org.apache.ozone.shaded.io.opentelemetry.sdk.common.export.MemoryMode;
import org.apache.ozone.shaded.io.opentelemetry.sdk.internal.ThrottlingLogger;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.View;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.data.ExemplarData;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.data.MetricData;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.data.PointData;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorFactory;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorHandle;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarFilter;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.internal.export.RegisteredReader;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.internal.state.MetricStorage;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.internal.state.ObjectPool;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.internal.state.PooledHashMap;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.internal.view.AttributesProcessor;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.internal.view.RegisteredView;
import org.apache.ozone.shaded.io.opentelemetry.sdk.resources.Resource;

public final class AsynchronousMetricStorage<T extends PointData, U extends ExemplarData>
implements MetricStorage {
    private static final Logger logger = Logger.getLogger(AsynchronousMetricStorage.class.getName());
    private final ThrottlingLogger throttlingLogger = new ThrottlingLogger(logger);
    private final RegisteredReader registeredReader;
    private final MetricDescriptor metricDescriptor;
    private final AggregationTemporality aggregationTemporality;
    private final Aggregator<T, U> aggregator;
    private final AttributesProcessor attributesProcessor;
    private final MemoryMode memoryMode;
    private final int maxCardinality;
    private final Map<Attributes, AggregatorHandle<T, U>> aggregatorHandles;
    private Map<Attributes, T> lastPoints;
    private final ObjectPool<T> reusablePointsPool;
    private final ObjectPool<AggregatorHandle<T, U>> reusableHandlesPool;
    private final Function<Attributes, AggregatorHandle<T, U>> handleBuilder;
    private final BiConsumer<Attributes, AggregatorHandle<T, U>> handleReleaser;
    private final BiConsumer<Attributes, T> pointReleaser;
    private final List<T> reusablePointsList = new ArrayList<T>();
    private Map<Attributes, T> reusablePointsMap = new PooledHashMap<Attributes, T>();
    private long startEpochNanos;
    private long epochNanos;

    private AsynchronousMetricStorage(RegisteredReader registeredReader, MetricDescriptor metricDescriptor, Aggregator<T, U> aggregator, AttributesProcessor attributesProcessor, int maxCardinality) {
        this.registeredReader = registeredReader;
        this.metricDescriptor = metricDescriptor;
        this.aggregationTemporality = registeredReader.getReader().getAggregationTemporality(metricDescriptor.getSourceInstrument().getType());
        this.memoryMode = registeredReader.getReader().getMemoryMode();
        this.aggregator = aggregator;
        this.attributesProcessor = attributesProcessor;
        this.maxCardinality = maxCardinality - 1;
        this.reusablePointsPool = new ObjectPool<PointData>(aggregator::createReusablePoint);
        this.reusableHandlesPool = new ObjectPool<AggregatorHandle>(aggregator::createHandle);
        this.handleBuilder = ignored -> this.reusableHandlesPool.borrowObject();
        this.handleReleaser = (ignored, handle) -> this.reusableHandlesPool.returnObject((AggregatorHandle<AggregatorHandle, U>)handle);
        this.pointReleaser = (ignored, point) -> this.reusablePointsPool.returnObject((PointData)point);
        if (this.memoryMode == MemoryMode.REUSABLE_DATA) {
            this.lastPoints = new PooledHashMap<Attributes, T>();
            this.aggregatorHandles = new PooledHashMap<Attributes, AggregatorHandle<T, U>>();
        } else {
            this.lastPoints = new HashMap<Attributes, T>();
            this.aggregatorHandles = new HashMap<Attributes, AggregatorHandle<T, U>>();
        }
    }

    public static <T extends PointData, U extends ExemplarData> AsynchronousMetricStorage<T, U> create(RegisteredReader registeredReader, RegisteredView registeredView, InstrumentDescriptor instrumentDescriptor) {
        View view = registeredView.getView();
        MetricDescriptor metricDescriptor = MetricDescriptor.create(view, registeredView.getViewSourceInfo(), instrumentDescriptor);
        Aggregator aggregator = ((AggregatorFactory)((Object)view.getAggregation())).createAggregator(instrumentDescriptor, ExemplarFilter.alwaysOff(), registeredReader.getReader().getMemoryMode());
        return new AsynchronousMetricStorage(registeredReader, metricDescriptor, aggregator, registeredView.getViewAttributesProcessor(), registeredView.getCardinalityLimit());
    }

    void record(Attributes attributes, long value) {
        attributes = this.validateAndProcessAttributes(attributes);
        AggregatorHandle<T, U> handle = this.aggregatorHandles.computeIfAbsent(attributes, this.handleBuilder);
        handle.recordLong(value, attributes, Context.current());
    }

    void record(Attributes attributes, double value) {
        attributes = this.validateAndProcessAttributes(attributes);
        AggregatorHandle<T, U> handle = this.aggregatorHandles.computeIfAbsent(attributes, this.handleBuilder);
        handle.recordDouble(value, attributes, Context.current());
    }

    void setEpochInformation(long startEpochNanos, long epochNanos) {
        this.startEpochNanos = this.aggregationTemporality == AggregationTemporality.DELTA ? this.registeredReader.getLastCollectEpochNanos() : startEpochNanos;
        this.epochNanos = epochNanos;
    }

    private Attributes validateAndProcessAttributes(Attributes attributes) {
        if (this.aggregatorHandles.size() >= this.maxCardinality) {
            this.throttlingLogger.log(Level.WARNING, "Instrument " + this.metricDescriptor.getSourceInstrument().getName() + " has exceeded the maximum allowed cardinality (" + this.maxCardinality + ").");
            return MetricStorage.CARDINALITY_OVERFLOW;
        }
        Context context = Context.current();
        attributes = this.attributesProcessor.process(attributes, context);
        return attributes;
    }

    @Override
    public MetricDescriptor getMetricDescriptor() {
        return this.metricDescriptor;
    }

    public RegisteredReader getRegisteredReader() {
        return this.registeredReader;
    }

    @Override
    public MetricData collect(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, long startEpochNanos, long epochNanos) {
        Collection<T> result2 = this.aggregationTemporality == AggregationTemporality.DELTA ? this.collectWithDeltaAggregationTemporality() : this.collectWithCumulativeAggregationTemporality();
        this.aggregatorHandles.forEach(this.handleReleaser);
        this.aggregatorHandles.clear();
        return this.aggregator.toMetricData(resource, instrumentationScopeInfo, this.metricDescriptor, result2, this.aggregationTemporality);
    }

    private Collection<T> collectWithDeltaAggregationTemporality() {
        Map<Object, Object> currentPoints;
        if (this.memoryMode == MemoryMode.REUSABLE_DATA) {
            this.reusablePointsList.forEach(this.reusablePointsPool::returnObject);
            this.reusablePointsList.clear();
            currentPoints = this.reusablePointsMap;
        } else {
            currentPoints = new HashMap();
        }
        this.aggregatorHandles.forEach((attributes, handle) -> {
            Object pointForCurrentPoints;
            Object point = handle.aggregateThenMaybeReset(this.startEpochNanos, this.epochNanos, (Attributes)attributes, true);
            if (this.memoryMode == MemoryMode.REUSABLE_DATA) {
                pointForCurrentPoints = (PointData)this.reusablePointsPool.borrowObject();
                this.aggregator.copyPoint(point, pointForCurrentPoints);
            } else {
                pointForCurrentPoints = point;
            }
            currentPoints.put(attributes, pointForCurrentPoints);
        });
        ArrayList deltaPoints = this.memoryMode == MemoryMode.REUSABLE_DATA ? this.reusablePointsList : new ArrayList();
        currentPoints.forEach((attributes, currentPoint) -> {
            PointData deltaPoint;
            PointData lastPoint = (PointData)this.lastPoints.remove(attributes);
            if (lastPoint == null) {
                if (this.memoryMode == MemoryMode.REUSABLE_DATA) {
                    deltaPoint = (PointData)this.reusablePointsPool.borrowObject();
                    this.aggregator.copyPoint((PointData)currentPoint, deltaPoint);
                } else {
                    deltaPoint = currentPoint;
                }
            } else if (this.memoryMode == MemoryMode.REUSABLE_DATA) {
                this.aggregator.diffInPlace(lastPoint, (PointData)currentPoint);
                deltaPoint = lastPoint;
            } else {
                deltaPoint = this.aggregator.diff(lastPoint, (PointData)currentPoint);
            }
            deltaPoints.add(deltaPoint);
        });
        if (this.memoryMode == MemoryMode.REUSABLE_DATA) {
            this.lastPoints.forEach(this.pointReleaser);
            this.lastPoints.clear();
            Map<Attributes, T> tmp = this.lastPoints;
            this.lastPoints = this.reusablePointsMap;
            this.reusablePointsMap = tmp;
        } else {
            this.lastPoints = currentPoints;
        }
        return deltaPoints;
    }

    private Collection<T> collectWithCumulativeAggregationTemporality() {
        List<Object> currentPoints;
        if (this.memoryMode == MemoryMode.REUSABLE_DATA) {
            this.reusablePointsList.clear();
            currentPoints = this.reusablePointsList;
        } else {
            currentPoints = new ArrayList();
        }
        this.aggregatorHandles.forEach((attributes, handle) -> {
            Object value = handle.aggregateThenMaybeReset(this.startEpochNanos, this.epochNanos, (Attributes)attributes, true);
            currentPoints.add(value);
        });
        return currentPoints;
    }

    @Override
    public boolean isEmpty() {
        return this.aggregator == Aggregator.drop();
    }
}

