/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.org.apache.ratis.client.impl;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ozone.shaded.org.apache.ratis.client.RaftClientConfigKeys;
import org.apache.ozone.shaded.org.apache.ratis.client.api.MessageOutputStream;
import org.apache.ozone.shaded.org.apache.ratis.client.api.MessageStreamApi;
import org.apache.ozone.shaded.org.apache.ratis.client.impl.RaftClientImpl;
import org.apache.ozone.shaded.org.apache.ratis.conf.RaftProperties;
import org.apache.ozone.shaded.org.apache.ratis.protocol.Message;
import org.apache.ozone.shaded.org.apache.ratis.protocol.RaftClientReply;
import org.apache.ozone.shaded.org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ozone.shaded.org.apache.ratis.util.SizeInBytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MessageStreamImpl
implements MessageStreamApi {
    public static final Logger LOG = LoggerFactory.getLogger(MessageStreamImpl.class);
    private final RaftClientImpl client;
    private final SizeInBytes submessageSize;
    private final AtomicLong streamId = new AtomicLong();

    static MessageStreamImpl newInstance(RaftClientImpl client, RaftProperties properties) {
        return new MessageStreamImpl(client, properties);
    }

    private MessageStreamImpl(RaftClientImpl client, RaftProperties properties) {
        this.client = Objects.requireNonNull(client, "client == null");
        this.submessageSize = RaftClientConfigKeys.MessageStream.submessageSize(properties);
    }

    @Override
    public MessageOutputStream stream() {
        return new MessageOutputStreamImpl(this.streamId.incrementAndGet());
    }

    @Override
    public CompletableFuture<RaftClientReply> streamAsync(Message message, SizeInBytes subSize) {
        int n = subSize.getSizeInt();
        MessageOutputStream out = this.stream();
        ByteString bytes = message.getContent();
        int i = 0;
        while (i < bytes.size()) {
            int j = Math.min(i + n, bytes.size());
            ByteString sub = bytes.substring(i, j);
            out.sendAsync(Message.valueOf(sub));
            i = j;
        }
        return out.closeAsync();
    }

    @Override
    public CompletableFuture<RaftClientReply> streamAsync(Message message) {
        return this.streamAsync(message, this.submessageSize);
    }

    class MessageOutputStreamImpl
    implements MessageOutputStream {
        private final long id;
        private final AtomicLong messageId = new AtomicLong();

        MessageOutputStreamImpl(long id) {
            this.id = id;
        }

        private RaftClientRequest.Type getMessageStreamRequestType(boolean endOfRequest) {
            return RaftClientRequest.messageStreamRequestType(this.id, this.messageId.getAndIncrement(), endOfRequest);
        }

        @Override
        public CompletableFuture<RaftClientReply> sendAsync(Message message, boolean endOfRequest) {
            return MessageStreamImpl.this.client.async().send(this.getMessageStreamRequestType(endOfRequest), message, null);
        }

        @Override
        public CompletableFuture<RaftClientReply> closeAsync() {
            return MessageStreamImpl.this.client.async().send(this.getMessageStreamRequestType(true), null, null);
        }
    }
}

