/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.org.apache.ratis.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public class MD5Hash {
    public static final int MD5_LEN = 16;
    private static final ThreadLocal<MessageDigest> DIGESTER_FACTORY = ThreadLocal.withInitial(MD5Hash::newDigester);
    private byte[] digest;
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static MessageDigest newDigester() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Failed to create MessageDigest for MD5", e);
        }
    }

    public MD5Hash() {
        this.digest = new byte[16];
    }

    public MD5Hash(String hex) {
        this.setDigest(hex);
    }

    public MD5Hash(byte[] digest) {
        if (digest.length != 16) {
            throw new IllegalArgumentException("Wrong length: " + digest.length);
        }
        this.digest = (byte[])digest.clone();
    }

    public void readFields(DataInput in) throws IOException {
        in.readFully(this.digest);
    }

    public static MD5Hash read(DataInput in) throws IOException {
        MD5Hash result2 = new MD5Hash();
        result2.readFields(in);
        return result2;
    }

    public void write(DataOutput out) throws IOException {
        out.write(this.digest);
    }

    public void set(MD5Hash that) {
        System.arraycopy(that.digest, 0, this.digest, 0, 16);
    }

    public byte[] getDigest() {
        return (byte[])this.digest.clone();
    }

    public static MD5Hash digest(byte[] data) {
        return MD5Hash.digest(data, 0, data.length);
    }

    public static MessageDigest getDigester() {
        MessageDigest digester = DIGESTER_FACTORY.get();
        digester.reset();
        return digester;
    }

    public static MD5Hash digest(InputStream in) throws IOException {
        int n;
        byte[] buffer = new byte[4096];
        MessageDigest digester = MD5Hash.getDigester();
        while ((n = in.read(buffer)) != -1) {
            digester.update(buffer, 0, n);
        }
        return new MD5Hash(digester.digest());
    }

    public static MD5Hash digest(byte[] data, int start, int len) {
        MessageDigest digester = MD5Hash.getDigester();
        digester.update(data, start, len);
        byte[] digest = digester.digest();
        return new MD5Hash(digest);
    }

    public static MD5Hash digest(byte[][] dataArr, int start, int len) {
        MessageDigest digester = MD5Hash.getDigester();
        for (byte[] data : dataArr) {
            digester.update(data, start, len);
        }
        byte[] digest = digester.digest();
        return new MD5Hash(digest);
    }

    public long halfDigest() {
        long value = 0L;
        for (int i = 0; i < 8; ++i) {
            value |= ((long)this.digest[i] & 0xFFL) << 8 * (7 - i);
        }
        return value;
    }

    public int quarterDigest() {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            value |= (this.digest[i] & 0xFF) << 8 * (3 - i);
        }
        return value;
    }

    public boolean equals(Object o) {
        if (!(o instanceof MD5Hash)) {
            return false;
        }
        MD5Hash other = (MD5Hash)o;
        return Arrays.equals(this.digest, other.digest);
    }

    public int hashCode() {
        return this.quarterDigest();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(32);
        for (int i = 0; i < 16; ++i) {
            byte b = this.digest[i];
            buf.append(HEX_DIGITS[b >> 4 & 0xF]);
            buf.append(HEX_DIGITS[b & 0xF]);
        }
        return buf.toString();
    }

    public void setDigest(String hex) {
        if (hex.length() != 32) {
            throw new IllegalArgumentException("Wrong length: " + hex.length());
        }
        this.digest = new byte[16];
        for (int i = 0; i < 16; ++i) {
            int j = i << 1;
            this.digest[i] = (byte)(MD5Hash.charToNibble(hex.charAt(j)) << 4 | MD5Hash.charToNibble(hex.charAt(j + 1)));
        }
    }

    private static int charToNibble(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return 10 + (c - 97);
        }
        if (c >= 'A' && c <= 'F') {
            return 10 + (c - 65);
        }
        throw new RuntimeException("Not a hex character: " + c);
    }
}

