/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.org.apache.ratis.metrics.dropwizard3;

import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.ozone.shaded.com.codahale.metrics.ConsoleReporter;
import org.apache.ozone.shaded.com.codahale.metrics.Counter;
import org.apache.ozone.shaded.com.codahale.metrics.Gauge;
import org.apache.ozone.shaded.com.codahale.metrics.JmxReporter;
import org.apache.ozone.shaded.com.codahale.metrics.Metric;
import org.apache.ozone.shaded.com.codahale.metrics.MetricFilter;
import org.apache.ozone.shaded.com.codahale.metrics.MetricRegistry;
import org.apache.ozone.shaded.com.codahale.metrics.MetricSet;
import org.apache.ozone.shaded.org.apache.ratis.metrics.LongCounter;
import org.apache.ozone.shaded.org.apache.ratis.metrics.MetricRegistryInfo;
import org.apache.ozone.shaded.org.apache.ratis.metrics.RatisMetricRegistry;
import org.apache.ozone.shaded.org.apache.ratis.metrics.Timekeeper;
import org.apache.ozone.shaded.org.apache.ratis.metrics.dropwizard3.Dm3TimekeeperImpl;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.com.google.common.annotations.VisibleForTesting;

public class Dm3RatisMetricRegistryImpl
implements RatisMetricRegistry {
    private final MetricRegistry metricRegistry = new MetricRegistry();
    private final MetricRegistryInfo info;
    private final String namePrefix;
    private final Map<String, String> metricNameCache = new ConcurrentHashMap<String, String>();
    private JmxReporter jmxReporter;
    private ConsoleReporter consoleReporter;

    static Dm3RatisMetricRegistryImpl cast(RatisMetricRegistry registry) {
        if (!(registry instanceof Dm3RatisMetricRegistryImpl)) {
            throw new IllegalStateException("Unexpected class: " + registry.getClass().getName());
        }
        return (Dm3RatisMetricRegistryImpl)registry;
    }

    public Dm3RatisMetricRegistryImpl(MetricRegistryInfo info) {
        this.info = Objects.requireNonNull(info, "org.apache.ozone.shaded.info == null");
        this.namePrefix = MetricRegistry.name(info.getApplicationName(), info.getMetricsComponentName(), info.getPrefix());
    }

    @Override
    public Timekeeper timer(String name) {
        return new Dm3TimekeeperImpl(this.metricRegistry.timer(this.getMetricName(name)));
    }

    static LongCounter toLongCounter(final Counter c) {
        return new LongCounter(){

            @Override
            public void inc(long n) {
                c.inc(n);
            }

            @Override
            public void dec(long n) {
                c.dec(n);
            }

            @Override
            public long getCount() {
                return c.getCount();
            }
        };
    }

    @Override
    public LongCounter counter(String name) {
        return Dm3RatisMetricRegistryImpl.toLongCounter(this.metricRegistry.counter(this.getMetricName(name)));
    }

    @Override
    public boolean remove(String name) {
        return this.metricRegistry.remove(this.getMetricName(name));
    }

    static <T> Gauge<T> toGauge(Supplier<T> supplier) {
        return supplier::get;
    }

    @Override
    public <T> void gauge(String name, Supplier<Supplier<T>> gaugeSupplier) {
        this.metricRegistry.gauge(this.getMetricName(name), () -> Dm3RatisMetricRegistryImpl.toGauge((Supplier)gaugeSupplier.get()));
    }

    public SortedMap<String, Gauge> getGauges(MetricFilter filter) {
        return this.metricRegistry.getGauges(filter);
    }

    @VisibleForTesting
    public Metric get(String shortName) {
        return this.metricRegistry.getMetrics().get(this.getMetricName(shortName));
    }

    private String getMetricName(String shortName) {
        return this.metricNameCache.computeIfAbsent(shortName, key -> MetricRegistry.name(this.namePrefix, shortName));
    }

    private <T extends Metric> T register(String name, T metric) throws IllegalArgumentException {
        return this.metricRegistry.register(this.getMetricName(name), metric);
    }

    public MetricRegistry getDropWizardMetricRegistry() {
        return this.metricRegistry;
    }

    @Override
    public MetricRegistryInfo getMetricRegistryInfo() {
        return this.info;
    }

    void registerAll(String prefix, MetricSet metricSet) {
        for (Map.Entry<String, Metric> entry : metricSet.getMetrics().entrySet()) {
            if (entry.getValue() instanceof MetricSet) {
                this.registerAll(prefix + "." + entry.getKey(), (MetricSet)entry.getValue());
                continue;
            }
            this.register(prefix + "." + entry.getKey(), entry.getValue());
        }
    }

    void setJmxReporter(JmxReporter jmxReporter) {
        this.jmxReporter = jmxReporter;
    }

    JmxReporter getJmxReporter() {
        return this.jmxReporter;
    }

    void setConsoleReporter(ConsoleReporter consoleReporter) {
        this.consoleReporter = consoleReporter;
    }

    ConsoleReporter getConsoleReporter() {
        return this.consoleReporter;
    }
}

