/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.org.apache.ratis.netty.metrics;

import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.ozone.shaded.org.apache.ratis.metrics.LongCounter;
import org.apache.ozone.shaded.org.apache.ratis.metrics.MetricRegistryInfo;
import org.apache.ozone.shaded.org.apache.ratis.metrics.RatisMetricRegistry;
import org.apache.ozone.shaded.org.apache.ratis.metrics.RatisMetrics;
import org.apache.ozone.shaded.org.apache.ratis.metrics.Timekeeper;

public class NettyServerStreamRpcMetrics
extends RatisMetrics {
    private static final String METRICS_APP_NAME = "ratis_netty";
    private static final String METRICS_COMP_NAME = "stream_server";
    private static final String METRICS_DESC = "Metrics for Ratis Netty Stream Server";
    private static final String METRICS_LATENCY = "%s_latency";
    private static final String METRICS_SUCCESS = "%s_success_reply_count";
    private static final String METRICS_FAIL = "%s_fail_reply_count";
    private static final String METRICS_NUM_REQUESTS = "num_requests_%s";
    private final Map<String, Timekeeper> latencyTimers = new ConcurrentHashMap<String, Timekeeper>();
    private final Map<Op, Map<String, LongCounter>> ops = NettyServerStreamRpcMetrics.newCounterMaps(Op.class);

    public NettyServerStreamRpcMetrics(String serverId) {
        super(NettyServerStreamRpcMetrics.createRegistry(serverId));
    }

    private static RatisMetricRegistry createRegistry(String serverId) {
        return NettyServerStreamRpcMetrics.create(new MetricRegistryInfo(serverId, METRICS_APP_NAME, METRICS_COMP_NAME, METRICS_DESC));
    }

    public RequestMetrics newRequestMetrics(RequestType type) {
        return new RequestMetrics(type);
    }

    public Timekeeper getLatencyTimer(RequestType type) {
        return this.latencyTimers.computeIfAbsent(type.getLatencyString(), this.getRegistry()::timer);
    }

    private void inc(Op op, RequestType type) {
        this.ops.get((Object)op).computeIfAbsent(op.getString(type), this.getRegistry()::counter).inc();
    }

    public void onRequestCreate(RequestType type) {
        this.inc(Op.Create, type);
    }

    public void onRequestSuccess(RequestType type) {
        this.inc(Op.Success, type);
    }

    public void onRequestFail(RequestType type) {
        this.inc(Op.Fail, type);
    }

    private static enum Op {
        Create(RequestType::getNumRequestsString),
        Success(RequestType::getSuccessCountString),
        Fail(RequestType::getFailCountString);

        private final Function<RequestType, String> stringFunction;

        private Op(Function<RequestType, String> stringFunction) {
            this.stringFunction = stringFunction;
        }

        String getString(RequestType type) {
            return this.stringFunction.apply(type);
        }
    }

    public final class RequestMetrics {
        private final RequestType type;
        private final Timekeeper timer;

        private RequestMetrics(RequestType type) {
            this.type = type;
            this.timer = NettyServerStreamRpcMetrics.this.getLatencyTimer(type);
        }

        public Timekeeper.Context start() {
            NettyServerStreamRpcMetrics.this.onRequestCreate(this.type);
            return this.timer.time();
        }

        public void stop(Timekeeper.Context context, boolean success) {
            context.stop();
            if (success) {
                NettyServerStreamRpcMetrics.this.onRequestSuccess(this.type);
            } else {
                NettyServerStreamRpcMetrics.this.onRequestFail(this.type);
            }
        }
    }

    public static enum RequestType {
        CHANNEL_READ,
        HEADER,
        LOCAL_WRITE,
        REMOTE_WRITE,
        STATE_MACHINE_STREAM,
        START_TRANSACTION;

        private final String numRequestsString;
        private final String successCountString;
        private final String failCountString;
        private final String latencyString;

        private RequestType() {
            String lower = this.name().toLowerCase(Locale.ENGLISH);
            this.numRequestsString = String.format(NettyServerStreamRpcMetrics.METRICS_NUM_REQUESTS, lower);
            this.successCountString = String.format(NettyServerStreamRpcMetrics.METRICS_SUCCESS, lower);
            this.failCountString = String.format(NettyServerStreamRpcMetrics.METRICS_FAIL, lower);
            this.latencyString = String.format(NettyServerStreamRpcMetrics.METRICS_LATENCY, lower);
        }

        String getNumRequestsString() {
            return this.numRequestsString;
        }

        String getSuccessCountString() {
            return this.successCountString;
        }

        String getFailCountString() {
            return this.failCountString;
        }

        String getLatencyString() {
            return this.latencyString;
        }
    }
}

