/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.org.apache.ratis.server;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.ozone.shaded.org.apache.ratis.protocol.RaftPeer;
import org.apache.ozone.shaded.org.apache.ratis.protocol.RaftPeerId;
import org.apache.ozone.shaded.org.apache.ratis.server.RaftServerRpc;
import org.apache.ozone.shaded.org.apache.ratis.util.JavaUtils;
import org.apache.ozone.shaded.org.apache.ratis.util.LifeCycle;
import org.apache.ozone.shaded.org.apache.ratis.util.PeerProxyMap;

public abstract class RaftServerRpcWithProxy<PROXY extends Closeable, PROXIES extends PeerProxyMap<PROXY>>
implements RaftServerRpc {
    private final Supplier<RaftPeerId> idSupplier;
    private final Supplier<LifeCycle> lifeCycleSupplier;
    private final Supplier<PROXIES> proxiesSupplier;

    protected RaftServerRpcWithProxy(Supplier<RaftPeerId> idSupplier, Function<RaftPeerId, PROXIES> proxyCreater) {
        this.idSupplier = idSupplier;
        this.lifeCycleSupplier = JavaUtils.memoize(() -> new LifeCycle(this.getId() + "-" + JavaUtils.getClassSimpleName(this.getClass())));
        this.proxiesSupplier = JavaUtils.memoize(() -> (PeerProxyMap)proxyCreater.apply(this.getId()));
    }

    public RaftPeerId getId() {
        return this.idSupplier.get();
    }

    private LifeCycle getLifeCycle() {
        return this.lifeCycleSupplier.get();
    }

    public PROXIES getProxies() {
        return (PROXIES)((PeerProxyMap)this.proxiesSupplier.get());
    }

    @Override
    public void addRaftPeers(Collection<RaftPeer> peers) {
        ((PeerProxyMap)this.getProxies()).addRaftPeers(peers);
    }

    @Override
    public void handleException(RaftPeerId serverId, Exception e, boolean reconnect) {
        ((PeerProxyMap)this.getProxies()).handleException(serverId, e, reconnect);
    }

    @Override
    public final void start() throws IOException {
        this.getLifeCycle().startAndTransition(this::startImpl, IOException.class);
    }

    protected abstract void startImpl() throws IOException;

    @Override
    public final void close() throws IOException {
        this.getLifeCycle().checkStateAndClose(this::closeImpl);
    }

    public void closeImpl() throws IOException {
        ((PeerProxyMap)this.getProxies()).close();
    }
}

