/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.client;

import java.util.Objects;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationFactor;
import org.apache.hadoop.hdds.client.ReplicationType;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.ozone.shaded.net.jcip.annotations.Immutable;

@Immutable
public class DefaultReplicationConfig {
    private final ECReplicationConfig ecReplicationConfig;
    private final ReplicationConfig replicationConfig;

    public DefaultReplicationConfig(ReplicationConfig replicationConfig) {
        this.replicationConfig = replicationConfig;
        this.ecReplicationConfig = replicationConfig instanceof ECReplicationConfig ? (ECReplicationConfig)replicationConfig : null;
    }

    public static DefaultReplicationConfig fromProto(HddsProtos.DefaultReplicationConfig proto) {
        if (proto == null) {
            throw new IllegalArgumentException("Invalid argument: default replication config is null");
        }
        ReplicationConfig config = proto.hasEcReplicationConfig() ? new ECReplicationConfig(proto.getEcReplicationConfig()) : ReplicationConfig.fromProtoTypeAndFactor(proto.getType(), proto.getFactor());
        return new DefaultReplicationConfig(config);
    }

    public ReplicationType getType() {
        return ReplicationType.fromProto(this.replicationConfig.getReplicationType());
    }

    public DefaultReplicationConfig copy() {
        return new DefaultReplicationConfig(this.replicationConfig);
    }

    public ReplicationConfig getReplicationConfig() {
        return this.replicationConfig;
    }

    public HddsProtos.DefaultReplicationConfig toProto() {
        HddsProtos.DefaultReplicationConfig.Builder builder = HddsProtos.DefaultReplicationConfig.newBuilder().setType(this.replicationConfig.getReplicationType());
        if (this.ecReplicationConfig != null) {
            builder.setEcReplicationConfig(this.ecReplicationConfig.toProto());
        } else {
            ReplicationFactor factor = ReplicationFactor.valueOf(this.replicationConfig.getRequiredNodes());
            builder.setFactor(factor.toProto());
        }
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultReplicationConfig that = (DefaultReplicationConfig)o;
        return Objects.equals(this.replicationConfig, that.replicationConfig);
    }

    public int hashCode() {
        return Objects.hash(this.replicationConfig);
    }

    public String toString() {
        return this.replicationConfig.toString();
    }
}

