/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.protocol;

import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.ozone.util.StringWithByteString;
import org.apache.hadoop.shaded.com.google.protobuf.ByteString;

public final class DatanodeID
implements Comparable<DatanodeID> {
    private static final ConcurrentMap<UUID, DatanodeID> CACHE = new ConcurrentHashMap<UUID, DatanodeID>();
    private final UUID uuid;
    private final StringWithByteString uuidByteString;

    private DatanodeID(UUID uuid) {
        this.uuid = uuid;
        this.uuidByteString = StringWithByteString.valueOf(uuid.toString());
    }

    public String getID() {
        return this.toString();
    }

    @Override
    public int compareTo(DatanodeID that) {
        return this.uuid.compareTo(that.uuid);
    }

    public boolean equals(Object obj) {
        return obj instanceof DatanodeID && this.uuid.equals(((DatanodeID)obj).uuid);
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public String toString() {
        return this.uuidByteString.getString();
    }

    @Deprecated
    public ByteString getByteString() {
        return this.uuidByteString.getBytes();
    }

    public PipelineID toPipelineID() {
        return PipelineID.valueOf(this.uuid);
    }

    public HddsProtos.DatanodeIDProto toProto() {
        return HddsProtos.DatanodeIDProto.newBuilder().setUuid(DatanodeID.toProto(this.uuid)).build();
    }

    public static DatanodeID fromProto(HddsProtos.DatanodeIDProto proto) {
        return DatanodeID.of(DatanodeID.fromProto(proto.getUuid()));
    }

    public static DatanodeID fromUuidString(String id) {
        return DatanodeID.of(UUID.fromString(id));
    }

    public static DatanodeID of(UUID id) {
        return CACHE.computeIfAbsent(id, DatanodeID::new);
    }

    public static DatanodeID of(HddsProtos.UUID uuid) {
        return DatanodeID.of(new UUID(uuid.getMostSigBits(), uuid.getLeastSigBits()));
    }

    public static DatanodeID randomID() {
        return new DatanodeID(UUID.randomUUID());
    }

    private static UUID fromProto(HddsProtos.UUID id) {
        return new UUID(id.getMostSigBits(), id.getLeastSigBits());
    }

    private static HddsProtos.UUID toProto(UUID id) {
        return HddsProtos.UUID.newBuilder().setMostSigBits(id.getMostSignificantBits()).setLeastSigBits(id.getLeastSignificantBits()).build();
    }

    @Deprecated
    public UUID getUuid() {
        return this.uuid;
    }
}

