/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.ratis.retrypolicy;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.ratis.conf.RatisClientConfig;
import org.apache.hadoop.hdds.ratis.retrypolicy.RetryPolicyCreator;
import org.apache.ozone.shaded.org.apache.ratis.retry.RetryPolicies;
import org.apache.ozone.shaded.org.apache.ratis.retry.RetryPolicy;
import org.apache.ozone.shaded.org.apache.ratis.util.TimeDuration;

public class RetryLimitedPolicyCreator
implements RetryPolicyCreator {
    @Override
    public RetryPolicy create(ConfigurationSource conf) {
        RatisClientConfig scmClientConfig = conf.getObject(RatisClientConfig.class);
        int maxRetryCount = scmClientConfig.getRetrylimitedMaxRetries();
        long retryInterval = scmClientConfig.getRetrylimitedRetryInterval();
        TimeDuration sleepDuration = TimeDuration.valueOf(retryInterval, TimeUnit.MILLISECONDS);
        RetryPolicies.RetryLimited retryPolicy = RetryPolicies.retryUpToMaximumCountWithFixedSleep(maxRetryCount, sleepDuration);
        return retryPolicy;
    }
}

