/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm;

import java.util.EnumMap;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.utils.IOUtils;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.ozone.util.PerformanceMetrics;
import org.apache.ozone.shaded.com.google.common.annotations.VisibleForTesting;

@InterfaceAudience.Private
@Metrics(about="Storage Container Client Metrics", context="dfs")
public class XceiverClientMetrics
implements MetricsSource {
    public static final String SOURCE_NAME = XceiverClientMetrics.class.getSimpleName();
    @Metric
    private MutableCounterLong pendingOps;
    @Metric
    private MutableCounterLong totalOps;
    @Metric
    private MutableCounterLong ecReconstructionTotal;
    @Metric
    private MutableCounterLong ecReconstructionFailsTotal;
    private EnumMap<ContainerProtos.Type, MutableCounterLong> pendingOpsArray;
    private EnumMap<ContainerProtos.Type, MutableCounterLong> opsArray;
    private EnumMap<ContainerProtos.Type, PerformanceMetrics> containerOpsLatency;
    private MetricsRegistry registry;

    public XceiverClientMetrics() {
        this.init();
    }

    public void init() {
        OzoneConfiguration conf = new OzoneConfiguration();
        int[] intervals = conf.getInts("ozone.xceiver.client.metrics.percentiles.intervals.seconds");
        this.registry = new MetricsRegistry(SOURCE_NAME);
        this.pendingOpsArray = new EnumMap(ContainerProtos.Type.class);
        this.opsArray = new EnumMap(ContainerProtos.Type.class);
        this.containerOpsLatency = new EnumMap(ContainerProtos.Type.class);
        for (ContainerProtos.Type type : ContainerProtos.Type.values()) {
            this.pendingOpsArray.put(type, this.registry.newCounter("numPending" + type, "number of pending" + type + " ops", 0L));
            this.opsArray.put(type, this.registry.newCounter("opCount" + type, "number of" + type + " ops", 0L));
            this.containerOpsLatency.put(type, new PerformanceMetrics(this.registry, type + "Latency", "latency of " + type, "Ops", "Time", intervals));
        }
    }

    public static XceiverClientMetrics create() {
        DefaultMetricsSystem.initialize((String)SOURCE_NAME);
        MetricsSystem ms = DefaultMetricsSystem.instance();
        return (XceiverClientMetrics)ms.register(SOURCE_NAME, "Storage Container Client Metrics", (Object)new XceiverClientMetrics());
    }

    public void incrPendingContainerOpsMetrics(ContainerProtos.Type type) {
        this.pendingOps.incr();
        this.totalOps.incr();
        this.opsArray.get(type).incr();
        this.pendingOpsArray.get(type).incr();
    }

    public void decrPendingContainerOpsMetrics(ContainerProtos.Type type) {
        this.pendingOps.incr(-1L);
        this.pendingOpsArray.get(type).incr(-1L);
    }

    public void addContainerOpsLatency(ContainerProtos.Type type, long latencyMillis) {
        this.containerOpsLatency.get(type).add(latencyMillis);
    }

    public long getPendingContainerOpCountMetrics(ContainerProtos.Type type) {
        return this.pendingOpsArray.get(type).value();
    }

    public void incECReconstructionTotal() {
        this.ecReconstructionTotal.incr();
    }

    public void incECReconstructionFailsTotal() {
        this.ecReconstructionFailsTotal.incr();
    }

    @VisibleForTesting
    public long getTotalOpCount() {
        return this.totalOps.value();
    }

    @VisibleForTesting
    public long getContainerOpCountMetrics(ContainerProtos.Type type) {
        return this.opsArray.get(type).value();
    }

    @VisibleForTesting
    public void reset() {
        this.init();
    }

    public void unRegister() {
        IOUtils.closeQuietly(this.containerOpsLatency.values());
        MetricsSystem ms = DefaultMetricsSystem.instance();
        ms.unregisterSource(SOURCE_NAME);
    }

    public void getMetrics(MetricsCollector collector, boolean b) {
        MetricsRecordBuilder recordBuilder = collector.addRecord(SOURCE_NAME);
        this.pendingOps.snapshot(recordBuilder, true);
        this.totalOps.snapshot(recordBuilder, true);
        this.ecReconstructionTotal.snapshot(recordBuilder, true);
        this.ecReconstructionFailsTotal.snapshot(recordBuilder, true);
        for (ContainerProtos.Type type : ContainerProtos.Type.values()) {
            this.pendingOpsArray.get(type).snapshot(recordBuilder, b);
            this.opsArray.get(type).snapshot(recordBuilder, b);
            this.containerOpsLatency.get(type).snapshot(recordBuilder, b);
        }
    }
}

