/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.client.DefaultReplicationConfig;
import org.apache.hadoop.hdds.protocol.StorageType;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.ozone.shaded.com.google.common.collect.ImmutableList;
import org.apache.ozone.shaded.com.google.common.collect.ImmutableMap;
import org.apache.ozone.shaded.net.jcip.annotations.Immutable;

@Immutable
public final class BucketArgs {
    private final ImmutableList<OzoneAcl> acls;
    private final boolean versioning;
    private final StorageType storageType;
    private final Map<String, String> metadata;
    private final String bucketEncryptionKey;
    private final DefaultReplicationConfig defaultReplicationConfig;
    private final String sourceVolume;
    private final String sourceBucket;
    private final long quotaInBytes;
    private final long quotaInNamespace;
    private final String owner;
    private final BucketLayout bucketLayout;

    private BucketArgs(Builder b) {
        this.acls = b.acls == null ? ImmutableList.of() : ImmutableList.copyOf(b.acls);
        this.versioning = b.versioning;
        this.storageType = b.storageType;
        this.metadata = b.metadata == null ? ImmutableMap.of() : ImmutableMap.copyOf(b.metadata);
        this.bucketEncryptionKey = b.bucketEncryptionKey;
        this.sourceVolume = b.sourceVolume;
        this.sourceBucket = b.sourceBucket;
        this.quotaInBytes = b.quotaInBytes;
        this.quotaInNamespace = b.quotaInNamespace;
        this.bucketLayout = b.bucketLayout;
        this.owner = b.owner;
        this.defaultReplicationConfig = b.defaultReplicationConfig;
    }

    public boolean getVersioning() {
        return this.versioning;
    }

    public StorageType getStorageType() {
        return this.storageType;
    }

    public List<OzoneAcl> getAcls() {
        return this.acls;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public String getEncryptionKey() {
        return this.bucketEncryptionKey;
    }

    public DefaultReplicationConfig getDefaultReplicationConfig() {
        return this.defaultReplicationConfig;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getSourceVolume() {
        return this.sourceVolume;
    }

    public String getSourceBucket() {
        return this.sourceBucket;
    }

    public long getQuotaInBytes() {
        return this.quotaInBytes;
    }

    public long getQuotaInNamespace() {
        return this.quotaInNamespace;
    }

    public BucketLayout getBucketLayout() {
        return this.bucketLayout;
    }

    public String getOwner() {
        return this.owner;
    }

    public static class Builder {
        private boolean versioning;
        private StorageType storageType;
        private List<OzoneAcl> acls;
        private Map<String, String> metadata;
        private String bucketEncryptionKey;
        private String sourceVolume;
        private String sourceBucket;
        private long quotaInBytes = -1L;
        private long quotaInNamespace = -1L;
        private BucketLayout bucketLayout;
        private String owner;
        private DefaultReplicationConfig defaultReplicationConfig;

        public Builder setVersioning(boolean versionFlag) {
            this.versioning = versionFlag;
            return this;
        }

        public Builder setStorageType(StorageType storage) {
            this.storageType = storage;
            return this;
        }

        public Builder addAcl(OzoneAcl acl) {
            if (this.acls == null) {
                this.acls = new ArrayList<OzoneAcl>();
            }
            this.acls.add(acl);
            return this;
        }

        public Builder addMetadata(String key, String value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public Builder setBucketEncryptionKey(String bek) {
            this.bucketEncryptionKey = bek;
            return this;
        }

        public Builder setSourceVolume(String volume) {
            this.sourceVolume = volume;
            return this;
        }

        public Builder setSourceBucket(String bucket) {
            this.sourceBucket = bucket;
            return this;
        }

        public Builder setQuotaInBytes(long quota) {
            this.quotaInBytes = quota;
            return this;
        }

        public Builder setQuotaInNamespace(long quota) {
            this.quotaInNamespace = quota;
            return this;
        }

        public Builder setBucketLayout(BucketLayout buckLayout) {
            this.bucketLayout = buckLayout;
            return this;
        }

        public Builder setOwner(String ownerName) {
            this.owner = ownerName;
            return this;
        }

        public Builder setDefaultReplicationConfig(DefaultReplicationConfig defaultReplConfig) {
            this.defaultReplicationConfig = defaultReplConfig;
            return this;
        }

        public BucketArgs build() {
            return new BucketArgs(this);
        }
    }
}

