/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.common;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.hadoop.ozone.common.Checksum;
import org.apache.hadoop.ozone.common.ChunkBuffer;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChecksumCache {
    private static final Logger LOG = LoggerFactory.getLogger(ChecksumCache.class);
    private final int bytesPerChecksum;
    private final List<ByteString> checksums;
    private int prevChunkLength;
    private static final int BLOCK_CHUNK_SIZE = 0x400000;

    public ChecksumCache(int bytesPerChecksum) {
        LOG.debug("Initializing ChecksumCache with bytesPerChecksum = {}", (Object)bytesPerChecksum);
        this.prevChunkLength = 0;
        this.bytesPerChecksum = bytesPerChecksum;
        this.checksums = new ArrayList<ByteString>(0x400000 / bytesPerChecksum);
    }

    public void clear() {
        this.prevChunkLength = 0;
        this.checksums.clear();
    }

    public List<ByteString> getChecksums() {
        return this.checksums;
    }

    public List<ByteString> computeChecksum(ChunkBuffer data, Function<ByteBuffer, ByteString> function) {
        int currChunkLength = data.limit();
        if (currChunkLength == this.prevChunkLength) {
            LOG.debug("ChunkBuffer data limit same as last time ({}). No new checksums need to be computed", (Object)this.prevChunkLength);
            return this.checksums;
        }
        if (currChunkLength < this.prevChunkLength) {
            throw new IllegalArgumentException("ChunkBuffer data limit (" + currChunkLength + ") must not be smaller than last time (" + this.prevChunkLength + ")");
        }
        int ciStart = this.prevChunkLength / this.bytesPerChecksum;
        int ciEnd = currChunkLength / this.bytesPerChecksum + (currChunkLength % this.bytesPerChecksum == 0 ? 0 : 1);
        int i = 0;
        for (ByteBuffer b : data.iterate(this.bytesPerChecksum)) {
            if (i < ciStart) {
                ++i;
                continue;
            }
            assert (i == this.checksums.size() - 1 || i == this.checksums.size());
            ByteString checksum = Checksum.computeChecksum(b, function, this.bytesPerChecksum);
            if (i == this.checksums.size()) {
                this.checksums.add(checksum);
            } else {
                this.checksums.set(i, checksum);
            }
            ++i;
        }
        if (i != ciEnd) {
            throw new IllegalStateException("ChecksumCache: Checksum index end does not match expectation");
        }
        this.prevChunkLength = currChunkLength;
        return this.checksums;
    }
}

