/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.common;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.hadoop.hdds.scm.ByteStringConversion;
import org.apache.hadoop.ozone.common.ChunkBufferToByteStringByByteBufs;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.io.netty.buffer.ByteBuf;

public interface ChunkBufferToByteString {
    public static ChunkBufferToByteString wrap(List<ByteBuf> buffers) {
        return new ChunkBufferToByteStringByByteBufs(buffers);
    }

    default public void release() {
    }

    default public ByteString toByteString(Function<ByteBuffer, ByteString> function) {
        return this.toByteStringImpl(b -> ChunkBufferToByteString.applyAndAssertFunction(b, function, this));
    }

    default public List<ByteString> toByteStringList(Function<ByteBuffer, ByteString> function) {
        return this.toByteStringListImpl(b -> ChunkBufferToByteString.applyAndAssertFunction(b, function, this));
    }

    default public ByteString toByteString() {
        return this.toByteString(ByteStringConversion::safeWrap);
    }

    public ByteString toByteStringImpl(Function<ByteBuffer, ByteString> var1);

    public List<ByteString> toByteStringListImpl(Function<ByteBuffer, ByteString> var1);

    public static void assertInt(int expected, int computed, Supplier<String> prefix) {
        if (expected != computed) {
            throw new IllegalStateException(prefix.get() + ": expected = " + expected + " but computed = " + computed);
        }
    }

    public static ByteString applyAndAssertFunction(ByteBuffer buffer, Function<ByteBuffer, ByteString> function, Object name) {
        int pos = buffer.position();
        int lim = buffer.limit();
        ByteString bytes = function.apply(buffer);
        ChunkBufferToByteString.assertInt(pos, buffer.position(), () -> name + ": Unexpected position");
        ChunkBufferToByteString.assertInt(lim, buffer.limit(), () -> name + ": Unexpected limit");
        return bytes;
    }
}

