/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.hdds.utils.io.ByteBufferInputStream;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.shaded.com.google.protobuf.TextFormat;
import org.apache.ozone.shaded.org.apache.ratis.proto.RaftProtos;
import org.apache.ozone.shaded.org.apache.ratis.protocol.Message;
import org.apache.ozone.shaded.org.apache.ratis.protocol.RaftClientReply;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ozone.shaded.org.apache.ratis.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OMRatisHelper {
    private static final Logger LOG = LoggerFactory.getLogger(OMRatisHelper.class);

    private OMRatisHelper() {
    }

    public static ByteString convertRequestToByteString(OzoneManagerProtocolProtos.OMRequest request) {
        return UnsafeByteOperations.unsafeWrap(request.toByteString().asReadOnlyByteBuffer());
    }

    public static OzoneManagerProtocolProtos.OMRequest convertByteStringToOMRequest(ByteString bytes) throws IOException {
        ByteBuffer buffer = bytes.asReadOnlyByteBuffer();
        return OzoneManagerProtocolProtos.OMRequest.parseFrom(new ByteBufferInputStream(buffer));
    }

    public static Message convertResponseToMessage(OzoneManagerProtocolProtos.OMResponse response) {
        return () -> UnsafeByteOperations.unsafeWrap(response.toByteString().asReadOnlyByteBuffer());
    }

    public static OzoneManagerProtocolProtos.OMResponse convertByteStringToOMResponse(ByteString bytes) throws IOException {
        ByteBuffer buffer = bytes.asReadOnlyByteBuffer();
        return OzoneManagerProtocolProtos.OMResponse.parseFrom(new ByteBufferInputStream(buffer));
    }

    public static OzoneManagerProtocolProtos.OMResponse getOMResponseFromRaftClientReply(RaftClientReply reply) throws IOException {
        OzoneManagerProtocolProtos.OMResponse response = OMRatisHelper.convertByteStringToOMResponse(reply.getMessage().getContent());
        if (reply.getReplierId().equals(response.getLeaderOMNodeId())) {
            return response;
        }
        return OzoneManagerProtocolProtos.OMResponse.newBuilder(response).setLeaderOMNodeId(reply.getReplierId()).build();
    }

    public static String smProtoToString(RaftProtos.StateMachineLogEntryProto proto) {
        try {
            OzoneManagerProtocolProtos.OMRequest request = OMRatisHelper.convertByteStringToOMRequest(proto.getLogData());
            return TextFormat.shortDebugString(request);
        }
        catch (Throwable ex) {
            LOG.info("smProtoToString failed", ex);
            return "Failed to smProtoToString: " + ex;
        }
    }
}

