/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.security.acl;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.security.acl.AssumeRoleRequest;
import org.apache.hadoop.ozone.security.acl.IOzoneObj;
import org.apache.hadoop.ozone.security.acl.RequestContext;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "Yarn", "Ranger", "Hive", "HBase"})
@InterfaceStability.Evolving
public interface IAccessAuthorizer {
    public boolean checkAccess(IOzoneObj var1, RequestContext var2) throws OMException;

    default public String generateAssumeRoleSessionPolicy(AssumeRoleRequest assumeRoleRequest) throws OMException {
        throw new OMException("The generateAssumeRoleSessionPolicy call is not supported", OMException.ResultCodes.NOT_SUPPORTED_OPERATION);
    }

    default public boolean isNative() {
        return false;
    }

    public static enum ACLIdentityType {
        USER("user"),
        GROUP("group"),
        WORLD("world"),
        ANONYMOUS("anonymous"),
        CLIENT_IP("ip");

        private final String value;

        private ACLIdentityType(String val) {
            this.value = val;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum ACLType {
        READ,
        WRITE,
        CREATE,
        LIST,
        DELETE,
        READ_ACL,
        WRITE_ACL,
        ALL,
        NONE,
        ASSUME_ROLE;

        private static int length;
        private static ACLType[] vals;

        public static int getNoOfAcls() {
            return length;
        }

        public static ACLType getAclTypeFromOrdinal(int ordinal) {
            if (ordinal > length - 1 && ordinal > -1) {
                throw new IllegalArgumentException("Ordinal greater than array length. ordinal:" + ordinal);
            }
            return vals[ordinal];
        }

        public static ACLType getACLRight(String type) {
            if (type == null || type.isEmpty()) {
                throw new IllegalArgumentException("ACL right cannot be empty");
            }
            switch (type) {
                case "r": {
                    return READ;
                }
                case "w": {
                    return WRITE;
                }
                case "c": {
                    return CREATE;
                }
                case "d": {
                    return DELETE;
                }
                case "l": {
                    return LIST;
                }
                case "x": {
                    return READ_ACL;
                }
                case "y": {
                    return WRITE_ACL;
                }
                case "a": {
                    return ALL;
                }
                case "n": {
                    return NONE;
                }
                case "m": {
                    return ASSUME_ROLE;
                }
            }
            throw new IllegalArgumentException("[" + type + "] ACL right is not recognized");
        }

        public static String getACLString(BitSet acls) {
            StringBuffer sb = new StringBuffer();
            acls.stream().forEach(acl -> sb.append(ACLType.getAclString(ACLType.values()[acl])));
            return sb.toString();
        }

        public static String getAclString(ACLType acl) {
            switch (acl.ordinal()) {
                case 0: {
                    return "r";
                }
                case 1: {
                    return "w";
                }
                case 2: {
                    return "c";
                }
                case 4: {
                    return "d";
                }
                case 3: {
                    return "l";
                }
                case 5: {
                    return "x";
                }
                case 6: {
                    return "y";
                }
                case 7: {
                    return "a";
                }
                case 8: {
                    return "n";
                }
                case 9: {
                    return "m";
                }
            }
            throw new IllegalArgumentException("ACL right is not recognized");
        }

        public static Set<ACLType> parseList(String conf) {
            String[] array = Objects.requireNonNull(conf, "conf == null").trim().split(",");
            return Collections.unmodifiableSet(Arrays.stream(array).map(each -> ACLType.valueOf(each.trim())).collect(Collectors.toCollection(() -> EnumSet.noneOf(ACLType.class))));
        }

        static {
            length = ACLType.values().length;
            if (length > 16) {
                throw new AssertionError((Object)("BUG: Length = " + length + " > 16, check the commit of this change and update the code."));
            }
            vals = ACLType.values();
        }
    }
}

