/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.io.grpc.netty;

import java.net.InetSocketAddress;
import org.apache.ozone.shaded.io.grpc.Internal;
import org.apache.ozone.shaded.io.grpc.ServerCredentials;
import org.apache.ozone.shaded.io.grpc.ServerProvider;
import org.apache.ozone.shaded.io.grpc.netty.NettyServerBuilder;
import org.apache.ozone.shaded.io.grpc.netty.ProtocolNegotiators;

@Internal
public final class NettyServerProvider
extends ServerProvider {
    @Override
    protected boolean isAvailable() {
        return true;
    }

    @Override
    protected int priority() {
        return 5;
    }

    protected NettyServerBuilder builderForPort(int port) {
        return NettyServerBuilder.forPort(port);
    }

    @Override
    protected ServerProvider.NewServerBuilderResult newServerBuilderForPort(int port, ServerCredentials creds) {
        ProtocolNegotiators.FromServerCredentialsResult result2 = ProtocolNegotiators.from(creds);
        if (result2.error != null) {
            return ServerProvider.NewServerBuilderResult.error(result2.error);
        }
        return ServerProvider.NewServerBuilderResult.serverBuilder(new NettyServerBuilder(new InetSocketAddress(port), result2.negotiator));
    }
}

