/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.io.grpc.stub;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ozone.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.ozone.shaded.com.google.common.base.Preconditions;
import org.apache.ozone.shaded.com.google.common.base.Predicate;
import org.apache.ozone.shaded.io.grpc.ClientCall;
import org.apache.ozone.shaded.io.grpc.ExperimentalApi;
import org.apache.ozone.shaded.io.grpc.Metadata;
import org.apache.ozone.shaded.io.grpc.Status;
import org.apache.ozone.shaded.io.grpc.StatusException;
import org.apache.ozone.shaded.io.grpc.stub.ClientCalls;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/10918")
public final class BlockingClientCall<ReqT, RespT> {
    private static final Logger logger = Logger.getLogger(BlockingClientCall.class.getName());
    private final BlockingQueue<RespT> buffer;
    private final ClientCall<ReqT, RespT> call;
    private final ClientCalls.ThreadSafeThreadlessExecutor executor;
    private boolean writeClosed;
    private volatile Status closedStatus;

    BlockingClientCall(ClientCall<ReqT, RespT> call, ClientCalls.ThreadSafeThreadlessExecutor executor) {
        this.call = call;
        this.executor = executor;
        this.buffer = new ArrayBlockingQueue<RespT>(1);
    }

    public RespT read() throws InterruptedException, StatusException {
        try {
            return this.read(true, 0L, TimeUnit.NANOSECONDS);
        }
        catch (TimeoutException e) {
            throw new AssertionError("should never happen", e);
        }
    }

    public RespT read(long timeout2, TimeUnit unit) throws InterruptedException, TimeoutException, StatusException {
        return this.read(false, timeout2, unit);
    }

    private RespT read(boolean waitForever, long timeout2, TimeUnit unit) throws InterruptedException, TimeoutException, StatusException {
        long start = System.nanoTime();
        long end = start + unit.toNanos(timeout2);
        Predicate predicate = BlockingClientCall::skipWaitingForRead;
        this.executor.waitAndDrainWithTimeout(waitForever, end, predicate, this);
        Object bufferedValue = this.buffer.poll();
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Client Blocking read had value:  " + bufferedValue);
        }
        if (bufferedValue != null) {
            this.call.request(1);
            return (RespT)bufferedValue;
        }
        Status currentClosedStatus = this.closedStatus;
        if (currentClosedStatus == null) {
            throw new IllegalStateException("The message disappeared... are you reading from multiple threads?");
        }
        if (!currentClosedStatus.isOk()) {
            throw currentClosedStatus.asException();
        }
        return null;
    }

    boolean skipWaitingForRead() {
        return this.closedStatus != null || !this.buffer.isEmpty();
    }

    public boolean hasNext() throws InterruptedException, StatusException {
        this.executor.waitAndDrain(x -> !x.buffer.isEmpty() || x.closedStatus != null, this);
        Status currentClosedStatus = this.closedStatus;
        if (currentClosedStatus != null && !currentClosedStatus.isOk()) {
            throw currentClosedStatus.asException();
        }
        return !this.buffer.isEmpty();
    }

    public boolean write(ReqT request) throws InterruptedException, StatusException {
        try {
            return this.write(true, request, Integer.MAX_VALUE, TimeUnit.DAYS);
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean write(ReqT request, long timeout2, TimeUnit unit) throws InterruptedException, TimeoutException, StatusException {
        return this.write(false, request, timeout2, unit);
    }

    private boolean write(boolean waitForever, ReqT request, long timeout2, TimeUnit unit) throws InterruptedException, TimeoutException, StatusException {
        if (this.writeClosed) {
            throw new IllegalStateException("Writes cannot be done after calling halfClose or cancel");
        }
        long end = System.nanoTime() + unit.toNanos(timeout2);
        Predicate predicate = x -> x.call.isReady() || x.closedStatus != null;
        this.executor.waitAndDrainWithTimeout(waitForever, end, predicate, this);
        Status savedClosedStatus = this.closedStatus;
        if (savedClosedStatus == null) {
            this.call.sendMessage(request);
            return true;
        }
        if (savedClosedStatus.isOk()) {
            return false;
        }
        throw savedClosedStatus.asException();
    }

    void sendSingleRequest(ReqT request) {
        this.call.sendMessage(request);
    }

    public void cancel(String message, Throwable cause) {
        this.writeClosed = true;
        this.call.cancel(message, cause);
    }

    public void halfClose() {
        if (this.writeClosed) {
            throw new IllegalStateException("halfClose cannot be called after already half closed or cancelled");
        }
        this.writeClosed = true;
        this.call.halfClose();
    }

    @VisibleForTesting
    Status getClosedStatus() {
        this.drainQuietly();
        return this.closedStatus;
    }

    @VisibleForTesting
    boolean isEitherReadOrWriteReady() {
        return this.isWriteLegal() && this.isWriteReady() || this.isReadReady();
    }

    @VisibleForTesting
    boolean isReadReady() {
        this.drainQuietly();
        return !this.buffer.isEmpty();
    }

    @VisibleForTesting
    boolean isWriteReady() {
        this.drainQuietly();
        return this.isWriteLegal() && this.call.isReady();
    }

    private boolean isWriteLegal() {
        return !this.writeClosed && this.closedStatus == null;
    }

    ClientCall.Listener<RespT> getListener() {
        return new QueuingListener();
    }

    private void drainQuietly() {
        try {
            this.executor.drain();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private final class QueuingListener
    extends ClientCall.Listener<RespT> {
        private QueuingListener() {
        }

        @Override
        public void onMessage(RespT value) {
            Preconditions.checkState(BlockingClientCall.this.closedStatus == null, "ClientCall already closed");
            BlockingClientCall.this.buffer.add(value);
        }

        @Override
        public void onClose(Status status, Metadata trailers) {
            Preconditions.checkState(BlockingClientCall.this.closedStatus == null, "ClientCall already closed");
            BlockingClientCall.this.closedStatus = status;
        }
    }
}

