/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.shaded.io.opentelemetry.exporter.internal.otlp.metrics;

import java.io.IOException;
import java.util.List;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.marshal.MarshalerContext;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.marshal.Serializer;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.marshal.StatelessMarshaler;
import org.apache.ozone.shaded.io.opentelemetry.exporter.internal.otlp.metrics.ExponentialHistogramBucketsMarshaler;
import org.apache.ozone.shaded.io.opentelemetry.proto.metrics.v1.internal.ExponentialHistogramDataPoint;
import org.apache.ozone.shaded.io.opentelemetry.sdk.internal.DynamicPrimitiveLongList;
import org.apache.ozone.shaded.io.opentelemetry.sdk.internal.PrimitiveLongList;
import org.apache.ozone.shaded.io.opentelemetry.sdk.metrics.data.ExponentialHistogramBuckets;

final class ExponentialHistogramBucketsStatelessMarshaler
implements StatelessMarshaler<ExponentialHistogramBuckets> {
    static final ExponentialHistogramBucketsStatelessMarshaler INSTANCE = new ExponentialHistogramBucketsStatelessMarshaler();

    private ExponentialHistogramBucketsStatelessMarshaler() {
    }

    @Override
    public void writeTo(Serializer output, ExponentialHistogramBuckets buckets, MarshalerContext context) throws IOException {
        output.serializeSInt32(ExponentialHistogramDataPoint.Buckets.OFFSET, buckets.getOffset());
        List<Long> counts = buckets.getBucketCounts();
        if (counts instanceof DynamicPrimitiveLongList) {
            output.serializeRepeatedUInt64(ExponentialHistogramDataPoint.Buckets.BUCKET_COUNTS, (DynamicPrimitiveLongList)counts);
        } else {
            output.serializeRepeatedUInt64(ExponentialHistogramDataPoint.Buckets.BUCKET_COUNTS, PrimitiveLongList.toArray(counts));
        }
    }

    @Override
    public int getBinarySerializedSize(ExponentialHistogramBuckets buckets, MarshalerContext context) {
        return ExponentialHistogramBucketsMarshaler.calculateSize(buckets.getOffset(), buckets.getBucketCounts());
    }
}

